# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._authorization_login_links_operations import build_post_request
from .._vendor import ApiManagementClientMixinABC

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AuthorizationLoginLinksOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.apimanagement.aio.ApiManagementClient`'s
        :attr:`authorization_login_links` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def post(
        self,
        resource_group_name: str,
        service_name: str,
        authorization_provider_id: str,
        authorization_id: str,
        parameters: _models.AuthorizationLoginRequestContract,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AuthorizationLoginResponseContract:
        """Gets authorization login links.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param service_name: The name of the API Management service. Required.
        :type service_name: str
        :param authorization_provider_id: Identifier of the authorization provider. Required.
        :type authorization_provider_id: str
        :param authorization_id: Identifier of the authorization. Required.
        :type authorization_id: str
        :param parameters: Create parameters. Required.
        :type parameters: ~azure.mgmt.apimanagement.models.AuthorizationLoginRequestContract
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AuthorizationLoginResponseContract or the result of cls(response)
        :rtype: ~azure.mgmt.apimanagement.models.AuthorizationLoginResponseContract
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def post(
        self,
        resource_group_name: str,
        service_name: str,
        authorization_provider_id: str,
        authorization_id: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AuthorizationLoginResponseContract:
        """Gets authorization login links.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param service_name: The name of the API Management service. Required.
        :type service_name: str
        :param authorization_provider_id: Identifier of the authorization provider. Required.
        :type authorization_provider_id: str
        :param authorization_id: Identifier of the authorization. Required.
        :type authorization_id: str
        :param parameters: Create parameters. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AuthorizationLoginResponseContract or the result of cls(response)
        :rtype: ~azure.mgmt.apimanagement.models.AuthorizationLoginResponseContract
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def post(
        self,
        resource_group_name: str,
        service_name: str,
        authorization_provider_id: str,
        authorization_id: str,
        parameters: Union[_models.AuthorizationLoginRequestContract, IO[bytes]],
        **kwargs: Any
    ) -> _models.AuthorizationLoginResponseContract:
        """Gets authorization login links.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param service_name: The name of the API Management service. Required.
        :type service_name: str
        :param authorization_provider_id: Identifier of the authorization provider. Required.
        :type authorization_provider_id: str
        :param authorization_id: Identifier of the authorization. Required.
        :type authorization_id: str
        :param parameters: Create parameters. Is either a AuthorizationLoginRequestContract type or a
         IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.apimanagement.models.AuthorizationLoginRequestContract or
         IO[bytes]
        :return: AuthorizationLoginResponseContract or the result of cls(response)
        :rtype: ~azure.mgmt.apimanagement.models.AuthorizationLoginResponseContract
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AuthorizationLoginResponseContract] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "AuthorizationLoginRequestContract")

        _request = build_post_request(
            resource_group_name=resource_group_name,
            service_name=service_name,
            authorization_provider_id=authorization_provider_id,
            authorization_id=authorization_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("AuthorizationLoginResponseContract", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore
