# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, Union

import msrest.serialization

from ._direct_methodsfor_live_video_analyticson_io_tedge_enums import *


class MethodRequest(msrest.serialization.Model):
    """Base Class for Method Requests.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MediaGraphInstanceListRequest, MediaGraphInstanceSetRequest, MediaGraphTopologyListRequest, MediaGraphTopologySetRequest, ItemNonSetRequestBase, MediaGraphInstanceSetRequestBody, MediaGraphTopologySetRequestBody.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar method_name: Required. method name.Constant filled by server.
    :vartype method_name: str
    :ivar api_version: api version. Default value: "2.0".
    :vartype api_version: str
    """

    _validation = {
        'method_name': {'required': True, 'readonly': True},
        'api_version': {'constant': True},
    }

    _attribute_map = {
        'method_name': {'key': 'methodName', 'type': 'str'},
        'api_version': {'key': '@apiVersion', 'type': 'str'},
    }

    _subtype_map = {
        'method_name': {'GraphInstanceList': 'MediaGraphInstanceListRequest', 'GraphInstanceSet': 'MediaGraphInstanceSetRequest', 'GraphTopologyList': 'MediaGraphTopologyListRequest', 'GraphTopologySet': 'MediaGraphTopologySetRequest', 'ItemNonSetRequestBase': 'ItemNonSetRequestBase', 'MediaGraphInstanceSetRequestBody': 'MediaGraphInstanceSetRequestBody', 'MediaGraphTopologySetRequestBody': 'MediaGraphTopologySetRequestBody'}
    }

    api_version = "2.0"

    def __init__(
        self,
        **kwargs
    ):
        super(MethodRequest, self).__init__(**kwargs)
        self.method_name = None  # type: Optional[str]


class ItemNonSetRequestBase(MethodRequest):
    """ItemNonSetRequestBase.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MediaGraphInstanceActivateRequest, MediaGraphInstanceDeActivateRequest, MediaGraphInstanceDeleteRequest, MediaGraphInstanceGetRequest, MediaGraphTopologyDeleteRequest, MediaGraphTopologyGetRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar method_name: Required. method name.Constant filled by server.
    :vartype method_name: str
    :ivar api_version: api version. Default value: "2.0".
    :vartype api_version: str
    :param name: Required. method name.
    :type name: str
    """

    _validation = {
        'method_name': {'required': True, 'readonly': True},
        'api_version': {'constant': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'method_name': {'key': 'methodName', 'type': 'str'},
        'api_version': {'key': '@apiVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'method_name': {'GraphInstanceActivate': 'MediaGraphInstanceActivateRequest', 'GraphInstanceDeactivate': 'MediaGraphInstanceDeActivateRequest', 'GraphInstanceDelete': 'MediaGraphInstanceDeleteRequest', 'GraphInstanceGet': 'MediaGraphInstanceGetRequest', 'GraphTopologyDelete': 'MediaGraphTopologyDeleteRequest', 'GraphTopologyGet': 'MediaGraphTopologyGetRequest'}
    }

    api_version = "2.0"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(ItemNonSetRequestBase, self).__init__(**kwargs)
        self.method_name = 'ItemNonSetRequestBase'  # type: str
        self.name = name


class MediaGraphSink(msrest.serialization.Model):
    """Enables a media graph to write media data to a destination outside of the Live Video Analytics IoT Edge module.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MediaGraphAssetSink, MediaGraphFileSink, MediaGraphIoTHubMessageSink.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. The name to be used for the media graph sink.
    :type name: str
    :param inputs: Required. An array of the names of the other nodes in the media graph, the
     outputs of which are used as input for this sink node.
    :type inputs: list[~azure.media.analyticsedge.models.MediaGraphNodeInput]
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[MediaGraphNodeInput]'},
    }

    _subtype_map = {
        'type': {'#Microsoft.Media.MediaGraphAssetSink': 'MediaGraphAssetSink', '#Microsoft.Media.MediaGraphFileSink': 'MediaGraphFileSink', '#Microsoft.Media.MediaGraphIoTHubMessageSink': 'MediaGraphIoTHubMessageSink'}
    }

    def __init__(
        self,
        *,
        name: str,
        inputs: List["MediaGraphNodeInput"],
        **kwargs
    ):
        super(MediaGraphSink, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.name = name
        self.inputs = inputs


class MediaGraphAssetSink(MediaGraphSink):
    """Enables a media graph to record media to an Azure Media Services asset for subsequent playback.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. The name to be used for the media graph sink.
    :type name: str
    :param inputs: Required. An array of the names of the other nodes in the media graph, the
     outputs of which are used as input for this sink node.
    :type inputs: list[~azure.media.analyticsedge.models.MediaGraphNodeInput]
    :param asset_name_pattern: Required. A name pattern when creating new assets. The pattern must
     include at least one system variable. See the documentation for available variables and
     additional examples.
    :type asset_name_pattern: str
    :param segment_length: When writing media to an asset, wait until at least this duration of
     media has been accumulated on the Edge. Expressed in increments of 30 seconds, with a minimum
     of 30 seconds and a recommended maximum of 5 minutes.
    :type segment_length: str
    :param local_media_cache_path: Required. Path to a local file system directory for temporary
     caching of media before writing to an Asset. Used when the Edge device is temporarily
     disconnected from Azure.
    :type local_media_cache_path: str
    :param local_media_cache_maximum_size_mi_b: Required. Maximum amount of disk space that can be
     used for temporary caching of media.
    :type local_media_cache_maximum_size_mi_b: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
        'asset_name_pattern': {'required': True},
        'local_media_cache_path': {'required': True},
        'local_media_cache_maximum_size_mi_b': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[MediaGraphNodeInput]'},
        'asset_name_pattern': {'key': 'assetNamePattern', 'type': 'str'},
        'segment_length': {'key': 'segmentLength', 'type': 'str'},
        'local_media_cache_path': {'key': 'localMediaCachePath', 'type': 'str'},
        'local_media_cache_maximum_size_mi_b': {'key': 'localMediaCacheMaximumSizeMiB', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        inputs: List["MediaGraphNodeInput"],
        asset_name_pattern: str,
        local_media_cache_path: str,
        local_media_cache_maximum_size_mi_b: str,
        segment_length: Optional[str] = None,
        **kwargs
    ):
        super(MediaGraphAssetSink, self).__init__(name=name, inputs=inputs, **kwargs)
        self.type = '#Microsoft.Media.MediaGraphAssetSink'  # type: str
        self.asset_name_pattern = asset_name_pattern
        self.segment_length = segment_length
        self.local_media_cache_path = local_media_cache_path
        self.local_media_cache_maximum_size_mi_b = local_media_cache_maximum_size_mi_b


class MediaGraphCertificateSource(msrest.serialization.Model):
    """Base class for certificate sources.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MediaGraphPemCertificateList.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.Media.MediaGraphPemCertificateList': 'MediaGraphPemCertificateList'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaGraphCertificateSource, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class MediaGraphProcessor(msrest.serialization.Model):
    """A node that represents the desired processing of media in a graph. Takes media and/or events as inputs, and emits media and/or event as output.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MediaGraphExtensionProcessorBase, MediaGraphMotionDetectionProcessor, MediaGraphSignalGateProcessor.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. The name for this processor node.
    :type name: str
    :param inputs: Required. An array of the names of the other nodes in the media graph, the
     outputs of which are used as input for this processor node.
    :type inputs: list[~azure.media.analyticsedge.models.MediaGraphNodeInput]
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[MediaGraphNodeInput]'},
    }

    _subtype_map = {
        'type': {'#Microsoft.Media.MediaGraphExtensionProcessorBase': 'MediaGraphExtensionProcessorBase', '#Microsoft.Media.MediaGraphMotionDetectionProcessor': 'MediaGraphMotionDetectionProcessor', '#Microsoft.Media.MediaGraphSignalGateProcessor': 'MediaGraphSignalGateProcessor'}
    }

    def __init__(
        self,
        *,
        name: str,
        inputs: List["MediaGraphNodeInput"],
        **kwargs
    ):
        super(MediaGraphProcessor, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.name = name
        self.inputs = inputs


class MediaGraphExtensionProcessorBase(MediaGraphProcessor):
    """Processor that allows for extensions outside of the Live Video Analytics Edge module to be integrated into the graph. It is the base class for various different kinds of extension processor types.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MediaGraphCognitiveServicesVisionExtension, MediaGraphGrpcExtension, MediaGraphHttpExtension.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. The name for this processor node.
    :type name: str
    :param inputs: Required. An array of the names of the other nodes in the media graph, the
     outputs of which are used as input for this processor node.
    :type inputs: list[~azure.media.analyticsedge.models.MediaGraphNodeInput]
    :param endpoint: Required. Endpoint to which this processor should connect.
    :type endpoint: ~azure.media.analyticsedge.models.MediaGraphEndpoint
    :param image: Required. Describes the parameters of the image that is sent as input to the
     endpoint.
    :type image: ~azure.media.analyticsedge.models.MediaGraphImage
    :param sampling_options: Describes the sampling options to be applied when forwarding samples
     to the extension.
    :type sampling_options: ~azure.media.analyticsedge.models.MediaGraphSamplingOptions
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
        'endpoint': {'required': True},
        'image': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[MediaGraphNodeInput]'},
        'endpoint': {'key': 'endpoint', 'type': 'MediaGraphEndpoint'},
        'image': {'key': 'image', 'type': 'MediaGraphImage'},
        'sampling_options': {'key': 'samplingOptions', 'type': 'MediaGraphSamplingOptions'},
    }

    _subtype_map = {
        'type': {'#Microsoft.Media.MediaGraphCognitiveServicesVisionExtension': 'MediaGraphCognitiveServicesVisionExtension', '#Microsoft.Media.MediaGraphGrpcExtension': 'MediaGraphGrpcExtension', '#Microsoft.Media.MediaGraphHttpExtension': 'MediaGraphHttpExtension'}
    }

    def __init__(
        self,
        *,
        name: str,
        inputs: List["MediaGraphNodeInput"],
        endpoint: "MediaGraphEndpoint",
        image: "MediaGraphImage",
        sampling_options: Optional["MediaGraphSamplingOptions"] = None,
        **kwargs
    ):
        super(MediaGraphExtensionProcessorBase, self).__init__(name=name, inputs=inputs, **kwargs)
        self.type = '#Microsoft.Media.MediaGraphExtensionProcessorBase'  # type: str
        self.endpoint = endpoint
        self.image = image
        self.sampling_options = sampling_options


class MediaGraphCognitiveServicesVisionExtension(MediaGraphExtensionProcessorBase):
    """A processor that allows the media graph to send video frames to a Cognitive Services Vision extension. Inference results are relayed to downstream nodes.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. The name for this processor node.
    :type name: str
    :param inputs: Required. An array of the names of the other nodes in the media graph, the
     outputs of which are used as input for this processor node.
    :type inputs: list[~azure.media.analyticsedge.models.MediaGraphNodeInput]
    :param endpoint: Required. Endpoint to which this processor should connect.
    :type endpoint: ~azure.media.analyticsedge.models.MediaGraphEndpoint
    :param image: Required. Describes the parameters of the image that is sent as input to the
     endpoint.
    :type image: ~azure.media.analyticsedge.models.MediaGraphImage
    :param sampling_options: Describes the sampling options to be applied when forwarding samples
     to the extension.
    :type sampling_options: ~azure.media.analyticsedge.models.MediaGraphSamplingOptions
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
        'endpoint': {'required': True},
        'image': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[MediaGraphNodeInput]'},
        'endpoint': {'key': 'endpoint', 'type': 'MediaGraphEndpoint'},
        'image': {'key': 'image', 'type': 'MediaGraphImage'},
        'sampling_options': {'key': 'samplingOptions', 'type': 'MediaGraphSamplingOptions'},
    }

    def __init__(
        self,
        *,
        name: str,
        inputs: List["MediaGraphNodeInput"],
        endpoint: "MediaGraphEndpoint",
        image: "MediaGraphImage",
        sampling_options: Optional["MediaGraphSamplingOptions"] = None,
        **kwargs
    ):
        super(MediaGraphCognitiveServicesVisionExtension, self).__init__(name=name, inputs=inputs, endpoint=endpoint, image=image, sampling_options=sampling_options, **kwargs)
        self.type = '#Microsoft.Media.MediaGraphCognitiveServicesVisionExtension'  # type: str


class MediaGraphCredentials(msrest.serialization.Model):
    """Credentials to present during authentication.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MediaGraphHttpHeaderCredentials, MediaGraphUsernamePasswordCredentials.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.Media.MediaGraphHttpHeaderCredentials': 'MediaGraphHttpHeaderCredentials', '#Microsoft.Media.MediaGraphUsernamePasswordCredentials': 'MediaGraphUsernamePasswordCredentials'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaGraphCredentials, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class MediaGraphEndpoint(msrest.serialization.Model):
    """Base class for endpoints.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MediaGraphTlsEndpoint, MediaGraphUnsecuredEndpoint.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param credentials: Polymorphic credentials to be presented to the endpoint.
    :type credentials: ~azure.media.analyticsedge.models.MediaGraphCredentials
    :param url: Required. Url for the endpoint.
    :type url: str
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'MediaGraphCredentials'},
        'url': {'key': 'url', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.Media.MediaGraphTlsEndpoint': 'MediaGraphTlsEndpoint', '#Microsoft.Media.MediaGraphUnsecuredEndpoint': 'MediaGraphUnsecuredEndpoint'}
    }

    def __init__(
        self,
        *,
        url: str,
        credentials: Optional["MediaGraphCredentials"] = None,
        **kwargs
    ):
        super(MediaGraphEndpoint, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.credentials = credentials
        self.url = url


class MediaGraphFileSink(MediaGraphSink):
    """Enables a media graph to write/store media (video and audio) to a file on the Edge device.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. The name to be used for the media graph sink.
    :type name: str
    :param inputs: Required. An array of the names of the other nodes in the media graph, the
     outputs of which are used as input for this sink node.
    :type inputs: list[~azure.media.analyticsedge.models.MediaGraphNodeInput]
    :param base_directory_path: Required. Absolute directory for all outputs to the Edge device
     from this sink.
    :type base_directory_path: str
    :param file_name_pattern: Required. File name pattern for creating new files on the Edge
     device. The pattern must include at least one system variable. See the documentation for
     available variables and additional examples.
    :type file_name_pattern: str
    :param maximum_size_mi_b: Required. Maximum amount of disk space that can be used for storing
     files from this sink.
    :type maximum_size_mi_b: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
        'base_directory_path': {'required': True},
        'file_name_pattern': {'required': True},
        'maximum_size_mi_b': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[MediaGraphNodeInput]'},
        'base_directory_path': {'key': 'baseDirectoryPath', 'type': 'str'},
        'file_name_pattern': {'key': 'fileNamePattern', 'type': 'str'},
        'maximum_size_mi_b': {'key': 'maximumSizeMiB', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        inputs: List["MediaGraphNodeInput"],
        base_directory_path: str,
        file_name_pattern: str,
        maximum_size_mi_b: str,
        **kwargs
    ):
        super(MediaGraphFileSink, self).__init__(name=name, inputs=inputs, **kwargs)
        self.type = '#Microsoft.Media.MediaGraphFileSink'  # type: str
        self.base_directory_path = base_directory_path
        self.file_name_pattern = file_name_pattern
        self.maximum_size_mi_b = maximum_size_mi_b


class MediaGraphGrpcExtension(MediaGraphExtensionProcessorBase):
    """A processor that allows the media graph to send video frames to an external inference container over a gRPC connection. This can be done using shared memory (for high frame rates), or over the network. Inference results are relayed to downstream nodes.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. The name for this processor node.
    :type name: str
    :param inputs: Required. An array of the names of the other nodes in the media graph, the
     outputs of which are used as input for this processor node.
    :type inputs: list[~azure.media.analyticsedge.models.MediaGraphNodeInput]
    :param endpoint: Required. Endpoint to which this processor should connect.
    :type endpoint: ~azure.media.analyticsedge.models.MediaGraphEndpoint
    :param image: Required. Describes the parameters of the image that is sent as input to the
     endpoint.
    :type image: ~azure.media.analyticsedge.models.MediaGraphImage
    :param sampling_options: Describes the sampling options to be applied when forwarding samples
     to the extension.
    :type sampling_options: ~azure.media.analyticsedge.models.MediaGraphSamplingOptions
    :param data_transfer: Required. How media should be transferred to the inference engine.
    :type data_transfer: ~azure.media.analyticsedge.models.MediaGraphGrpcExtensionDataTransfer
    :param extension_configuration: Optional configuration to pass to the gRPC extension.
    :type extension_configuration: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
        'endpoint': {'required': True},
        'image': {'required': True},
        'data_transfer': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[MediaGraphNodeInput]'},
        'endpoint': {'key': 'endpoint', 'type': 'MediaGraphEndpoint'},
        'image': {'key': 'image', 'type': 'MediaGraphImage'},
        'sampling_options': {'key': 'samplingOptions', 'type': 'MediaGraphSamplingOptions'},
        'data_transfer': {'key': 'dataTransfer', 'type': 'MediaGraphGrpcExtensionDataTransfer'},
        'extension_configuration': {'key': 'extensionConfiguration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        inputs: List["MediaGraphNodeInput"],
        endpoint: "MediaGraphEndpoint",
        image: "MediaGraphImage",
        data_transfer: "MediaGraphGrpcExtensionDataTransfer",
        sampling_options: Optional["MediaGraphSamplingOptions"] = None,
        extension_configuration: Optional[str] = None,
        **kwargs
    ):
        super(MediaGraphGrpcExtension, self).__init__(name=name, inputs=inputs, endpoint=endpoint, image=image, sampling_options=sampling_options, **kwargs)
        self.type = '#Microsoft.Media.MediaGraphGrpcExtension'  # type: str
        self.data_transfer = data_transfer
        self.extension_configuration = extension_configuration


class MediaGraphGrpcExtensionDataTransfer(msrest.serialization.Model):
    """Describes how media should be transferred to the inference engine.

    All required parameters must be populated in order to send to Azure.

    :param shared_memory_size_mi_b: The size of the buffer for all in-flight frames in mebibytes if
     mode is SharedMemory. Should not be specified otherwise.
    :type shared_memory_size_mi_b: str
    :param mode: Required. How frame data should be transmitted to the inference engine. Possible
     values include: "Embedded", "SharedMemory".
    :type mode: str or ~azure.media.analyticsedge.models.MediaGraphGrpcExtensionDataTransferMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'shared_memory_size_mi_b': {'key': 'sharedMemorySizeMiB', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Union[str, "MediaGraphGrpcExtensionDataTransferMode"],
        shared_memory_size_mi_b: Optional[str] = None,
        **kwargs
    ):
        super(MediaGraphGrpcExtensionDataTransfer, self).__init__(**kwargs)
        self.shared_memory_size_mi_b = shared_memory_size_mi_b
        self.mode = mode


class MediaGraphHttpExtension(MediaGraphExtensionProcessorBase):
    """A processor that allows the media graph to send video frames (mostly at low frame rates e.g. <5 fps) to an external inference container over an HTTP-based RESTful API. Inference results are relayed to downstream nodes.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. The name for this processor node.
    :type name: str
    :param inputs: Required. An array of the names of the other nodes in the media graph, the
     outputs of which are used as input for this processor node.
    :type inputs: list[~azure.media.analyticsedge.models.MediaGraphNodeInput]
    :param endpoint: Required. Endpoint to which this processor should connect.
    :type endpoint: ~azure.media.analyticsedge.models.MediaGraphEndpoint
    :param image: Required. Describes the parameters of the image that is sent as input to the
     endpoint.
    :type image: ~azure.media.analyticsedge.models.MediaGraphImage
    :param sampling_options: Describes the sampling options to be applied when forwarding samples
     to the extension.
    :type sampling_options: ~azure.media.analyticsedge.models.MediaGraphSamplingOptions
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
        'endpoint': {'required': True},
        'image': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[MediaGraphNodeInput]'},
        'endpoint': {'key': 'endpoint', 'type': 'MediaGraphEndpoint'},
        'image': {'key': 'image', 'type': 'MediaGraphImage'},
        'sampling_options': {'key': 'samplingOptions', 'type': 'MediaGraphSamplingOptions'},
    }

    def __init__(
        self,
        *,
        name: str,
        inputs: List["MediaGraphNodeInput"],
        endpoint: "MediaGraphEndpoint",
        image: "MediaGraphImage",
        sampling_options: Optional["MediaGraphSamplingOptions"] = None,
        **kwargs
    ):
        super(MediaGraphHttpExtension, self).__init__(name=name, inputs=inputs, endpoint=endpoint, image=image, sampling_options=sampling_options, **kwargs)
        self.type = '#Microsoft.Media.MediaGraphHttpExtension'  # type: str


class MediaGraphHttpHeaderCredentials(MediaGraphCredentials):
    """Http header service credentials.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param header_name: Required. HTTP header name.
    :type header_name: str
    :param header_value: Required. HTTP header value. Please use a parameter so that the actual
     value is not returned on PUT or GET requests.
    :type header_value: str
    """

    _validation = {
        'type': {'required': True},
        'header_name': {'required': True},
        'header_value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'header_name': {'key': 'headerName', 'type': 'str'},
        'header_value': {'key': 'headerValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        header_name: str,
        header_value: str,
        **kwargs
    ):
        super(MediaGraphHttpHeaderCredentials, self).__init__(**kwargs)
        self.type = '#Microsoft.Media.MediaGraphHttpHeaderCredentials'  # type: str
        self.header_name = header_name
        self.header_value = header_value


class MediaGraphImage(msrest.serialization.Model):
    """Describes the properties of an image frame.

    :param scale: The scaling mode for the image.
    :type scale: ~azure.media.analyticsedge.models.MediaGraphImageScale
    :param format: Encoding settings for an image.
    :type format: ~azure.media.analyticsedge.models.MediaGraphImageFormat
    """

    _attribute_map = {
        'scale': {'key': 'scale', 'type': 'MediaGraphImageScale'},
        'format': {'key': 'format', 'type': 'MediaGraphImageFormat'},
    }

    def __init__(
        self,
        *,
        scale: Optional["MediaGraphImageScale"] = None,
        format: Optional["MediaGraphImageFormat"] = None,
        **kwargs
    ):
        super(MediaGraphImage, self).__init__(**kwargs)
        self.scale = scale
        self.format = format


class MediaGraphImageFormat(msrest.serialization.Model):
    """Encoding settings for an image.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MediaGraphImageFormatBmp, MediaGraphImageFormatJpeg, MediaGraphImageFormatPng, MediaGraphImageFormatRaw.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.Media.MediaGraphImageFormatBmp': 'MediaGraphImageFormatBmp', '#Microsoft.Media.MediaGraphImageFormatJpeg': 'MediaGraphImageFormatJpeg', '#Microsoft.Media.MediaGraphImageFormatPng': 'MediaGraphImageFormatPng', '#Microsoft.Media.MediaGraphImageFormatRaw': 'MediaGraphImageFormatRaw'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaGraphImageFormat, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class MediaGraphImageFormatBmp(MediaGraphImageFormat):
    """Encoding settings for Bmp images.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaGraphImageFormatBmp, self).__init__(**kwargs)
        self.type = '#Microsoft.Media.MediaGraphImageFormatBmp'  # type: str


class MediaGraphImageFormatJpeg(MediaGraphImageFormat):
    """Encoding settings for Jpeg images.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param quality: The image quality. Value must be between 0 to 100 (best quality).
    :type quality: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'quality': {'key': 'quality', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        quality: Optional[str] = None,
        **kwargs
    ):
        super(MediaGraphImageFormatJpeg, self).__init__(**kwargs)
        self.type = '#Microsoft.Media.MediaGraphImageFormatJpeg'  # type: str
        self.quality = quality


class MediaGraphImageFormatPng(MediaGraphImageFormat):
    """Encoding settings for Png images.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaGraphImageFormatPng, self).__init__(**kwargs)
        self.type = '#Microsoft.Media.MediaGraphImageFormatPng'  # type: str


class MediaGraphImageFormatRaw(MediaGraphImageFormat):
    """Encoding settings for raw images.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param pixel_format: Required. The pixel format that will be used to encode images. Possible
     values include: "Yuv420p", "Rgb565be", "Rgb565le", "Rgb555be", "Rgb555le", "Rgb24", "Bgr24",
     "Argb", "Rgba", "Abgr", "Bgra".
    :type pixel_format: str or
     ~azure.media.analyticsedge.models.MediaGraphImageFormatRawPixelFormat
    """

    _validation = {
        'type': {'required': True},
        'pixel_format': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'pixel_format': {'key': 'pixelFormat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        pixel_format: Union[str, "MediaGraphImageFormatRawPixelFormat"],
        **kwargs
    ):
        super(MediaGraphImageFormatRaw, self).__init__(**kwargs)
        self.type = '#Microsoft.Media.MediaGraphImageFormatRaw'  # type: str
        self.pixel_format = pixel_format


class MediaGraphImageScale(msrest.serialization.Model):
    """The scaling mode for the image.

    :param mode: Describes the modes for scaling an input video frame into an image, before it is
     sent to an inference engine. Possible values include: "PreserveAspectRatio", "Pad", "Stretch".
    :type mode: str or ~azure.media.analyticsedge.models.MediaGraphImageScaleMode
    :param width: The desired output width of the image.
    :type width: str
    :param height: The desired output height of the image.
    :type height: str
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'width': {'key': 'width', 'type': 'str'},
        'height': {'key': 'height', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "MediaGraphImageScaleMode"]] = None,
        width: Optional[str] = None,
        height: Optional[str] = None,
        **kwargs
    ):
        super(MediaGraphImageScale, self).__init__(**kwargs)
        self.mode = mode
        self.width = width
        self.height = height


class MediaGraphInstance(msrest.serialization.Model):
    """Represents an instance of a media graph.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The identifier for the media graph instance.
    :type name: str
    :param system_data: The system data for a resource. This is used by both topologies and
     instances.
    :type system_data: ~azure.media.analyticsedge.models.MediaGraphSystemData
    :param properties: Properties of a media graph instance.
    :type properties: ~azure.media.analyticsedge.models.MediaGraphInstanceProperties
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'MediaGraphSystemData'},
        'properties': {'key': 'properties', 'type': 'MediaGraphInstanceProperties'},
    }

    def __init__(
        self,
        *,
        name: str,
        system_data: Optional["MediaGraphSystemData"] = None,
        properties: Optional["MediaGraphInstanceProperties"] = None,
        **kwargs
    ):
        super(MediaGraphInstance, self).__init__(**kwargs)
        self.name = name
        self.system_data = system_data
        self.properties = properties


class MediaGraphInstanceActivateRequest(ItemNonSetRequestBase):
    """Represents the MediaGraphInstanceActivateRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar method_name: Required. method name.Constant filled by server.
    :vartype method_name: str
    :ivar api_version: api version. Default value: "2.0".
    :vartype api_version: str
    :param name: Required. method name.
    :type name: str
    """

    _validation = {
        'method_name': {'required': True, 'readonly': True},
        'api_version': {'constant': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'method_name': {'key': 'methodName', 'type': 'str'},
        'api_version': {'key': '@apiVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    api_version = "2.0"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(MediaGraphInstanceActivateRequest, self).__init__(name=name, **kwargs)
        self.method_name = 'GraphInstanceActivate'  # type: str


class MediaGraphInstanceCollection(msrest.serialization.Model):
    """A collection of media graph instances.

    :param value: A collection of media graph instances.
    :type value: list[~azure.media.analyticsedge.models.MediaGraphInstance]
    :param continuation_token: A continuation token to use in subsequent calls to enumerate through
     the graph instance collection. This is used when the collection contains too many results to
     return in one response.
    :type continuation_token: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MediaGraphInstance]'},
        'continuation_token': {'key': '@continuationToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["MediaGraphInstance"]] = None,
        continuation_token: Optional[str] = None,
        **kwargs
    ):
        super(MediaGraphInstanceCollection, self).__init__(**kwargs)
        self.value = value
        self.continuation_token = continuation_token


class MediaGraphInstanceDeActivateRequest(ItemNonSetRequestBase):
    """Represents the MediaGraphInstanceDeactivateRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar method_name: Required. method name.Constant filled by server.
    :vartype method_name: str
    :ivar api_version: api version. Default value: "2.0".
    :vartype api_version: str
    :param name: Required. method name.
    :type name: str
    """

    _validation = {
        'method_name': {'required': True, 'readonly': True},
        'api_version': {'constant': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'method_name': {'key': 'methodName', 'type': 'str'},
        'api_version': {'key': '@apiVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    api_version = "2.0"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(MediaGraphInstanceDeActivateRequest, self).__init__(name=name, **kwargs)
        self.method_name = 'GraphInstanceDeactivate'  # type: str


class MediaGraphInstanceDeleteRequest(ItemNonSetRequestBase):
    """Represents the MediaGraphInstanceDeleteRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar method_name: Required. method name.Constant filled by server.
    :vartype method_name: str
    :ivar api_version: api version. Default value: "2.0".
    :vartype api_version: str
    :param name: Required. method name.
    :type name: str
    """

    _validation = {
        'method_name': {'required': True, 'readonly': True},
        'api_version': {'constant': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'method_name': {'key': 'methodName', 'type': 'str'},
        'api_version': {'key': '@apiVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    api_version = "2.0"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(MediaGraphInstanceDeleteRequest, self).__init__(name=name, **kwargs)
        self.method_name = 'GraphInstanceDelete'  # type: str


class MediaGraphInstanceGetRequest(ItemNonSetRequestBase):
    """Represents the MediaGraphInstanceGetRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar method_name: Required. method name.Constant filled by server.
    :vartype method_name: str
    :ivar api_version: api version. Default value: "2.0".
    :vartype api_version: str
    :param name: Required. method name.
    :type name: str
    """

    _validation = {
        'method_name': {'required': True, 'readonly': True},
        'api_version': {'constant': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'method_name': {'key': 'methodName', 'type': 'str'},
        'api_version': {'key': '@apiVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    api_version = "2.0"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(MediaGraphInstanceGetRequest, self).__init__(name=name, **kwargs)
        self.method_name = 'GraphInstanceGet'  # type: str


class MediaGraphInstanceListRequest(MethodRequest):
    """Represents the MediaGraphInstanceListRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar method_name: Required. method name.Constant filled by server.
    :vartype method_name: str
    :ivar api_version: api version. Default value: "2.0".
    :vartype api_version: str
    """

    _validation = {
        'method_name': {'required': True, 'readonly': True},
        'api_version': {'constant': True},
    }

    _attribute_map = {
        'method_name': {'key': 'methodName', 'type': 'str'},
        'api_version': {'key': '@apiVersion', 'type': 'str'},
    }

    api_version = "2.0"

    def __init__(
        self,
        **kwargs
    ):
        super(MediaGraphInstanceListRequest, self).__init__(**kwargs)
        self.method_name = 'GraphInstanceList'  # type: str


class MediaGraphInstanceProperties(msrest.serialization.Model):
    """Properties of a media graph instance.

    :param description: An optional description for the instance.
    :type description: str
    :param topology_name: The name of the media graph topology that this instance will run. A
     topology with this name should already have been set in the Edge module.
    :type topology_name: str
    :param parameters: List of one or more graph instance parameters.
    :type parameters: list[~azure.media.analyticsedge.models.MediaGraphParameterDefinition]
    :param state: Allowed states for a graph instance. Possible values include: "Inactive",
     "Activating", "Active", "Deactivating".
    :type state: str or ~azure.media.analyticsedge.models.MediaGraphInstanceState
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'topology_name': {'key': 'topologyName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[MediaGraphParameterDefinition]'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        topology_name: Optional[str] = None,
        parameters: Optional[List["MediaGraphParameterDefinition"]] = None,
        state: Optional[Union[str, "MediaGraphInstanceState"]] = None,
        **kwargs
    ):
        super(MediaGraphInstanceProperties, self).__init__(**kwargs)
        self.description = description
        self.topology_name = topology_name
        self.parameters = parameters
        self.state = state


class MediaGraphInstanceSetRequest(MethodRequest):
    """Represents the MediaGraphInstanceSetRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar method_name: Required. method name.Constant filled by server.
    :vartype method_name: str
    :ivar api_version: api version. Default value: "2.0".
    :vartype api_version: str
    :param instance: Required. Represents an instance of a media graph.
    :type instance: ~azure.media.analyticsedge.models.MediaGraphInstance
    """

    _validation = {
        'method_name': {'required': True, 'readonly': True},
        'api_version': {'constant': True},
        'instance': {'required': True},
    }

    _attribute_map = {
        'method_name': {'key': 'methodName', 'type': 'str'},
        'api_version': {'key': '@apiVersion', 'type': 'str'},
        'instance': {'key': 'instance', 'type': 'MediaGraphInstance'},
    }

    api_version = "2.0"

    def __init__(
        self,
        *,
        instance: "MediaGraphInstance",
        **kwargs
    ):
        super(MediaGraphInstanceSetRequest, self).__init__(**kwargs)
        self.method_name = 'GraphInstanceSet'  # type: str
        self.instance = instance


class MediaGraphInstanceSetRequestBody(MediaGraphInstance, MethodRequest):
    """Represents the MediaGraphInstanceSetRequest body.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar method_name: Required. method name.Constant filled by server.
    :vartype method_name: str
    :ivar api_version: api version. Default value: "2.0".
    :vartype api_version: str
    :param name: Required. The identifier for the media graph instance.
    :type name: str
    :param system_data: The system data for a resource. This is used by both topologies and
     instances.
    :type system_data: ~azure.media.analyticsedge.models.MediaGraphSystemData
    :param properties: Properties of a media graph instance.
    :type properties: ~azure.media.analyticsedge.models.MediaGraphInstanceProperties
    """

    _validation = {
        'method_name': {'required': True, 'readonly': True},
        'api_version': {'constant': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'method_name': {'key': 'methodName', 'type': 'str'},
        'api_version': {'key': '@apiVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'MediaGraphSystemData'},
        'properties': {'key': 'properties', 'type': 'MediaGraphInstanceProperties'},
    }

    api_version = "2.0"

    def __init__(
        self,
        *,
        name: str,
        system_data: Optional["MediaGraphSystemData"] = None,
        properties: Optional["MediaGraphInstanceProperties"] = None,
        **kwargs
    ):
        super(MediaGraphInstanceSetRequestBody, self).__init__(name=name, system_data=system_data, properties=properties, **kwargs)
        self.method_name = 'MediaGraphInstanceSetRequestBody'  # type: str
        self.method_name = 'MediaGraphInstanceSetRequestBody'  # type: str
        self.name = name
        self.system_data = system_data
        self.properties = properties


class MediaGraphIoTHubMessageSink(MediaGraphSink):
    """Enables a media graph to publish messages that can be delivered via routes declared in the IoT Edge deployment manifest.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. The name to be used for the media graph sink.
    :type name: str
    :param inputs: Required. An array of the names of the other nodes in the media graph, the
     outputs of which are used as input for this sink node.
    :type inputs: list[~azure.media.analyticsedge.models.MediaGraphNodeInput]
    :param hub_output_name: Required. Name of the output path to which the media graph will publish
     message. These messages can then be delivered to desired destinations by declaring routes
     referencing the output path in the IoT Edge deployment manifest.
    :type hub_output_name: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
        'hub_output_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[MediaGraphNodeInput]'},
        'hub_output_name': {'key': 'hubOutputName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        inputs: List["MediaGraphNodeInput"],
        hub_output_name: str,
        **kwargs
    ):
        super(MediaGraphIoTHubMessageSink, self).__init__(name=name, inputs=inputs, **kwargs)
        self.type = '#Microsoft.Media.MediaGraphIoTHubMessageSink'  # type: str
        self.hub_output_name = hub_output_name


class MediaGraphSource(msrest.serialization.Model):
    """A source node in a media graph.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MediaGraphIoTHubMessageSource, MediaGraphRtspSource.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of the source node. The discriminator for derived
     types.Constant filled by server.
    :type type: str
    :param name: Required. The name to be used for this source node.
    :type name: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.Media.MediaGraphIoTHubMessageSource': 'MediaGraphIoTHubMessageSource', '#Microsoft.Media.MediaGraphRtspSource': 'MediaGraphRtspSource'}
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(MediaGraphSource, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.name = name


class MediaGraphIoTHubMessageSource(MediaGraphSource):
    """Enables a media graph to receive messages via routes declared in the IoT Edge deployment manifest.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of the source node. The discriminator for derived
     types.Constant filled by server.
    :type type: str
    :param name: Required. The name to be used for this source node.
    :type name: str
    :param hub_input_name: Name of the input path where messages can be routed to (via routes
     declared in the IoT Edge deployment manifest).
    :type hub_input_name: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'hub_input_name': {'key': 'hubInputName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        hub_input_name: Optional[str] = None,
        **kwargs
    ):
        super(MediaGraphIoTHubMessageSource, self).__init__(name=name, **kwargs)
        self.type = '#Microsoft.Media.MediaGraphIoTHubMessageSource'  # type: str
        self.hub_input_name = hub_input_name


class MediaGraphMotionDetectionProcessor(MediaGraphProcessor):
    """A node that accepts raw video as input, and detects if there are moving objects present. If so, then it emits an event, and allows frames where motion was detected to pass through. Other frames are blocked/dropped.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. The name for this processor node.
    :type name: str
    :param inputs: Required. An array of the names of the other nodes in the media graph, the
     outputs of which are used as input for this processor node.
    :type inputs: list[~azure.media.analyticsedge.models.MediaGraphNodeInput]
    :param sensitivity: Enumeration that specifies the sensitivity of the motion detection
     processor. Possible values include: "Low", "Medium", "High".
    :type sensitivity: str or
     ~azure.media.analyticsedge.models.MediaGraphMotionDetectionSensitivity
    :param output_motion_region: Indicates whether the processor should detect and output the
     regions, within the video frame, where motion was detected. Default is true.
    :type output_motion_region: bool
    :param event_aggregation_window: Event aggregation window duration, or 0 for no aggregation.
    :type event_aggregation_window: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[MediaGraphNodeInput]'},
        'sensitivity': {'key': 'sensitivity', 'type': 'str'},
        'output_motion_region': {'key': 'outputMotionRegion', 'type': 'bool'},
        'event_aggregation_window': {'key': 'eventAggregationWindow', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        inputs: List["MediaGraphNodeInput"],
        sensitivity: Optional[Union[str, "MediaGraphMotionDetectionSensitivity"]] = None,
        output_motion_region: Optional[bool] = None,
        event_aggregation_window: Optional[str] = None,
        **kwargs
    ):
        super(MediaGraphMotionDetectionProcessor, self).__init__(name=name, inputs=inputs, **kwargs)
        self.type = '#Microsoft.Media.MediaGraphMotionDetectionProcessor'  # type: str
        self.sensitivity = sensitivity
        self.output_motion_region = output_motion_region
        self.event_aggregation_window = event_aggregation_window


class MediaGraphNodeInput(msrest.serialization.Model):
    """Represents the input to any node in a media graph.

    All required parameters must be populated in order to send to Azure.

    :param node_name: Required. The name of another node in the media graph, the output of which is
     used as input to this node.
    :type node_name: str
    :param output_selectors: Allows for the selection of particular streams from another node.
    :type output_selectors: list[~azure.media.analyticsedge.models.MediaGraphOutputSelector]
    """

    _validation = {
        'node_name': {'required': True},
    }

    _attribute_map = {
        'node_name': {'key': 'nodeName', 'type': 'str'},
        'output_selectors': {'key': 'outputSelectors', 'type': '[MediaGraphOutputSelector]'},
    }

    def __init__(
        self,
        *,
        node_name: str,
        output_selectors: Optional[List["MediaGraphOutputSelector"]] = None,
        **kwargs
    ):
        super(MediaGraphNodeInput, self).__init__(**kwargs)
        self.node_name = node_name
        self.output_selectors = output_selectors


class MediaGraphOutputSelector(msrest.serialization.Model):
    """Allows for the selection of particular streams from another node.

    :param property: The stream property to compare with. Possible values include: "mediaType".
    :type property: str or ~azure.media.analyticsedge.models.MediaGraphOutputSelectorProperty
    :param operator: The operator to compare streams by. Possible values include: "is", "isNot".
    :type operator: str or ~azure.media.analyticsedge.models.MediaGraphOutputSelectorOperator
    :param value: Value to compare against.
    :type value: str
    """

    _attribute_map = {
        'property': {'key': 'property', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        property: Optional[Union[str, "MediaGraphOutputSelectorProperty"]] = None,
        operator: Optional[Union[str, "MediaGraphOutputSelectorOperator"]] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(MediaGraphOutputSelector, self).__init__(**kwargs)
        self.property = property
        self.operator = operator
        self.value = value


class MediaGraphParameterDeclaration(msrest.serialization.Model):
    """The declaration of a parameter in the media graph topology. A media graph topology can be authored with parameters. Then, during graph instance creation, the value for those parameters can be specified. This allows the same graph topology to be used as a blueprint for multiple graph instances with different values for the parameters.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the parameter.
    :type name: str
    :param type: Required. The type of the parameter. Possible values include: "String",
     "SecretString", "Int", "Double", "Bool".
    :type type: str or ~azure.media.analyticsedge.models.MediaGraphParameterType
    :param description: Description of the parameter.
    :type description: str
    :param default: The default value for the parameter to be used if the media graph instance does
     not specify a value.
    :type default: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 64, 'min_length': 0},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'default': {'key': 'default', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "MediaGraphParameterType"],
        description: Optional[str] = None,
        default: Optional[str] = None,
        **kwargs
    ):
        super(MediaGraphParameterDeclaration, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.description = description
        self.default = default


class MediaGraphParameterDefinition(msrest.serialization.Model):
    """A key-value pair. A media graph topology allows certain values to be parameterized. When an instance is created, the parameters are supplied with arguments specific to that instance. This allows the same graph topology to be used as a blueprint for multiple graph instances with different values for the parameters.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the parameter defined in the media graph topology.
    :type name: str
    :param value: Required. The value to supply for the named parameter defined in the media graph
     topology.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        **kwargs
    ):
        super(MediaGraphParameterDefinition, self).__init__(**kwargs)
        self.name = name
        self.value = value


class MediaGraphPemCertificateList(MediaGraphCertificateSource):
    """A list of PEM formatted certificates.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param certificates: Required. PEM formatted public certificates one per entry.
    :type certificates: list[str]
    """

    _validation = {
        'type': {'required': True},
        'certificates': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'certificates': {'key': 'certificates', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        certificates: List[str],
        **kwargs
    ):
        super(MediaGraphPemCertificateList, self).__init__(**kwargs)
        self.type = '#Microsoft.Media.MediaGraphPemCertificateList'  # type: str
        self.certificates = certificates


class MediaGraphRtspSource(MediaGraphSource):
    """Enables a media graph to capture media from a RTSP server.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of the source node. The discriminator for derived
     types.Constant filled by server.
    :type type: str
    :param name: Required. The name to be used for this source node.
    :type name: str
    :param transport: Underlying RTSP transport. This is used to enable or disable HTTP tunneling.
     Possible values include: "Http", "Tcp".
    :type transport: str or ~azure.media.analyticsedge.models.MediaGraphRtspTransport
    :param endpoint: Required. RTSP endpoint of the stream that is being connected to.
    :type endpoint: ~azure.media.analyticsedge.models.MediaGraphEndpoint
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'endpoint': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'transport': {'key': 'transport', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'MediaGraphEndpoint'},
    }

    def __init__(
        self,
        *,
        name: str,
        endpoint: "MediaGraphEndpoint",
        transport: Optional[Union[str, "MediaGraphRtspTransport"]] = None,
        **kwargs
    ):
        super(MediaGraphRtspSource, self).__init__(name=name, **kwargs)
        self.type = '#Microsoft.Media.MediaGraphRtspSource'  # type: str
        self.transport = transport
        self.endpoint = endpoint


class MediaGraphSamplingOptions(msrest.serialization.Model):
    """Describes the properties of a sample.

    :param skip_samples_without_annotation: If true, limits the samples submitted to the extension
     to only samples which have associated inference(s).
    :type skip_samples_without_annotation: str
    :param maximum_samples_per_second: Maximum rate of samples submitted to the extension.
    :type maximum_samples_per_second: str
    """

    _attribute_map = {
        'skip_samples_without_annotation': {'key': 'skipSamplesWithoutAnnotation', 'type': 'str'},
        'maximum_samples_per_second': {'key': 'maximumSamplesPerSecond', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        skip_samples_without_annotation: Optional[str] = None,
        maximum_samples_per_second: Optional[str] = None,
        **kwargs
    ):
        super(MediaGraphSamplingOptions, self).__init__(**kwargs)
        self.skip_samples_without_annotation = skip_samples_without_annotation
        self.maximum_samples_per_second = maximum_samples_per_second


class MediaGraphSignalGateProcessor(MediaGraphProcessor):
    """A signal gate determines when to block (gate) incoming media, and when to allow it through. It gathers input events over the activationEvaluationWindow, and determines whether to open or close the gate.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. The name for this processor node.
    :type name: str
    :param inputs: Required. An array of the names of the other nodes in the media graph, the
     outputs of which are used as input for this processor node.
    :type inputs: list[~azure.media.analyticsedge.models.MediaGraphNodeInput]
    :param activation_evaluation_window: The period of time over which the gate gathers input
     events before evaluating them.
    :type activation_evaluation_window: str
    :param activation_signal_offset: Signal offset once the gate is activated (can be negative). It
     is an offset between the time the event is received, and the timestamp of the first media
     sample (eg. video frame) that is allowed through by the gate.
    :type activation_signal_offset: str
    :param minimum_activation_time: The minimum period for which the gate remains open in the
     absence of subsequent triggers (events).
    :type minimum_activation_time: str
    :param maximum_activation_time: The maximum period for which the gate remains open in the
     presence of subsequent events.
    :type maximum_activation_time: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[MediaGraphNodeInput]'},
        'activation_evaluation_window': {'key': 'activationEvaluationWindow', 'type': 'str'},
        'activation_signal_offset': {'key': 'activationSignalOffset', 'type': 'str'},
        'minimum_activation_time': {'key': 'minimumActivationTime', 'type': 'str'},
        'maximum_activation_time': {'key': 'maximumActivationTime', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        inputs: List["MediaGraphNodeInput"],
        activation_evaluation_window: Optional[str] = None,
        activation_signal_offset: Optional[str] = None,
        minimum_activation_time: Optional[str] = None,
        maximum_activation_time: Optional[str] = None,
        **kwargs
    ):
        super(MediaGraphSignalGateProcessor, self).__init__(name=name, inputs=inputs, **kwargs)
        self.type = '#Microsoft.Media.MediaGraphSignalGateProcessor'  # type: str
        self.activation_evaluation_window = activation_evaluation_window
        self.activation_signal_offset = activation_signal_offset
        self.minimum_activation_time = minimum_activation_time
        self.maximum_activation_time = maximum_activation_time


class MediaGraphSystemData(msrest.serialization.Model):
    """The system data for a resource. This is used by both topologies and instances.

    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_at: Optional[datetime.datetime] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(MediaGraphSystemData, self).__init__(**kwargs)
        self.created_at = created_at
        self.last_modified_at = last_modified_at


class MediaGraphTlsEndpoint(MediaGraphEndpoint):
    """A TLS endpoint for media graph external connections.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param credentials: Polymorphic credentials to be presented to the endpoint.
    :type credentials: ~azure.media.analyticsedge.models.MediaGraphCredentials
    :param url: Required. Url for the endpoint.
    :type url: str
    :param trusted_certificates: Trusted certificates when authenticating a TLS connection. Null
     designates that Azure Media Service's source of trust should be used.
    :type trusted_certificates: ~azure.media.analyticsedge.models.MediaGraphCertificateSource
    :param validation_options: Validation options to use when authenticating a TLS connection. By
     default, strict validation is used.
    :type validation_options: ~azure.media.analyticsedge.models.MediaGraphTlsValidationOptions
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'MediaGraphCredentials'},
        'url': {'key': 'url', 'type': 'str'},
        'trusted_certificates': {'key': 'trustedCertificates', 'type': 'MediaGraphCertificateSource'},
        'validation_options': {'key': 'validationOptions', 'type': 'MediaGraphTlsValidationOptions'},
    }

    def __init__(
        self,
        *,
        url: str,
        credentials: Optional["MediaGraphCredentials"] = None,
        trusted_certificates: Optional["MediaGraphCertificateSource"] = None,
        validation_options: Optional["MediaGraphTlsValidationOptions"] = None,
        **kwargs
    ):
        super(MediaGraphTlsEndpoint, self).__init__(credentials=credentials, url=url, **kwargs)
        self.type = '#Microsoft.Media.MediaGraphTlsEndpoint'  # type: str
        self.trusted_certificates = trusted_certificates
        self.validation_options = validation_options


class MediaGraphTlsValidationOptions(msrest.serialization.Model):
    """Options for controlling the authentication of TLS endpoints.

    :param ignore_hostname: Boolean value ignoring the host name (common name) during validation.
    :type ignore_hostname: str
    :param ignore_signature: Boolean value ignoring the integrity of the certificate chain at the
     current time.
    :type ignore_signature: str
    """

    _attribute_map = {
        'ignore_hostname': {'key': 'ignoreHostname', 'type': 'str'},
        'ignore_signature': {'key': 'ignoreSignature', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ignore_hostname: Optional[str] = None,
        ignore_signature: Optional[str] = None,
        **kwargs
    ):
        super(MediaGraphTlsValidationOptions, self).__init__(**kwargs)
        self.ignore_hostname = ignore_hostname
        self.ignore_signature = ignore_signature


class MediaGraphTopology(msrest.serialization.Model):
    """The definition of a media graph topology.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The identifier for the media graph topology.
    :type name: str
    :param system_data: The system data for a resource. This is used by both topologies and
     instances.
    :type system_data: ~azure.media.analyticsedge.models.MediaGraphSystemData
    :param properties: A description of the properties of a media graph topology.
    :type properties: ~azure.media.analyticsedge.models.MediaGraphTopologyProperties
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'MediaGraphSystemData'},
        'properties': {'key': 'properties', 'type': 'MediaGraphTopologyProperties'},
    }

    def __init__(
        self,
        *,
        name: str,
        system_data: Optional["MediaGraphSystemData"] = None,
        properties: Optional["MediaGraphTopologyProperties"] = None,
        **kwargs
    ):
        super(MediaGraphTopology, self).__init__(**kwargs)
        self.name = name
        self.system_data = system_data
        self.properties = properties


class MediaGraphTopologyCollection(msrest.serialization.Model):
    """A collection of media graph topologies.

    :param value: A collection of media graph topologies.
    :type value: list[~azure.media.analyticsedge.models.MediaGraphTopology]
    :param continuation_token: A continuation token to use in subsequent calls to enumerate through
     the graph topologies collection. This is used when the collection contains too many results to
     return in one response.
    :type continuation_token: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MediaGraphTopology]'},
        'continuation_token': {'key': '@continuationToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["MediaGraphTopology"]] = None,
        continuation_token: Optional[str] = None,
        **kwargs
    ):
        super(MediaGraphTopologyCollection, self).__init__(**kwargs)
        self.value = value
        self.continuation_token = continuation_token


class MediaGraphTopologyDeleteRequest(ItemNonSetRequestBase):
    """Represents the MediaGraphTopologyDeleteRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar method_name: Required. method name.Constant filled by server.
    :vartype method_name: str
    :ivar api_version: api version. Default value: "2.0".
    :vartype api_version: str
    :param name: Required. method name.
    :type name: str
    """

    _validation = {
        'method_name': {'required': True, 'readonly': True},
        'api_version': {'constant': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'method_name': {'key': 'methodName', 'type': 'str'},
        'api_version': {'key': '@apiVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    api_version = "2.0"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(MediaGraphTopologyDeleteRequest, self).__init__(name=name, **kwargs)
        self.method_name = 'GraphTopologyDelete'  # type: str


class MediaGraphTopologyGetRequest(ItemNonSetRequestBase):
    """Represents the MediaGraphTopologyGetRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar method_name: Required. method name.Constant filled by server.
    :vartype method_name: str
    :ivar api_version: api version. Default value: "2.0".
    :vartype api_version: str
    :param name: Required. method name.
    :type name: str
    """

    _validation = {
        'method_name': {'required': True, 'readonly': True},
        'api_version': {'constant': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'method_name': {'key': 'methodName', 'type': 'str'},
        'api_version': {'key': '@apiVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    api_version = "2.0"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(MediaGraphTopologyGetRequest, self).__init__(name=name, **kwargs)
        self.method_name = 'GraphTopologyGet'  # type: str


class MediaGraphTopologyListRequest(MethodRequest):
    """Represents the MediaGraphTopologyListRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar method_name: Required. method name.Constant filled by server.
    :vartype method_name: str
    :ivar api_version: api version. Default value: "2.0".
    :vartype api_version: str
    """

    _validation = {
        'method_name': {'required': True, 'readonly': True},
        'api_version': {'constant': True},
    }

    _attribute_map = {
        'method_name': {'key': 'methodName', 'type': 'str'},
        'api_version': {'key': '@apiVersion', 'type': 'str'},
    }

    api_version = "2.0"

    def __init__(
        self,
        **kwargs
    ):
        super(MediaGraphTopologyListRequest, self).__init__(**kwargs)
        self.method_name = 'GraphTopologyList'  # type: str


class MediaGraphTopologyProperties(msrest.serialization.Model):
    """A description of the properties of a media graph topology.

    :param description: A description of a media graph topology. It is recommended to use this to
     describe the expected use of the topology.
    :type description: str
    :param parameters: The list of parameters defined in the topology. The value for these
     parameters are supplied by instances of this topology.
    :type parameters: list[~azure.media.analyticsedge.models.MediaGraphParameterDeclaration]
    :param sources: The list of source nodes in this topology.
    :type sources: list[~azure.media.analyticsedge.models.MediaGraphSource]
    :param processors: The list of processor nodes in this topology.
    :type processors: list[~azure.media.analyticsedge.models.MediaGraphProcessor]
    :param sinks: The list of sink nodes in this topology.
    :type sinks: list[~azure.media.analyticsedge.models.MediaGraphSink]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[MediaGraphParameterDeclaration]'},
        'sources': {'key': 'sources', 'type': '[MediaGraphSource]'},
        'processors': {'key': 'processors', 'type': '[MediaGraphProcessor]'},
        'sinks': {'key': 'sinks', 'type': '[MediaGraphSink]'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        parameters: Optional[List["MediaGraphParameterDeclaration"]] = None,
        sources: Optional[List["MediaGraphSource"]] = None,
        processors: Optional[List["MediaGraphProcessor"]] = None,
        sinks: Optional[List["MediaGraphSink"]] = None,
        **kwargs
    ):
        super(MediaGraphTopologyProperties, self).__init__(**kwargs)
        self.description = description
        self.parameters = parameters
        self.sources = sources
        self.processors = processors
        self.sinks = sinks


class MediaGraphTopologySetRequest(MethodRequest):
    """Represents the MediaGraphTopologySetRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar method_name: Required. method name.Constant filled by server.
    :vartype method_name: str
    :ivar api_version: api version. Default value: "2.0".
    :vartype api_version: str
    :param graph: Required. The definition of a media graph topology.
    :type graph: ~azure.media.analyticsedge.models.MediaGraphTopology
    """

    _validation = {
        'method_name': {'required': True, 'readonly': True},
        'api_version': {'constant': True},
        'graph': {'required': True},
    }

    _attribute_map = {
        'method_name': {'key': 'methodName', 'type': 'str'},
        'api_version': {'key': '@apiVersion', 'type': 'str'},
        'graph': {'key': 'graph', 'type': 'MediaGraphTopology'},
    }

    api_version = "2.0"

    def __init__(
        self,
        *,
        graph: "MediaGraphTopology",
        **kwargs
    ):
        super(MediaGraphTopologySetRequest, self).__init__(**kwargs)
        self.method_name = 'GraphTopologySet'  # type: str
        self.graph = graph


class MediaGraphTopologySetRequestBody(MediaGraphTopology, MethodRequest):
    """Represents the MediaGraphTopologySetRequest body.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar method_name: Required. method name.Constant filled by server.
    :vartype method_name: str
    :ivar api_version: api version. Default value: "2.0".
    :vartype api_version: str
    :param name: Required. The identifier for the media graph topology.
    :type name: str
    :param system_data: The system data for a resource. This is used by both topologies and
     instances.
    :type system_data: ~azure.media.analyticsedge.models.MediaGraphSystemData
    :param properties: A description of the properties of a media graph topology.
    :type properties: ~azure.media.analyticsedge.models.MediaGraphTopologyProperties
    """

    _validation = {
        'method_name': {'required': True, 'readonly': True},
        'api_version': {'constant': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'method_name': {'key': 'methodName', 'type': 'str'},
        'api_version': {'key': '@apiVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'MediaGraphSystemData'},
        'properties': {'key': 'properties', 'type': 'MediaGraphTopologyProperties'},
    }

    api_version = "2.0"

    def __init__(
        self,
        *,
        name: str,
        system_data: Optional["MediaGraphSystemData"] = None,
        properties: Optional["MediaGraphTopologyProperties"] = None,
        **kwargs
    ):
        super(MediaGraphTopologySetRequestBody, self).__init__(name=name, system_data=system_data, properties=properties, **kwargs)
        self.method_name = 'MediaGraphTopologySetRequestBody'  # type: str
        self.method_name = 'MediaGraphTopologySetRequestBody'  # type: str
        self.name = name
        self.system_data = system_data
        self.properties = properties


class MediaGraphUnsecuredEndpoint(MediaGraphEndpoint):
    """An endpoint that the media graph can connect to, with no encryption in transit.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param credentials: Polymorphic credentials to be presented to the endpoint.
    :type credentials: ~azure.media.analyticsedge.models.MediaGraphCredentials
    :param url: Required. Url for the endpoint.
    :type url: str
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'MediaGraphCredentials'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        url: str,
        credentials: Optional["MediaGraphCredentials"] = None,
        **kwargs
    ):
        super(MediaGraphUnsecuredEndpoint, self).__init__(credentials=credentials, url=url, **kwargs)
        self.type = '#Microsoft.Media.MediaGraphUnsecuredEndpoint'  # type: str


class MediaGraphUsernamePasswordCredentials(MediaGraphCredentials):
    """Username/password credential pair.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param username: Required. Username for a username/password pair.
    :type username: str
    :param password: Required. Password for a username/password pair. Please use a parameter so
     that the actual value is not returned on PUT or GET requests.
    :type password: str
    """

    _validation = {
        'type': {'required': True},
        'username': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        username: str,
        password: str,
        **kwargs
    ):
        super(MediaGraphUsernamePasswordCredentials, self).__init__(**kwargs)
        self.type = '#Microsoft.Media.MediaGraphUsernamePasswordCredentials'  # type: str
        self.username = username
        self.password = password
