# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ActionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
    """

    INTERNAL = "Internal"

class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class FhirServiceKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The kind of the service.
    """

    FHIR_STU3 = "fhir-Stu3"
    FHIR_R4 = "fhir-R4"

class IotIdentityResolutionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of IoT identity resolution to use with the destination.
    """

    CREATE = "Create"
    LOOKUP = "Lookup"

class Kind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The kind of the service.
    """

    FHIR = "fhir"
    FHIR_STU3 = "fhir-Stu3"
    FHIR_R4 = "fhir-R4"

class ManagedServiceIdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of identity being specified, currently SystemAssigned and None are allowed.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    NONE = "None"

class OperationResultStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the operation being performed.
    """

    CANCELED = "Canceled"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    REQUESTED = "Requested"
    RUNNING = "Running"

class PrivateEndpointConnectionProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The current provisioning state.
    """

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    FAILED = "Failed"

class PrivateEndpointServiceConnectionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The private endpoint connection status.
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state.
    """

    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    ACCEPTED = "Accepted"
    VERIFYING = "Verifying"
    UPDATING = "Updating"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DEPROVISIONED = "Deprovisioned"
    MOVING = "Moving"
    SUSPENDED = "Suspended"
    WARNED = "Warned"
    SYSTEM_MAINTENANCE = "SystemMaintenance"

class PublicNetworkAccess(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Control permission for data plane traffic coming from public networks while private endpoint is
    enabled.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class ServiceNameUnavailabilityReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The reason for unavailability.
    """

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"
