# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VaultUsage(Model):
    """Usages of a vault.

    :param unit: Unit of the usage. Possible values include: 'Count', 'Bytes',
     'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond'
    :type unit: str or ~azure.mgmt.recoveryservices.models.UsagesUnit
    :param quota_period: Quota period of usage.
    :type quota_period: str
    :param next_reset_time: Next reset time of usage.
    :type next_reset_time: datetime
    :param current_value: Current value of usage.
    :type current_value: long
    :param limit: Limit of usage.
    :type limit: long
    :param name: Name of usage.
    :type name: ~azure.mgmt.recoveryservices.models.NameInfo
    """

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'NameInfo'},
    }

    def __init__(self, **kwargs):
        super(VaultUsage, self).__init__(**kwargs)
        self.unit = kwargs.get('unit', None)
        self.quota_period = kwargs.get('quota_period', None)
        self.next_reset_time = kwargs.get('next_reset_time', None)
        self.current_value = kwargs.get('current_value', None)
        self.limit = kwargs.get('limit', None)
        self.name = kwargs.get('name', None)
