/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* This script compiles modules for evaluating polynomial functions. If any polynomial coefficients change, this script should be rerun to update the compiled files.
*/
'use strict';

// MODULES //

var resolve = require( 'path' ).resolve;
var writeFileSync = require( '@stdlib/fs/write-file' ).sync;
var licenseHeader = require( '@stdlib/_tools/licenses/header' );
var compile = require( './../../../../base/tools/evalrational-compile' );


// VARIABLES //

// Polynomial coefficients ordered in ascending degree...
var P1 = [
	0.24339294433593750202,
	-0.49092470516353571651,
	0.0557616214776046784287,
	-0.00320912498879085894856,
	0.000451534528645796438704,
	-0.933241270357061460782e-5
];
var Q1 = [
	1.0,
	-0.279960334310344432495,
	0.0419676223309986037706,
	-0.00413421406552171059003,
	0.00024978985622317935355,
	-0.101855788418564031874e-4
];
var P2 = [
	0.577215664901532860516,
	0.243210646940107164097,
	0.0417364673988216497593,
	0.00390252087072843288378,
	0.000249606367151877175456,
	0.110108440976732897969e-4
];
var Q2 = [
	1.0,
	0.295201277126631761737,
	0.043460910607305495864,
	0.00434930582085826330659,
	0.000255784226140488490982,
	0.10991819782396112081e-4
];
var P3 = [
	-0.0537258300023595030676,
	0.0445163473292365591906,
	0.0128677673534519952905,
	0.00097541770457391752726,
	0.769875101573654070925e-4,
	0.328032510000383084155e-5,
	0.0
];
var Q3 = [
	1.0,
	0.33383194553034051422,
	0.0487798431291407621462,
	0.00479039708573558490716,
	0.000270776703956336357707,
	0.106951867532057341359e-4,
	0.236276623974978646399e-7
];
var P4 = [
	-2.49710190602259410021,
	-2.60013301809475665334,
	-0.939260435377109939261,
	-0.138448617995741530935,
	-0.00701721240549802377623,
	-0.229257310594893932383e-4,
	0.0,
	0.0,
	0.0
];
var Q4 = [
	1.0,
	0.706039025937745133628,
	0.15739599649558626358,
	0.0106117950976845084417,
	-0.36910273311764618902e-4,
	0.493409563927590008943e-5,
	-0.234055487025287216506e-6,
	0.718833729365459760664e-8,
	-0.1129200113474947419e-9
];
var P5 = [
	-4.78558028495135619286,
	-1.89197364881972536382,
	-0.211407134874412820099,
	-0.000189204758260076688518,
	0.00115140923889178742086,
	0.639949204213164496988e-4,
	0.139348932445324888343e-5,
	0.0,
	0.0
];
var Q5 = [
	1.0,
	0.244345337378188557777,
	0.00873370754492288653669,
	-0.00117592765334434471562,
	-0.743743682899933180415e-4,
	-0.21750464515767984778e-5,
	0.471001264003076486547e-8,
	-0.833378440625385520576e-10,
	0.699841545204845636531e-12
];
var P6 = [
	-10.3948950573308896825,
	-2.85827219671106697179,
	-0.347728266539245787271,
	-0.0251156064655346341766,
	-0.00119459173416968685689,
	-0.382529323507967522614e-4,
	-0.785523633796723466968e-6,
	-0.821465709095465524192e-8
];
var Q6 = [
	1.0,
	0.208196333572671890965,
	0.0195687657317205033485,
	0.00111079638102485921877,
	0.408507746266039256231e-4,
	0.955561123065693483991e-6,
	0.118507153474022900583e-7,
	0.222609483627352615142e-14
];

// Header to add to output files:
var header = licenseHeader( 'Apache-2.0', 'js', {
	'year': ( new Date() ).getFullYear(),
	'copyright': 'The Stdlib Authors'
});
header += '\n/* This is a generated file. Do not edit directly. */\n';


// MAIN //

/**
* Main execution sequence.
*
* @private
*/
function main() {
	var fpath;
	var opts;
	var str;

	opts = {
		'encoding': 'utf8'
	};

	fpath = resolve( __dirname, '..', 'lib', 'rational_p1q1.js' );
	str = header + compile( P1, Q1 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p2q2.js' );
	str = header + compile( P2, Q2 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p3q3.js' );
	str = header + compile( P3, Q3 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p4q4.js' );
	str = header + compile( P4, Q4 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p5q5.js' );
	str = header + compile( P5, Q5 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p6q6.js' );
	str = header + compile( P6, Q6 );
	writeFileSync( fpath, str, opts );
}

main();
