<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/hpssa/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/hpssa/metadata.yaml"
sidebar_label: "HP Smart Storage Arrays"
learn_status: "Published"
learn_rel_path: "Data Collection/Storage, Mount Points and Filesystems"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# HP Smart Storage Arrays


<img src="https://netdata.cloud/img/hp.svg" width="150"/>


Plugin: python.d.plugin
Module: hpssa

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors HP Smart Storage Arrays metrics about operational statuses and temperatures.

It uses the command line tool `ssacli`. The exact command used is `sudo -n ssacli ctrl all show config detail`

This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

If no configuration is provided, the collector will try to execute the `ssacli` binary.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per HP Smart Storage Arrays instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| hpssa.ctrl_status | ctrl_{adapter slot}_status, cache_{adapter slot}_status, battery_{adapter slot}_status per adapter | Status |
| hpssa.ctrl_temperature | ctrl_{adapter slot}_temperature, cache_{adapter slot}_temperature per adapter | Celsius |
| hpssa.ld_status | a dimension per logical drive | Status |
| hpssa.pd_status | a dimension per physical drive | Status |
| hpssa.pd_temperature | a dimension per physical drive | Celsius |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Enable the hpssa collector

The `hpssa` collector is disabled by default. To enable it, use `edit-config` from the Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md), which is typically at `/etc/netdata`, to edit the `python.d.conf` file.

```bash
cd /etc/netdata   # Replace this path with your Netdata config directory, if different
sudo ./edit-config python.d.conf
```

Change the value of the `hpssa` setting to `yes`. Save the file and restart the Netdata Agent with `sudo systemctl restart netdata`, or the [appropriate method](https://github.com/netdata/netdata/blob/master/docs/configure/start-stop-restart.md) for your system.


#### Allow user netdata to execute `ssacli` as root.

This module uses `ssacli`, which can only be executed by root. It uses `sudo` and assumes that it is configured such that the `netdata` user can execute `ssacli` as root without a password.

- Add to your `/etc/sudoers` file:

`which ssacli` shows the full path to the binary.

```bash
netdata ALL=(root)       NOPASSWD: /path/to/ssacli
```

- Reset Netdata's systemd
  unit [CapabilityBoundingSet](https://www.freedesktop.org/software/systemd/man/systemd.exec.html#Capabilities) (Linux
  distributions with systemd)

The default CapabilityBoundingSet doesn't allow using `sudo`, and is quite strict in general. Resetting is not optimal, but a next-best solution given the inability to execute `ssacli` using `sudo`.

As the `root` user, do the following:

```cmd
mkdir /etc/systemd/system/netdata.service.d
echo -e '[Service]\nCapabilityBoundingSet=~' | tee /etc/systemd/system/netdata.service.d/unset-capability-bounding-set.conf
systemctl daemon-reload
systemctl restart netdata.service
```



### Configuration

#### File

The configuration file name for this integration is `python.d/hpssa.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/hpssa.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | False |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | False |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | False |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | False |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | False |
| ssacli_path | Path to the `ssacli` command line utility. Configure this if `ssacli` is not in the $PATH |  | False |
| use_sudo | Whether or not to use `sudo` to execute `ssacli` | True | False |

</details>

#### Examples

##### Local simple config

A basic configuration, specyfing the path to `ssacli`

```yaml
local:
 ssacli_path: /usr/sbin/ssacli

```


## Troubleshooting

### Debug Mode

To troubleshoot issues with the `hpssa` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin hpssa debug trace
  ```


