/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.agent;

import alt.jiapi.agent.Transformer;
import alt.jiapi.reflect.JiapiClass;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationAgent
implements ClassFileTransformer {
    private String agentArgs;
    private Instrumentation instrumentation;
    private Transformer transformer;

    public static void premain(String agentArgs, Instrumentation i) {
        Properties p = new Properties();
        if (agentArgs != null) {
            StringTokenizer st = new StringTokenizer(agentArgs, ",");
            while (st.hasMoreTokens()) {
                String nv = st.nextToken();
                StringTokenizer st2 = new StringTokenizer(nv, "=");
                String n = st2.nextToken();
                String v = null;
                v = st2.hasMoreTokens() ? st2.nextToken() : "";
                p.setProperty(n, v);
            }
        }
        try {
            String tr = p.getProperty("transformer", "alt.jiapi.agent.HotSpotTransformer");
            if (tr != null) {
                Class<?> c = Class.forName(tr);
                Object o = c.newInstance();
                Transformer tf = (Transformer)o;
                tf.init(p);
                InstrumentationAgent jcft = new InstrumentationAgent(agentArgs, i, tf);
                i.addTransformer(jcft);
            } else {
                System.out.println("Failed to create Transformer: Missing agent parameter 'transformer'");
                InstrumentationAgent jcft = new InstrumentationAgent(agentArgs, i, null);
                i.addTransformer(jcft);
            }
        }
        catch (Exception e) {
            System.out.println("Failed to create Transformer: " + e);
            e.printStackTrace();
        }
    }

    public InstrumentationAgent(String agentArgs, Instrumentation i, Transformer transformer) {
        this.agentArgs = agentArgs;
        this.instrumentation = i;
        this.transformer = transformer;
    }

    @Override
    public byte[] transform(ClassLoader cl, String className, Class<?> classBeingRedefined, ProtectionDomain pd, byte[] classFileBuffer) {
        if (this.transformer == null) {
            return null;
        }
        byte[] tempBuffer = new byte[classFileBuffer.length];
        System.arraycopy(classFileBuffer, 0, tempBuffer, 0, classFileBuffer.length);
        try {
            JiapiClass jc = JiapiClass.parseClass(tempBuffer);
            if (this.transformer.transform(jc)) {
                return jc.getByteCode();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

