

This is the internal documentation for invoke-rc.d, as
written by Henrique M Holschuh <hmh@debian.org>

This document can be found on the web as well at
http://people.debian.org/~hmh/invokerc.d-policyrc.d-specification.txt

There is also the Debian BTS entry for the invoke-rc.d policy change at
http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=76868


INVOKE-RC.D (/usr/sbin/invoke-rc.d) interface:
==============================================

The interface for all implementations of invoke-rc.d is mandated by the base
implementation in the sysvinit package, just like it is done for
update-rc.d.

There is a provision for a "local initscript policy layer" (read: a call to
/usr/sbin/policy-rc.d if this executable is present in the local system),
which allows the local system administrator to control the behaviour of
invoke-rc.d for every initscript id and action. It is assumed that this
script is OPTIONAL and will by written and provided by packages other than
the initscript system (sysvinit and file-rc packages).

The basic interface for all implementations of policy-rc.d is mandated by
the requirements of the base implementation of invoke-rc.d. This interface
will be described either in the manpage of invoke-rc.d, and in a text file
stored in /usr/share/doc/sysvinit/ by package sysvinit (which will host the
base implementation of invoke-rc.d).

Proposed script interfaces:

invoke-rc.d [options] <basename> <action> [extra initscript parameters...]

  basename - Initscript ID, as per update-rc.d(8)
  action   - Initscript action. Known actions are:
                start, [force-]stop, [try-]restart,
                [force-]reload, status
  (status is there because of the LSB. Debian does not use it).

  extra initscript parameters: These parameters are passed to the initscript
  as is, after the action parameter. <action> is always the first paramenter
  to the initscript, and may be modified by fallback actions or policy-rc.d
  requests. Note, however, that the extra parameters are not dropped or
  modified even if the action (first parameter) is modified.

Options:

 --quiet
     Quiet mode, no error messages are generated by invoke-rc.d; policy-rc.d
     is also called with --quiet if this option is in effect.

 --force
     Try to run init script regardless of policy and non-fatal errors. Use
     of this option in automated scripts is severely discouraged as it
     bypasses integrity checks. If the initscript cannot be executed, error
     status 102 is returned. Do note that the policy layer call
     (policy-rc.d) is NOT skipped, although its results are ignored.

 --try-anyway
     Try to run the initscript even if a non-fatal subsystem error is
     detected (e.g: bad rc.d symlinks). A 102 status exit code will result
     if init script fails to execute anyway). Unlike --force, policy is
     still enforced with --try-anyway.

 --disclose-deny
     Return status code 101 instead of status code 0 if initscript action is
     denied by local policy rules or runlevel constrains. An warning is
     generated if the action is denied.

 --query
     Returns one of status codes 100-106, does not execute the init.d
     script. Implies --disclose-deny and --nofallback.  Status codes 104-106
     are only generated by this option.

     Note many messages are still sent to stderr in --query mode, including
     those regarding policy overrides and subsystem errors. Use --quiet if
     silent --query operation is desired.

 --no-fallback 
     The policy layer (policy-rc.d) may return fallback actions to be run
     instead of the requested action. If this option is active, a fallback
     action request will be ignored and a "action not allowed" reply used in
     its place. This is probably a BAD idea unless you know exactly what
     you're doing.

  --help
     Outputs help message to stdout

Unknown actions may generate warnings, but are passed to the underlying
initscript anyway. The reason for the warning is simple: It is very unlikely
that an unknown action (by invoke-rc.d) will be known to the policy layer
(policy-rc.d), and therefore it may cause an initscript to execute an action
which the local system administrator would have not allowed had he known
about it. If policy-rc.d is not present, no warnings for unknown actions
are generated.

Should an initscript be executed, invoke-rc.d ALWAYS returns the status code
returned by the initscript. Initscripts should not return status codes in
the 100+ range (this is also a LSB requirement).

Exit status codes (LSB compatible):
  0      : success 
	   either the init script was run and returned exit status 0 (note
	   that a fallback action may have been run instead of the one given
	   in the command line), or it was not run because of runlevel/local
	   policy constrains and --disclose-deny is not in effect.
  1 - 99 : reserved for init.d script
 100     : init script ID (basename) unknown
	   init script not registered sucessfully through 
	   update-rc.d or init script does not exist.
	   This error is fatal for most initscript systems.
 101     : action not allowed
	   requested action will not be performed because of 
	   runlevel or local policy constrains, and 
	   --disclose-deny is in effect. Note that a fallback
	   action is NOT considered "action not allowed",
	   unless --nofalback is in effect.
 102	 : subsystem error
	   initscript (or policy) subsystem malfuncion.
	   (e.g. broken /sbin/runlevel).
	   Also, forced initscript execution due to 
	   --try-anyway or --force failed.
 103	 : syntax error
 104	 : action allowed
	   --query is in effect; init script would be run if
	   not for --query.
 105	 : behaviour uncertain
	   cannot determine if action should be carried out or 
	   not, and --query in effect.
 106     : fallback action requested
	   the policy layer denied the requested action, and
	   supplied an allowed fallback action.
