#############################################################
#
# statserial
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
STATSERIAL_SOURCE:=statserial.tar.gz
STATSERIAL_SITE:=ftp://ftp.gnu.org/gnu/statserial
STATSERIAL_CAT:=zcat
endif

STATSERIAL_DIR:=$(BUILD_DIR)/statserial
STATSERIAL_BINARY:=statserial
STATSERIAL_TARGET_BINARY:=usr/bin/statserial

ifneq ($(USE_CVS),true)
statserial-fetch:
	 $(WGET) -P $(DL_DIR) $(STATSERIAL_SITE)/$(STATSERIAL_SOURCE)

statserial-source: $(DL_DIR)/$(STATSERIAL_SOURCE)
else
statserial-source:
endif

STATSERIAL_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d statserial $(CVS_TAG) $(CVS_PREFIX)statserial

statserial-checkout:
	@$(STATSERIAL_CVSCO)

$(STATSERIAL_DIR)/.unpacked: $(DL_DIR)/$(STATSERIAL_SOURCE)
ifneq ($(USE_CVS),true)
	$(STATSERIAL_CAT) $(DL_DIR)/$(STATSERIAL_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(STATSERIAL_CVSCO)
endif
	sed -i -e 's,[[:space:]]/usr, $(TARGET_DIR)/usr,g' $(STATSERIAL_DIR)/Makefile
	touch $(STATSERIAL_DIR)/.unpacked

$(STATSERIAL_DIR)/$(STATSERIAL_BINARY): $(STATSERIAL_DIR)/.unpacked
	$(MAKE) CC=$(TARGET_CC) LD=$(TARGET_CC) -C $(STATSERIAL_DIR)

$(TARGET_DIR)/$(STATSERIAL_TARGET_BINARY): $(STATSERIAL_DIR)/$(STATSERIAL_BINARY)
	$(MAKE) -C $(STATSERIAL_DIR) install
	$(STRIP) $(TARGET_DIR)/$(STATSERIAL_TARGET_BINARY)
	install -d $(DOC_DIR)/doc/statserial
	@for f in COPYING ; do \
		install -m0644 $(STATSERIAL_DIR)/$$f $(DOC_DIR)/doc/statserial/$$f ;\
	done

statserial: uclibc popt $(TARGET_DIR)/$(STATSERIAL_TARGET_BINARY)

statserial-clean:
	-rm -f $(TARGET_DIR)/$(STATSERIAL_TARGET_BINARY)
	-rm -f $(TARGET_DIR)/usr/man/man1/statserial.1
	-rm -rf $(DOC_DIR)/doc/statserial
	-$(MAKE) -C $(STATSERIAL_DIR) clean

statserial-dirclean:
	rm -rf $(STATSERIAL_DIR)
endif

