/* Assembler macros for FR-V.
   Copyright (C) 1999, 2000, 2001, 2004 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#include <sysdeps/generic/sysdep.h>

#ifndef HAVE_ELF
# error ELF is assumed.  Generalize the code and retry.
#endif

#ifndef NO_UNDERSCORES
# error User-label prefix (underscore) assumed absent.  Generalize the code and retry.
#endif

#ifdef	__ASSEMBLER__

/* Syntactic details of assembly-code.  */

/* It is *not* generally true that "ELF uses byte-counts for .align, most
   others use log2 of count of bytes", like some neighboring configs say.
   See "align" in gas/read.c which is not overridden by
   gas/config/obj-elf.c.  It takes a log2 argument.  *Some* targets
   override it to take a byte argument.  People should read source instead
   of relying on hearsay.  */
# define ALIGNARG(log2) log2

# define ASM_TYPE_DIRECTIVE(name,typearg) .type name,typearg
# define ASM_SIZE_DIRECTIVE(name) .size name,.-name

/* Define an entry point visible from C.  */
# define ENTRY(name) \
  .text							! \
  ASM_GLOBAL_DIRECTIVE C_SYMBOL_NAME (name) 		! \
  ASM_TYPE_DIRECTIVE (C_SYMBOL_NAME (name), function)	! \
  .align ALIGNARG (2) 					! \
  C_LABEL(name)						! \
  CALL_MCOUNT

# undef	END
# define END(name) \
  ASM_SIZE_DIRECTIVE (C_SYMBOL_NAME (name))

/* If compiled for profiling, call `mcount' at the start of each function.
   FIXME: Note that profiling is not actually implemented.  */
# ifdef	PROF
#  define CALL_MCOUNT		/* Do nothing.  */
# else
#  define CALL_MCOUNT		/* Do nothing.  */
# endif

/* Since C identifiers are not normally prefixed with an underscore
   on this system, the asm identifier `syscall_error' intrudes on the
   C name space.  Make sure we use an innocuous name.  */
# define syscall_error	__syscall_error
# define mcount		_mcount

#endif	/* __ASSEMBLER__ */
