# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.9.3, generator: @autorest/python@6.2.3)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class Answers(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Answers."""

    #: Do not return answers for the query.
    NONE = "none"
    #: Extracts answer candidates from the contents of the documents returned in response to a query
    #: expressed as a question in natural language.
    EXTRACTIVE = "extractive"


class AutocompleteMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode for Autocomplete. The default is 'oneTerm'. Use 'twoTerms' to get shingles
    and 'oneTermWithContext' to use the current context in producing autocomplete terms.
    """

    #: Only one term is suggested. If the query has two terms, only the last term is completed. For
    #: example, if the input is 'washington medic', the suggested terms could include 'medicaid',
    #: 'medicare', and 'medicine'.
    ONE_TERM = "oneTerm"
    #: Matching two-term phrases in the index will be suggested. For example, if the input is 'medic',
    #: the suggested terms could include 'medicare coverage' and 'medical assistant'.
    TWO_TERMS = "twoTerms"
    #: Completes the last term in a query with two or more terms, where the last two terms are a
    #: phrase that exists in the index. For example, if the input is 'washington medic', the suggested
    #: terms could include 'washington medicaid' and 'washington medical'.
    ONE_TERM_WITH_CONTEXT = "oneTermWithContext"


class Captions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Captions."""

    #: Do not return captions for the query.
    NONE = "none"
    #: Extracts captions from the matching documents that contain passages relevant to the search
    #: query.
    EXTRACTIVE = "extractive"


class IndexActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operation to perform on a document in an indexing batch."""

    #: Inserts the document into the index if it is new and updates it if it exists. All fields are
    #: replaced in the update case.
    UPLOAD = "upload"
    #: Merges the specified field values with an existing document. If the document does not exist,
    #: the merge will fail. Any field you specify in a merge will replace the existing field in the
    #: document. This also applies to collections of primitive and complex types.
    MERGE = "merge"
    #: Behaves like merge if a document with the given key already exists in the index. If the
    #: document does not exist, it behaves like upload with a new document.
    MERGE_OR_UPLOAD = "mergeOrUpload"
    #: Removes the specified document from the index. Any field you specify in a delete operation
    #: other than the key field will be ignored. If you want to remove an individual field from a
    #: document, use merge instead and set the field explicitly to null.
    DELETE = "delete"


class QueryAnswerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This parameter is only valid if the query type is 'semantic'. If set, the query returns answers
    extracted from key passages in the highest ranked documents. The number of answers returned can
    be configured by appending the pipe character '|' followed by the 'count-:code:`<number of
    answers>`' option after the answers parameter value, such as 'extractive|count-3'. Default
    count is 1.
    """

    #: Do not return answers for the query.
    NONE = "none"
    #: Extracts answer candidates from the contents of the documents returned in response to a query
    #: expressed as a question in natural language.
    EXTRACTIVE = "extractive"


class QueryCaptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This parameter is only valid if the query type is 'semantic'. If set, the query returns
    captions extracted from key passages in the highest ranked documents. When Captions is set to
    'extractive', highlighting is enabled by default, and can be configured by appending the pipe
    character '|' followed by the 'highlight-<true/false>' option, such as
    'extractive|highlight-true'. Defaults to 'None'.
    """

    #: Do not return captions for the query.
    NONE = "none"
    #: Extracts captions from the matching documents that contain passages relevant to the search
    #: query.
    EXTRACTIVE = "extractive"


class QueryLanguage(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The language of the query."""

    #: Query language not specified.
    NONE = "none"
    #: Query language value for English (United States).
    EN_US = "en-us"
    #: Query language value for English (Great Britain).
    EN_GB = "en-gb"
    #: Query language value for English (India).
    EN_IN = "en-in"
    #: Query language value for English (Canada).
    EN_CA = "en-ca"
    #: Query language value for English (Australia).
    EN_AU = "en-au"
    #: Query language value for French (France).
    FR_FR = "fr-fr"
    #: Query language value for French (Canada).
    FR_CA = "fr-ca"
    #: Query language value for German (Germany).
    DE_DE = "de-de"
    #: Query language value for Spanish (Spain).
    ES_ES = "es-es"
    #: Query language value for Spanish (Mexico).
    ES_MX = "es-mx"
    #: Query language value for Chinese (China).
    ZH_CN = "zh-cn"
    #: Query language value for Chinese (Taiwan).
    ZH_TW = "zh-tw"
    #: Query language value for Portuguese (Brazil).
    PT_BR = "pt-br"
    #: Query language value for Portuguese (Portugal).
    PT_PT = "pt-pt"
    #: Query language value for Italian (Italy).
    IT_IT = "it-it"
    #: Query language value for Japanese (Japan).
    JA_JP = "ja-jp"
    #: Query language value for Korean (Korea).
    KO_KR = "ko-kr"
    #: Query language value for Russian (Russia).
    RU_RU = "ru-ru"
    #: Query language value for Czech (Czech Republic).
    CS_CZ = "cs-cz"
    #: Query language value for Dutch (Belgium).
    NL_BE = "nl-be"
    #: Query language value for Dutch (Netherlands).
    NL_NL = "nl-nl"
    #: Query language value for Hungarian (Hungary).
    HU_HU = "hu-hu"
    #: Query language value for Polish (Poland).
    PL_PL = "pl-pl"
    #: Query language value for Swedish (Sweden).
    SV_SE = "sv-se"
    #: Query language value for Turkish (Turkey).
    TR_TR = "tr-tr"
    #: Query language value for Hindi (India).
    HI_IN = "hi-in"
    #: Query language value for Arabic (Saudi Arabia).
    AR_SA = "ar-sa"
    #: Query language value for Arabic (Egypt).
    AR_EG = "ar-eg"
    #: Query language value for Arabic (Morocco).
    AR_MA = "ar-ma"
    #: Query language value for Arabic (Kuwait).
    AR_KW = "ar-kw"
    #: Query language value for Arabic (Jordan).
    AR_JO = "ar-jo"
    #: Query language value for Danish (Denmark).
    DA_DK = "da-dk"
    #: Query language value for Norwegian (Norway).
    NO_NO = "no-no"
    #: Query language value for Bulgarian (Bulgaria).
    BG_BG = "bg-bg"
    #: Query language value for Croatian (Croatia).
    HR_HR = "hr-hr"
    #: Query language value for Croatian (Bosnia and Herzegovina).
    HR_BA = "hr-ba"
    #: Query language value for Malay (Malaysia).
    MS_MY = "ms-my"
    #: Query language value for Malay (Brunei Darussalam).
    MS_BN = "ms-bn"
    #: Query language value for Slovenian (Slovenia).
    SL_SL = "sl-sl"
    #: Query language value for Tamil (India).
    TA_IN = "ta-in"
    #: Query language value for Vietnamese (Viet Nam).
    VI_VN = "vi-vn"
    #: Query language value for Greek (Greece).
    EL_GR = "el-gr"
    #: Query language value for Romanian (Romania).
    RO_RO = "ro-ro"
    #: Query language value for Icelandic (Iceland).
    IS_IS = "is-is"
    #: Query language value for Indonesian (Indonesia).
    ID_ID = "id-id"
    #: Query language value for Thai (Thailand).
    TH_TH = "th-th"
    #: Query language value for Lithuanian (Lithuania).
    LT_LT = "lt-lt"
    #: Query language value for Ukrainian (Ukraine).
    UK_UA = "uk-ua"
    #: Query language value for Latvian (Latvia).
    LV_LV = "lv-lv"
    #: Query language value for Estonian (Estonia).
    ET_EE = "et-ee"
    #: Query language value for Catalan (Spain).
    CA_ES = "ca-es"
    #: Query language value for Finnish (Finland).
    FI_FI = "fi-fi"
    #: Query language value for Serbian (Bosnia and Herzegovina).
    SR_BA = "sr-ba"
    #: Query language value for Serbian (Montenegro).
    SR_ME = "sr-me"
    #: Query language value for Serbian (Serbia).
    SR_RS = "sr-rs"
    #: Query language value for Slovak (Slovakia).
    SK_SK = "sk-sk"
    #: Query language value for Norwegian (Norway).
    NB_NO = "nb-no"
    #: Query language value for Armenian (Armenia).
    HY_AM = "hy-am"
    #: Query language value for Bengali (India).
    BN_IN = "bn-in"
    #: Query language value for Basque (Spain).
    EU_ES = "eu-es"
    #: Query language value for Galician (Spain).
    GL_ES = "gl-es"
    #: Query language value for Gujarati (India).
    GU_IN = "gu-in"
    #: Query language value for Hebrew (Israel).
    HE_IL = "he-il"
    #: Query language value for Irish (Ireland).
    GA_IE = "ga-ie"
    #: Query language value for Kannada (India).
    KN_IN = "kn-in"
    #: Query language value for Malayalam (India).
    ML_IN = "ml-in"
    #: Query language value for Marathi (India).
    MR_IN = "mr-in"
    #: Query language value for Persian (U.A.E.).
    FA_AE = "fa-ae"
    #: Query language value for Punjabi (India).
    PA_IN = "pa-in"
    #: Query language value for Telugu (India).
    TE_IN = "te-in"
    #: Query language value for Urdu (Pakistan).
    UR_PK = "ur-pk"


class QuerySpellerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Improve search recall by spell-correcting individual search query terms."""

    #: Speller not enabled.
    NONE = "none"
    #: Speller corrects individual query terms using a static lexicon for the language specified by
    #: the queryLanguage parameter.
    LEXICON = "lexicon"


class QueryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the syntax of the search query. The default is 'simple'. Use 'full' if your query
    uses the Lucene query syntax and 'semantic' if query syntax is not needed.
    """

    #: Uses the simple query syntax for searches. Search text is interpreted using a simple query
    #: language that allows for symbols such as +, * and "". Queries are evaluated across all
    #: searchable fields by default, unless the searchFields parameter is specified.
    SIMPLE = "simple"
    #: Uses the full Lucene query syntax for searches. Search text is interpreted using the Lucene
    #: query language which allows field-specific and weighted searches, as well as other advanced
    #: features.
    FULL = "full"
    #: Best suited for queries expressed in natural language as opposed to keywords. Improves
    #: precision of search results by re-ranking the top search results using a ranking model trained
    #: on the Web corpus.
    SEMANTIC = "semantic"


class ScoringStatistics(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A value that specifies whether we want to calculate scoring statistics (such as document
    frequency) globally for more consistent scoring, or locally, for lower latency. The default is
    'local'. Use 'global' to aggregate scoring statistics globally before scoring. Using global
    scoring statistics can increase latency of search queries.
    """

    #: The scoring statistics will be calculated locally for lower latency.
    LOCAL = "local"
    #: The scoring statistics will be calculated globally for more consistent scoring.
    GLOBAL = "global"


class SearchMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies whether any or all of the search terms must be matched in order to count the document
    as a match.
    """

    #: Any of the search terms must be matched in order to count the document as a match.
    ANY = "any"
    #: All of the search terms must be matched in order to count the document as a match.
    ALL = "all"


class Speller(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Speller."""

    #: Speller not enabled.
    NONE = "none"
    #: Speller corrects individual query terms using a static lexicon for the language specified by
    #: the queryLanguage parameter.
    LEXICON = "lexicon"
