/*-
 * Copyright © 2011, 2025
 *	mirabilos <m$(date +%Y)@mirbsd.de>
 *
 * Provided that these terms and disclaimer and all copyright notices
 * are retained or reproduced in an accompanying document, permission
 * is granted to deal in this work without restriction, including un‐
 * limited rights to use, publicly perform, distribute, sell, modify,
 * merge, give away, or sublicence.
 *
 * This work is provided “AS IS” and WITHOUT WARRANTY of any kind, to
 * the utmost extent permitted by applicable law, neither express nor
 * implied; without malicious intent or gross negligence. In no event
 * may a licensor, author or contributor be held liable for indirect,
 * direct, other damage, loss, or other issues arising in any way out
 * of dealing in the work, even if advised of the possibility of such
 * damage or existence of a defect, except proven that it results out
 * of said person’s immediate fault when using the work as intended.
 */

#include <stdlib.h>

#include "kwalletcli.h"

const char __rcsid_charconv_c[] =
    "$MirOS: contrib/hosted/tg/code/kwalletcli/charconv.c,v 1.6 2025/12/14 02:20:57 tg Exp $";

/* From MirOS: contrib/hosted/tg/code/any2utf8/wide.c,v 1.1 2009/08/02 17:12:07 tg Exp */


size_t
utf_32to8(char *dst, unsigned int wc)
{
	unsigned char *cp = (unsigned char *)dst;
	unsigned int count;

	if (wc > 0x0010FFFFU)
		/* beyond UTF-8 */
		abort();

	if (wc < 0x80U) {
		count = 0;
		*cp++ = wc;
	} else if (wc < 0x0800U) {
		count = 1;
		*cp++ = (wc >> 6) | 0xC0U;
	} else if (wc < 0x00010000U) {
		count = 2;
		*cp++ = (wc >> 12) | 0xE0U;
	} else {
		count = 3;
		*cp++ = (wc >> 18) | 0xF0U;
	}

	while (count)
		*cp++ = ((wc >> (6 * --count)) & 0x3FU) | 0x80U;

	return ((size_t)((char *)cp - dst));
}

size_t
utf_8to32(const char *src, unsigned int *dst)
{
	const unsigned char *s = (const unsigned char *)src;
	unsigned int wc, count = 0;
	unsigned char c;

	wc = *s++;
	if (wc < 0xC2U || wc > 0xF4U) {
		if (wc >= 0x80U)
			return (UTFCONV_ERROR);
	} else if (wc < 0xE0U) {
		count = 1; /* one byte follows */
		wc = (wc & 0x1FU) << 6;
	} else if (wc < 0xF0U) {
		count = 2; /* two bytes follow */
		wc = (wc & 0x0FU) << 12;
	} else {
		count = 3; /* three bytes follow */
		wc = (wc & 0x07U) << 18;
	}

	while (count) {
		if (((c = *s++) & 0xC0U) != 0x80U)
			return (UTFCONV_ERROR);
		wc |= (c & 0x3FU) << (6 * --count);
		if (!count)
			break;
		if (wc < (1U << (5 * count + 6)))
			return (UTFCONV_ERROR);
	}

	if (wc == 0xFFFEU || wc == 0xFFFFU || wc > 0x0010FFFFU ||
	    (wc >= 0xD800U && wc <= 0xDFFFU))
		return (UTFCONV_ERROR);
	*dst = wc;
	return ((size_t)((const char *)s - src));
}
