// graph-tool -- a general graph modification and manipulation thingy
//
// Copyright (C) 2006-2022 Tiago de Paula Peixoto <tiago@skewed.de>
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License as published by the Free
// Software Foundation; either version 3 of the License, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include "graph.hh"
#include <boost/python.hpp>

using namespace boost;

void export_parallel();
void export_histograms();
void export_average();
void export_distance();
void export_sampled_distance();

BOOST_PYTHON_MODULE(libgraph_tool_stats)
{
    python::docstring_options dopt(true, false);
    export_parallel();
    export_histograms();
    export_average();
    export_distance();
    export_sampled_distance();
}
