# frozen_string_literal: true

module Sbom
  module PurlType
    class Converter
      PACKAGE_MANAGER_TO_PURL_TYPE_MAP = {
        'bundler' => 'gem',
        'yarn' => 'npm',
        'npm' => 'npm',
        'pnpm' => 'npm',
        'maven' => 'maven',
        'sbt' => 'maven',
        'gradle' => 'maven',
        'composer' => 'composer',
        'conan' => 'conan',
        'go' => 'golang',
        'gobinary' => 'golang', # this package manager is generated by trivy
        'nuget' => 'nuget',
        'pip' => 'pypi',
        'pipenv' => 'pypi',
        'poetry' => 'pypi',
        'setuptools' => 'pypi',
        'python-pkg' => 'pypi', # this package manager is generated by trivy
        'conda' => 'conda',
        'conda-pkg' => 'conda', # this package manager is generated by trivy,
        'conda-environment' => 'conda' # this package manager is generated by trivy
      }.with_indifferent_access.freeze

      def self.purl_type_for_pkg_manager(package_manager)
        matches = package_manager.match(TRIVY_PACKAGE_MANAGER_REGEX)

        package_manager = matches['trivy-package-manager-type'] if matches

        PACKAGE_MANAGER_TO_PURL_TYPE_MAP[package_manager]
      end

      TRIVY_PACKAGE_MANAGER_REGEX = /\((?<trivy-package-manager-type>.*?)\)/
      private_constant :TRIVY_PACKAGE_MANAGER_REGEX
    end
  end
end
