---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Content-Security-Policy-Report-Only analysis

## Description

A `Content-Security-Policy-Report-Only` (CSPRO) was identified on the target site. CSP-Report-Only headers
aid in determining how to implement a `Content-Security-Policy` that does not disrupt normal use of the target
site.

## Remediation

Follow the recommendations to determine if any actions are necessary to harden this `Content-Security-Policy-Report-Only`.
After all alerts have been resolved, we recommend that this header be changed to `Content-Security-Policy`.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 16.9 | true | 16 | Passive | Info |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/16.html)
- [OWASP](https://cheatsheetseries.owasp.org/cheatsheets/Content_Security_Policy_Cheat_Sheet.html)
- [MDN](https://developer.mozilla.org/en-US/docs/Web/HTTP/CSP)
- [Content Security Policy Level 3](https://www.w3.org/TR/CSP3/)
- [CSP Evaluator](https://csp-evaluator.withgoogle.com/)
