#!/bin/sh
# (C) Copyright 2005- ECMWF.
#
# This software is licensed under the terms of the Apache Licence Version 2.0
# which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
# 
# In applying this licence, ECMWF does not waive the privileges and immunities granted to it by
# virtue of its status as an intergovernmental organisation nor does it submit to any jurisdiction.
#

. ./include.sh

tempOut=temp.bufr_keys_iter.$$.out
tempRef=temp.bufr_keys_iter.$$.ref

# Test: check ident key is present
# -------------------------------------------
input=${data_dir}/bufr/syno_multi.bufr
$EXEC ${test_dir}/bufr_keys_iter -a $input > $tempOut
grep -q '^ident$' $tempOut


# Test: check full output
# -------------------------------------------
input=${data_dir}/bufr/aaen_55.bufr
$EXEC ${test_dir}/bufr_keys_iter -a $input > $tempOut

# Check the output of BUFR keys iterator
# Note: the two hidden keys 'typicalDate' and 'typicalTime' are NOT in the iterator output
cat > $tempRef<<EOF
edition
masterTableNumber
bufrHeaderCentre
bufrHeaderSubCentre
updateSequenceNumber
dataCategory
internationalDataSubCategory
dataSubCategory
masterTablesVersionNumber
localTablesVersionNumber
typicalYear
typicalMonth
typicalDay
typicalHour
typicalMinute
typicalSecond
typicalDate
typicalTime
rdbType
oldSubtype
localYear
localMonth
localDay
localHour
localMinute
localSecond
rdbtimeDay
rdbtimeHour
rdbtimeMinute
rdbtimeSecond
rdbtimeTime
rectimeDay
rectimeHour
rectimeMinute
rectimeSecond
restricted
correction1
correction1Part
correction2
correction2Part
correction3
correction3Part
correction4
correction4Part
qualityControl
newSubtype
numberOfSubsets
localLongitude1
localLatitude1
localLongitude2
localLatitude2
localNumberOfObservations
satelliteID
observedData
compressedData
unexpandedDescriptors
#1#tovsOrAtovsProductQualifier
#1#centre
#1#subCentre
#2#tovsOrAtovsProductQualifier
#2#centre
#2#subCentre
#1#satelliteIdentifier
#1#satelliteSensorIndicator
#1#orbitNumber
#1#satelliteAntennaCorrectionsVersionNumber
#1#scanLineNumber
#1#fieldOfViewNumber
#1#majorFrameCount
#1#scanLineStatusFlagsForAtovs
#1#scanLineQualityFlagsForAtovs
#1#year
#1#month
#1#day
#1#hour
#1#minute
#1#second
#1#latitude
#1#longitude
#1#heightOfStation
#1#satelliteZenithAngle
#1#bearingOrAzimuth
#1#solarZenithAngle
#1#solarAzimuth
#1#fieldOfViewQualityFlagsForAtovs
#1#radiometerIdentifier
#1#instrumentTemperature
#2#radiometerIdentifier
#2#instrumentTemperature
#3#radiometerIdentifier
#3#instrumentTemperature
#4#radiometerIdentifier
#4#instrumentTemperature
#1#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#1#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#1#bandwidthCorrectionCoefficient1ForAtovs
#1#bandwidthCorrectionCoefficient2ForAtovs
#1#channelQualityFlagsForAtovs
#1#brightnessTemperature
#2#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#2#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#2#bandwidthCorrectionCoefficient1ForAtovs
#2#bandwidthCorrectionCoefficient2ForAtovs
#2#channelQualityFlagsForAtovs
#2#brightnessTemperature
#3#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#3#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#3#bandwidthCorrectionCoefficient1ForAtovs
#3#bandwidthCorrectionCoefficient2ForAtovs
#3#channelQualityFlagsForAtovs
#3#brightnessTemperature
#4#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#4#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#4#bandwidthCorrectionCoefficient1ForAtovs
#4#bandwidthCorrectionCoefficient2ForAtovs
#4#channelQualityFlagsForAtovs
#4#brightnessTemperature
#5#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#5#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#5#bandwidthCorrectionCoefficient1ForAtovs
#5#bandwidthCorrectionCoefficient2ForAtovs
#5#channelQualityFlagsForAtovs
#5#brightnessTemperature
#6#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#6#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#6#bandwidthCorrectionCoefficient1ForAtovs
#6#bandwidthCorrectionCoefficient2ForAtovs
#6#channelQualityFlagsForAtovs
#6#brightnessTemperature
#7#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#7#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#7#bandwidthCorrectionCoefficient1ForAtovs
#7#bandwidthCorrectionCoefficient2ForAtovs
#7#channelQualityFlagsForAtovs
#7#brightnessTemperature
#8#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#8#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#8#bandwidthCorrectionCoefficient1ForAtovs
#8#bandwidthCorrectionCoefficient2ForAtovs
#8#channelQualityFlagsForAtovs
#8#brightnessTemperature
#9#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#9#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#9#bandwidthCorrectionCoefficient1ForAtovs
#9#bandwidthCorrectionCoefficient2ForAtovs
#9#channelQualityFlagsForAtovs
#9#brightnessTemperature
#10#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#10#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#10#bandwidthCorrectionCoefficient1ForAtovs
#10#bandwidthCorrectionCoefficient2ForAtovs
#10#channelQualityFlagsForAtovs
#10#brightnessTemperature
#11#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#11#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#11#bandwidthCorrectionCoefficient1ForAtovs
#11#bandwidthCorrectionCoefficient2ForAtovs
#11#channelQualityFlagsForAtovs
#11#brightnessTemperature
#12#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#12#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#12#bandwidthCorrectionCoefficient1ForAtovs
#12#bandwidthCorrectionCoefficient2ForAtovs
#12#channelQualityFlagsForAtovs
#12#brightnessTemperature
#13#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#13#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#13#bandwidthCorrectionCoefficient1ForAtovs
#13#bandwidthCorrectionCoefficient2ForAtovs
#13#channelQualityFlagsForAtovs
#13#brightnessTemperature
#14#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#14#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#14#bandwidthCorrectionCoefficient1ForAtovs
#14#bandwidthCorrectionCoefficient2ForAtovs
#14#channelQualityFlagsForAtovs
#14#brightnessTemperature
#15#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#15#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#15#bandwidthCorrectionCoefficient1ForAtovs
#15#bandwidthCorrectionCoefficient2ForAtovs
#15#channelQualityFlagsForAtovs
#15#brightnessTemperature
#16#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#16#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#16#bandwidthCorrectionCoefficient1ForAtovs
#16#bandwidthCorrectionCoefficient2ForAtovs
#16#channelQualityFlagsForAtovs
#16#brightnessTemperature
#17#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#17#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#17#bandwidthCorrectionCoefficient1ForAtovs
#17#bandwidthCorrectionCoefficient2ForAtovs
#17#channelQualityFlagsForAtovs
#17#brightnessTemperature
#18#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#18#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#18#bandwidthCorrectionCoefficient1ForAtovs
#18#bandwidthCorrectionCoefficient2ForAtovs
#18#channelQualityFlagsForAtovs
#18#brightnessTemperature
#19#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#19#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#19#bandwidthCorrectionCoefficient1ForAtovs
#19#bandwidthCorrectionCoefficient2ForAtovs
#19#channelQualityFlagsForAtovs
#19#brightnessTemperature
#20#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#1#albedoRadianceSolarFilteredIrradianceForAtovs
#1#albedoRadianceEquivalentFilterWidthForAtovs
#20#channelQualityFlagsForAtovs
#1#channelRadiance
EOF

diff $tempRef $tempOut

## Now iterate over Data Section keys and skip all others
# ---------------------------------------------------------
$EXEC ${test_dir}/bufr_keys_iter -d $input > $tempOut
cat > $tempRef<<EOF
#1#tovsOrAtovsProductQualifier
#1#centre
#1#subCentre
#2#tovsOrAtovsProductQualifier
#2#centre
#2#subCentre
#1#satelliteIdentifier
#1#satelliteSensorIndicator
#1#orbitNumber
#1#satelliteAntennaCorrectionsVersionNumber
#1#scanLineNumber
#1#fieldOfViewNumber
#1#majorFrameCount
#1#scanLineStatusFlagsForAtovs
#1#scanLineQualityFlagsForAtovs
#1#year
#1#month
#1#day
#1#hour
#1#minute
#1#second
#1#latitude
#1#longitude
#1#heightOfStation
#1#satelliteZenithAngle
#1#bearingOrAzimuth
#1#solarZenithAngle
#1#solarAzimuth
#1#fieldOfViewQualityFlagsForAtovs
#1#radiometerIdentifier
#1#instrumentTemperature
#2#radiometerIdentifier
#2#instrumentTemperature
#3#radiometerIdentifier
#3#instrumentTemperature
#4#radiometerIdentifier
#4#instrumentTemperature
#1#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#1#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#1#bandwidthCorrectionCoefficient1ForAtovs
#1#bandwidthCorrectionCoefficient2ForAtovs
#1#channelQualityFlagsForAtovs
#1#brightnessTemperature
#2#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#2#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#2#bandwidthCorrectionCoefficient1ForAtovs
#2#bandwidthCorrectionCoefficient2ForAtovs
#2#channelQualityFlagsForAtovs
#2#brightnessTemperature
#3#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#3#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#3#bandwidthCorrectionCoefficient1ForAtovs
#3#bandwidthCorrectionCoefficient2ForAtovs
#3#channelQualityFlagsForAtovs
#3#brightnessTemperature
#4#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#4#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#4#bandwidthCorrectionCoefficient1ForAtovs
#4#bandwidthCorrectionCoefficient2ForAtovs
#4#channelQualityFlagsForAtovs
#4#brightnessTemperature
#5#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#5#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#5#bandwidthCorrectionCoefficient1ForAtovs
#5#bandwidthCorrectionCoefficient2ForAtovs
#5#channelQualityFlagsForAtovs
#5#brightnessTemperature
#6#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#6#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#6#bandwidthCorrectionCoefficient1ForAtovs
#6#bandwidthCorrectionCoefficient2ForAtovs
#6#channelQualityFlagsForAtovs
#6#brightnessTemperature
#7#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#7#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#7#bandwidthCorrectionCoefficient1ForAtovs
#7#bandwidthCorrectionCoefficient2ForAtovs
#7#channelQualityFlagsForAtovs
#7#brightnessTemperature
#8#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#8#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#8#bandwidthCorrectionCoefficient1ForAtovs
#8#bandwidthCorrectionCoefficient2ForAtovs
#8#channelQualityFlagsForAtovs
#8#brightnessTemperature
#9#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#9#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#9#bandwidthCorrectionCoefficient1ForAtovs
#9#bandwidthCorrectionCoefficient2ForAtovs
#9#channelQualityFlagsForAtovs
#9#brightnessTemperature
#10#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#10#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#10#bandwidthCorrectionCoefficient1ForAtovs
#10#bandwidthCorrectionCoefficient2ForAtovs
#10#channelQualityFlagsForAtovs
#10#brightnessTemperature
#11#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#11#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#11#bandwidthCorrectionCoefficient1ForAtovs
#11#bandwidthCorrectionCoefficient2ForAtovs
#11#channelQualityFlagsForAtovs
#11#brightnessTemperature
#12#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#12#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#12#bandwidthCorrectionCoefficient1ForAtovs
#12#bandwidthCorrectionCoefficient2ForAtovs
#12#channelQualityFlagsForAtovs
#12#brightnessTemperature
#13#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#13#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#13#bandwidthCorrectionCoefficient1ForAtovs
#13#bandwidthCorrectionCoefficient2ForAtovs
#13#channelQualityFlagsForAtovs
#13#brightnessTemperature
#14#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#14#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#14#bandwidthCorrectionCoefficient1ForAtovs
#14#bandwidthCorrectionCoefficient2ForAtovs
#14#channelQualityFlagsForAtovs
#14#brightnessTemperature
#15#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#15#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#15#bandwidthCorrectionCoefficient1ForAtovs
#15#bandwidthCorrectionCoefficient2ForAtovs
#15#channelQualityFlagsForAtovs
#15#brightnessTemperature
#16#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#16#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#16#bandwidthCorrectionCoefficient1ForAtovs
#16#bandwidthCorrectionCoefficient2ForAtovs
#16#channelQualityFlagsForAtovs
#16#brightnessTemperature
#17#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#17#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#17#bandwidthCorrectionCoefficient1ForAtovs
#17#bandwidthCorrectionCoefficient2ForAtovs
#17#channelQualityFlagsForAtovs
#17#brightnessTemperature
#18#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#18#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#18#bandwidthCorrectionCoefficient1ForAtovs
#18#bandwidthCorrectionCoefficient2ForAtovs
#18#channelQualityFlagsForAtovs
#18#brightnessTemperature
#19#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#19#log10OfTemperatureRadianceCentralWaveNumberForAtovs
#19#bandwidthCorrectionCoefficient1ForAtovs
#19#bandwidthCorrectionCoefficient2ForAtovs
#19#channelQualityFlagsForAtovs
#19#brightnessTemperature
#20#tovsOrAtovsOrAvhrrInstrumentationChannelNumber
#1#albedoRadianceSolarFilteredIrradianceForAtovs
#1#albedoRadianceEquivalentFilterWidthForAtovs
#20#channelQualityFlagsForAtovs
#1#channelRadiance
EOF

diff $tempRef $tempOut


rm -f $tempRef $tempOut
