/*****************************************************************************
* ppipemon.h	PPP Monitor definitions.
*
* Author:	Jaspreet Singh <jaspreet@sangoma.com>
*
* Copyright:	(c) 1995-1997 Sangoma Technologies Inc.
*
*		This program is free software; you can redistribute it and/or
*		modify it under the terms of the GNU General Public License
*		as published by the Free Software Foundation; either version
*		2 of the License, or (at your option) any later version.
* ----------------------------------------------------------------------------
* Oct 20, 1997	Jaspreet Singh  Driver Statistics commands, Router Up command
* Jun 24, 1997  Jaspreet Singh	S508/FT1 commands
* Apr 25, 1997	Farhan Thawar	Initial version based on ppipemon for WinNT.
*****************************************************************************/

/* PPP Mailbox commands needed */
#define READ_CONFIGURATION				0x06
#define READ_OPERATIONAL_STATISTICS			0x07
#define FLUSH_OPERATIONAL_STATISTICS			0x08
#define READ_COMMS_ERR_STATISTICS			0x09
#define FLUSH_COMMS_ERR_STATISTICS			0x0A
#define READ_CODE_VERSION				0x10
#define READ_PACKET_STATISTICS				0x12
#define FLUSH_PACKET_STATISTICS				0x13
#define READ_LCP_STATISTICS				0x14
#define FLUSH_LCP_STATISTICS				0x15
#define READ_LOOPBACK_ERR_STATISTICS			0x16
#define FLUSH_LOOPBACK_ERR_STATISTICS			0x17
#define READ_IPCP_STATISTICS				0x18
#define FLUSH_IPCP_STATISTICS				0x19
#define READ_IPXCP_STATISTICS				0x1A
#define FLUSH_IPXCP_STATISTICS				0x1B
#define READ_PAP_STATISTICS				0x1C
#define FLUSH_PAP_STATISTICS				0x1D
#define READ_CHAP_STATISTICS				0x1E
#define FLUSH_CHAP_STATISTICS				0x1F
#define READ_CONNECTION_INFORMATION			0x32
#define FT1_MONITOR_STATUS_CTRL				0x80
#define SET_FT1_MODE					0x81

#define	Z80_TIMEOUT_ERROR		0x0A
#define	DATA_LENGTH_TOO_BIG		0x05
#define	NO_BUFFS			0x08
#define	NO_DATA_AVAILABLE		0x05

/* Special UDP drivers management commands */
#define PPIPE_ENABLE_TRACING				0x20
#define PPIPE_DISABLE_TRACING				0x21
#define PPIPE_GET_TRACE_INFO				0x22
#define PPIPE_GET_IBA_DATA				0x23
#define PPIPE_FT1_READ_STATUS				0x25
#define PPIPE_DRIVER_STAT_IFSEND			0x26
#define PPIPE_DRIVER_STAT_INTR				0x27
#define PPIPE_DRIVER_STAT_GEN				0x28
#define PPIPE_FLUSH_DRIVER_STATS			0x29
#define PPIPE_ROUTER_UP_TIME				0x30
