#include "internal.h"
#include <stdio.h>
#include <string.h>
#include <errno.h>

static int been_there_done_that = 0;

static const struct Applet applets[] = {

#ifdef TLG_TINYLOGIN		//bin
    {"tinylogin", tinylogin_main},
#endif
#ifdef TLG_ADDUSER		//bin
    {"adduser", adduser_main},
#endif
#ifdef TLG_ADDGROUP		//bin
    {"addgroup", addgroup_main},
#endif
#ifdef TLG_DELUSER		//bin
    {"deluser", deluser_main},
#endif
#ifdef TLG_DELGROUP		//bin
    {"delgroup", delgroup_main},
#endif
#ifdef TLG_LOGIN		//bin
    {"login", login_main},
#endif
#ifdef TLG_SULOGIN		//sbin
    {"sulogin", sulogin_main},
#endif
#ifdef TLG_PASSWD		//usr/bin
    {"passwd", passwd_main},
#endif
#ifdef TLG_GETTY		//sbin
    {"getty", getty_main},
#endif
    {0}
};

int main(int argc, char **argv)
{
    char *s = argv[0];
    char *name = argv[0];
    const struct Applet *a = applets;

    while (*s != '\0') {
	if (*s++ == '/')
	    name = s;
    }

    while (a->name != 0) {
	if (strcmp(name, a->name) == 0) {
	    int status;

	    status = ((*(a->main)) (argc, argv));
	    if (status < 0) {
		fprintf(stderr, "%s: %s\n", a->name, strerror(errno));
	    }
	    fprintf(stderr, "\n");
	    exit(status);
	}
	a++;
    }
    exit (tinylogin_main(argc, argv));
}


extern int 
tinylogin_main(int argc, char **argv)
{
    int col=0;
    argc--;
    argv++;

    if (been_there_done_that == 1 || argc < 1) {
	const struct Applet *a = applets;
	fprintf(stderr, "TinyLogin v%s (%s) multi-call binary -- GPL2\n\n",
		TLG_VER, TLG_BT);
	fprintf(stderr, "Usage: tinylogin [function] [arguments]...\n");
	fprintf(stderr, "   or: [function] [arguments]...\n\n");
	fprintf(stderr,
		"\tMost people will create a symlink to tinylogin for each\n"
		"\tfunction name, and tinylogin will act like whatever you invoke it as.\n");
	fprintf(stderr, "\nCurrently defined functions:\n");

	while (a->name != 0) {
	    col+=fprintf(stderr, "%s%s", ((col==0)? "\t":", "), (a++)->name);
	    if (col>60) {
		fprintf(stderr, ",\n");
		col=0;
	    }
	}
	fprintf(stderr, "\n\n");
	exit(-1);
    } else {
	/* If we've already been here once, exit now */
	been_there_done_that = 1;
	return (main(argc, argv));
    }
}
