/*
 * deluser (remove lusers from the system ;) for TinyLogin
 *
 *
 * Copyright (C) 1999 by Lineo, inc.
 * Written by John Beppu <beppu@lineo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include "internal.h"
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#if 0
#  define PASSWD_FILE	"/etc/passwd"
#  define SHADOW_FILE   "/etc/shadow"
#  define PASSWD_FILE	"passwd"
#  define SHADOW_FILE	"shadow"
#endif


/* where to start and stop deletion */
typedef struct {
    size_t  start;
    size_t  stop;
} Bounds;

static const char deluser_usage[] =
"Usage: deluser [LOGIN]\n\n"
;

static const char delgroup_usage[] =
"Usage: deluser [GROUP]\n\n"
;

/* An interesting side-effect of boundary()'s
 * implementation is that the first user (typically root)
 * cannot be removed.  Let's call it a feature. */
static Bounds
boundary(const char *buffer, const char *login)
{
    char    needle[256];
    char    *start;
    char    *stop;
    Bounds  b;

    sprintf(needle,"\n%s", login);
    start = strstr(buffer, needle);
    if (!start) {
	b.start = 0;
	b.stop  = 0;
	return b;
    }
    start++;

    stop    = index(start, '\n');   /* index is a BSD-ism */
    b.start = start - buffer;
    b.stop  = stop  - buffer;
    return b;
}

/* grep -v ^login (except it only deletes the first match) */
/* ...in fact, I think I'm going to simplify this later */
static int
del_line_matching(char *login, char *filename)
{
    char        *buffer;
    FILE        *passwd;
    size_t      len;
    Bounds	b;
    struct stat statbuf;

    /* load into buffer */
    passwd = fopen(filename, "r");
    if (!passwd) { return 0; }
    stat(filename, &statbuf);
    len = statbuf.st_size;
    buffer = (char *) malloc(len * sizeof(char));
    if (!buffer) {
	fclose(passwd);
	return 0;
    }
    fread(buffer, len, sizeof(char), passwd);
    fclose(passwd);

    /* find the user to remove */
    b = boundary(buffer, login);
    if (b.stop == 0) { 
	free(buffer);
	return 0; 
    }

    /* write the file w/o the user */
    passwd = fopen(filename, "w");
    if (!passwd) { return 0; }
    fwrite(buffer, (b.start - 1), 
	    sizeof(char), passwd);
    fwrite(&buffer[b.stop], (len - b.stop), 
	    sizeof(char), passwd);
    fclose(passwd);

    return 1;
}

/* ________________________________________________________________________ */
int
delgroup_main(int argc, char **argv)
{
    int successful;

    if (argc != 2) {
	usage(delgroup_usage);
	exit(1);
    } else {

#if 0
	successful = del_line_matching(argv[1], "group");
	if (!successful) {
	    fprintf ( stderr, "delgroup: %s: Group could not be removed\n", argv[1]);
	    exit(1);
	}
#else
	successful = del_line_matching(argv[1], GROUP_FILE);
	if (!successful) {
	    fprintf ( stderr, "delgroup: %s: Group could not be removed\n", argv[1]);
	    exit(1);
	}
#endif

    }
    exit(0);
}

/* ________________________________________________________________________ */
int
deluser_main(int argc, char **argv)
{
    int successful;

    if (argc != 2) {
	usage(deluser_usage);
	exit(1);
    } else {

#if 0
	successful = del_line_matching(argv[1], "passwd");
	if (!successful) {
	    fprintf ( stderr, "deluser: %s: User could not be removed\n", argv[1]);
	    exit(1);
	}
#else
	successful = del_line_matching(argv[1], PASSWD_FILE);
	if (!successful) {
	    fprintf ( stderr, "deluser: %s: User could not be removed from %s\n", 
		    argv[1], PASSWD_FILE);
	    exit(1);
	}
	successful = del_line_matching(argv[1], SHADOW_FILE);
	if (!successful) {
	    fprintf ( stderr, "deluser: %s: User could not be removed from %s\n", 
		    argv[1], SHADOW_FILE);
	    exit(1);
	}
#endif

    }
    exit(0);
}

/* $Id: deluser.c,v 1.7 1999/12/29 21:59:57 beppu Exp $ */
