/*
 * control KLIPS debugging options
 * Copyright (C) 1996  John Ioannidis.
 * Copyright (C) 1998, 1999  Richard Guy Briggs.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

char klipsdebug_c_version[] = "RCSID $Id: klipsdebug.c,v 1.20 1999/04/12 01:27:10 henry Exp $";


#include <sys/types.h>
#include <linux/types.h> /* new */
#include <string.h>
#include <errno.h>

#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>



#include <unistd.h>
#include "../../lib/freeswan.h"
#include "radij.h"
#include "ipsec_encap.h"
#ifndef DEBUG_IPSEC
#define DEBUG_IPSEC
#endif /* DEBUG_IPSEC */
#include "ipsec_netlink.h"

#include "version.c"

#include <stdio.h>
#include <getopt.h>

__u32 bigbuf[1024];
char *program_name;

char copyright[] =
"Copyright (C) 1999 Henry Spencer, Richard Guy Briggs, D. Hugh Redelmeier,\n\
	Sandy Harris, Angelos D. Keromytis, John Ioannidis.\n\
\n\
   This program is free software; you can redistribute it and/or modify it\n\
   under the terms of the GNU General Public License as published by the\n\
   Free Software Foundation; either version 2 of the License, or (at your\n\
   option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.\n\
\n\
   This program is distributed in the hope that it will be useful, but\n\
   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY\n\
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License\n\
   (file COPYING in the distribution) for more details.\n";

inline int x2i(char *s)
{
	char ss[3];
	char *endptr;
	__u32 n;
	ss[0] = s[0];
	ss[1] = s[1];
	ss[2] = 0;

	n = strtoul(ss, &endptr, 16);
	if(!(endptr == ss + strlen(ss))) {
		fprintf(stderr, "%s: Invalid character in numerical input stream: %s\n",
			program_name, ss);
		exit (1);
	}
	return n;
}
	
void
usage(char * arg)
{
	fprintf(stdout, "usage: %s {--set|--clear} {tunnel|netlink|xform|eroute|spi|radij|esp|ah|rcv}\n", arg);
	fprintf(stdout, "       %s {--all|--none}\n", arg);
	fprintf(stdout, "       %s --help\n", arg);
	fprintf(stdout, "       %s --version\n", arg);
	exit(1);
}

static struct option const longopts[] =
{
	{"set", 1, 0, 's'},
	{"clear", 1, 0, 'c'},
	{"all", 0, 0, 'a'},
	{"none", 0, 0, 'n'},
	{"help", 0, 0, 'h'},
	{"version", 0, 0, 'v'},
	{"label", 1, 0, 'l'},
	{"optionsfrom", 1, 0, '+'},
	{0, 0, 0, 0}
};

int
main(argc, argv)
int argc;
char **argv;
{
	int fd;
	unsigned char action = 0;
	int i, dlen, *debug;
	int c, previous = -1;
	
	struct encap_msghdr *em = (struct encap_msghdr *)bigbuf;
	debug = (int *)&em->em_db_tn;

	program_name = argv[0];

	while((c = getopt_long(argc, argv, "s:c:anhvl:+:", longopts, 0)) != EOF) {
		switch(c) {
		case 's':
			if(action) {
				fprintf(stderr, "%s: Only one of '--set', '--clear', '--all' or '--none' options permitted.\n",
					program_name);
				exit(1);
			}
			action = 's';
			for (i = 0; i < (sizeof(em->Eu.Dbg)/sizeof(int)); i++) {
				*(debug++) = 0;
			}
			if(strcmp(optarg, "tunnel") == 0) {
				em->em_db_tn = -1L;
			} else if(strcmp(optarg, "netlink") == 0) {
				em->em_db_nl = -1L;
			} else if(strcmp(optarg, "xform") == 0) {
				em->em_db_xf = -1L;
			} else if(strcmp(optarg, "eroute") == 0) {
				em->em_db_er = -1L;
			} else if(strcmp(optarg, "spi") == 0) {
				em->em_db_sp = -1L;
			} else if(strcmp(optarg, "radij") == 0) {
				em->em_db_rj = -1L;
			} else if(strcmp(optarg, "esp") == 0) {
				em->em_db_es = -1L;
			} else if(strcmp(optarg, "ah") == 0) {
				em->em_db_ah = -1L;
			} else if(strcmp(optarg, "rcv") == 0) {
				em->em_db_rx = -1L;
			} else {
				usage(program_name);
			}
			em->em_db_nl |= 1 << (sizeof(em->em_db_nl) * 8 -1);
			break;
		case 'c':
			if(action) {
				fprintf(stderr, "%s: Only one of '--set', '--clear', '--all' or '--none' options permitted.\n",
					program_name);
				exit(1);
			}
			action = 'c';
			for (i = 0; i < (sizeof(em->Eu.Dbg)/sizeof(int)); i++) {
				*(debug++) = -1;
			}
			if(strcmp(optarg, "tunnel") == 0){
				em->em_db_tn = 0;
			}else if(strcmp(optarg, "netlink") == 0){
				em->em_db_nl = 0;
			}else if(strcmp(optarg, "xform") == 0){
				em->em_db_xf = 0;
			}else if(strcmp(optarg, "eroute") == 0){
				em->em_db_er = 0;
			}else if(strcmp(optarg, "spi") == 0){
				em->em_db_sp = 0;
			}else if(strcmp(optarg, "radij") == 0){
				em->em_db_rj = 0;
			}else if(strcmp(optarg, "esp") == 0){
				em->em_db_es = 0;
			}else if(strcmp(optarg, "ah") == 0){
				em->em_db_ah = 0;
			}else if(strcmp(optarg, "rcv") == 0){
				em->em_db_rx = 0;
			}else{
				usage(program_name);
			}
			em->em_db_nl &= ~(1 << (sizeof(em->em_db_nl) * 8 -1));
			break;
		case 'a':
			if(action) {
				fprintf(stderr, "%s: Only one of '--set', '--clear', '--all' or '--none' options permitted.\n",
					program_name);
				exit(1);
			}
			action = 'a';
			for (i = 0; i < (sizeof(em->Eu.Dbg)/sizeof(int)); i++) {
				*(debug++) = -1;
			}
			break;
		case 'n':
			if(action) {
				fprintf(stderr, "%s: Only one of '--set', '--clear', '--all' or '--none' options permitted.\n",
					program_name);
				exit(1);
			}
			action = 'n';
			for (i = 0; i < (sizeof(em->Eu.Dbg)/sizeof(int)); i++) {
				*(debug++) = 0;
			}
			break;
		case 'h':
		case '?':
			usage(program_name);
			exit(1);
		case 'v':
			printf("klipsdebug (Linux FreeS/WAN %s) %s\n",
				freeswan_version, klipsdebug_c_version);
			fputs(copyright, stdout);
			exit(0);
		case 'l':
			program_name = optarg;
			break;
		case '+': /* optionsfrom */
			optionsfrom(optarg, &argc, &argv, optind, stderr);
			/* no return on error */
			break;
		default:
		}
		previous = c;
	}

	if(!action) {
		usage(program_name);
	}
 	em->em_magic = EM_MAGIC;
	em->em_version = 0;
	em->em_type = EMT_SETDEBUG;
	em->em_msglen = EMT_SETDEBUG_FLEN;

	fd = open("/dev/ipsec", 2);
	if (fd < 0) {
		fprintf(stderr, "%s: Could not open /dev/ipsec -- ", argv[0]);
		switch(errno){
		case ENOENT:
			fprintf(stderr, "device does not exist.  See FreeS/WAN installation procedure.\n");
		case EACCES:
			fprintf(stderr, "access denied.  ");
			if(getuid() == 0){
				fprintf(stderr, "Check permissions.  Should be 600.\n");
			}else{
				fprintf(stderr, "You must be root to open this file.\n");
			}
			break;
		case EUNATCH:
			fprintf(stderr, "Netlink not enabled OR KLIPS not loaded.\n");
			break;
		default:
			fprintf(stderr, "Unknown file open error %d\n", errno);
		}
		exit(1);
	}
	if (write(fd, (caddr_t)em, em->em_msglen) != em->em_msglen){
		fprintf(stderr, "%s: Had trouble writing to /dev/ipsec -- ", argv[0]);
		switch(errno){
		case EINVAL:
			fprintf(stderr, "Invalid argument, check kernel log messages for specifics.\n");
			break;
		default:
			fprintf(stderr, "Unknown file write error %d\n", errno);
		}
		close(fd);
		exit(1);
	}
	close(fd);
	exit(0);
}
/*
 * $Log: klipsdebug.c,v $
 * Revision 1.20  1999/04/12 01:27:10  henry
 * Eric Young waived his advertising clause
 *
 * Revision 1.19  1999/04/11 01:24:53  henry
 * tidy up --version, add copyright notice
 *
 * Revision 1.18  1999/04/11 00:12:08  henry
 * GPL boilerplate
 *
 * Revision 1.17  1999/04/06 04:54:38  rgb
 * Fix/Add RCSID Id: and Log: bits to make PHMDs happy.  This includes
 * patch shell fixes.
 *
 * Revision 1.16  1999/03/17 15:40:54  rgb
 * Make explicit main() return type of int.
 *
 * Revision 1.15  1999/01/22 06:35:19  rgb
 * 64-bit clean-up.
 * Added algorithm switch code.
 *
 * Revision 1.14  1998/11/12 21:08:04  rgb
 * Add --label option to identify caller from scripts.
 *
 * Revision 1.13  1998/10/31 06:35:16  rgb
 * Fixed up comments in #endif directives.
 *
 * Revision 1.12  1998/10/22 06:36:22  rgb
 * Added freeswan.h inclusion.
 *
 * Revision 1.11  1998/10/09 18:47:30  rgb
 * Add 'optionfrom' to get more options from a named file.
 *
 * Revision 1.10  1998/10/09 04:35:31  rgb
 * Changed help output from stderr to stdout.
 * Changed error messages from stdout to stderr.
 * Deleted old commented out cruft.
 *
 * Revision 1.9  1998/08/28 03:13:05  rgb
 * Tidy up old cruft.
 *
 * Revision 1.8  1998/08/05 22:24:45  rgb
 * Change includes to accomodate RH5.x
 *
 * Revision 1.7  1998/07/29 21:36:37  rgb
 * Converted to long option names.
 *
 * Revision 1.6  1998/07/14 18:23:11  rgb
 * Remove unused skbuff header.
 *
 * Revision 1.5  1998/07/09 18:14:10  rgb
 * Added error checking to IP's and keys.
 * Made most error messages more specific rather than spamming usage text.
 * Added more descriptive kernel error return codes and messages.
 * Converted all spi translations to unsigned.
 * Removed all invocations of perror.
 *
 * Revision 1.4  1998/05/27 18:48:21  rgb
 * Adding --help and --version directives.
 *
 * Revision 1.3  1998/05/18 21:19:09  rgb
 * Added options for finer control of debugging switches.
 *
 * Revision 1.2  1998/05/12 02:26:27  rgb
 * Fixed compile errors with IPSEC_DEBUG shut off in the kernel config.
 *
 * Revision 1.1  1998/04/23 21:07:34  rgb
 * Added a userspace utility to change klips kernelspace debug switches.
 *
 * Revision 1.1.1.1  1998/04/08 05:35:09  henry
 * RGB's ipsec-0.8pre2.tar.gz ipsec-0.8
 *
 * Revision 0.3  1996/11/20 14:51:32  ji
 * Fixed problems with #include paths.
 * Changed (incorrect) references to ipsp into ipsec.
 *
 * Revision 0.2  1996/11/08 15:46:29  ji
 * First limited release.
 *
 *
 */
