#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include <unistd.h>
#include <dirent.h>
#include <limits.h>
#include <ctype.h>
#include <assert.h>

#include <curses.h>
#include <term.h>

//#include "dselect.h"
//#include "bindings.h"
//#include "pkglist.h"

enum urqresult { urqr_normal, urqr_fail, urqr_quitmenu };
enum quitaction { qa_noquit, qa_quitchecksave, qa_quitnochecksave };

typedef urqresult urqfunction(void);
//urqfunction urq_list, urq_quit, urq_menu;
//urqfunction urq_setup, urq_update, urq_install, urq_config, urq_remove;

urqresult falliblesubprocess(const char *exepath, const char *name,
                             const char *const *args);

struct menuentry {
  const char *option;
  const char *menuent;
  urqfunction *fn;
};

static const menuentry menuentries[]= {
  { "access",  "Choose the access method to use.",                &urq_setup   },
  { "update",  "Update list of available packages, if possible.", &urq_update  },
  { "select",  "Request which packages you want on your system.", &urq_list    },
  { "install", "Install and upgrade wanted packages.",            &urq_install },
  { "config",  "Configure any packages that are unconfigured.",   &urq_config  },
  { "remove",  "Remove unwanted software.",                       &urq_remove  },
  { "quit",    "Quit dselect.",                                   &urq_quit    },
  { "menu",     0,                                                &urq_menu    },
  {  0                                                                         }
};


urqresult urq_menu(void) {

#define C(x) ((x)-'a'+1)
  int entries, c, i;
  entries= refreshmenu();
  int cursor=0;
  dme(0,1);
  for (;;) {
    refresh();
    c= getch();  if (c==ERR) ohshite("failed to getch in main menu");
    if (c==C('n') || c==KEY_DOWN || c==' ') {
      dme(cursor,0); cursor++; cursor %= entries; dme(cursor,1);
    } else if (c==C('p') || c==KEY_UP || c==C('h') ||
               c==KEY_BACKSPACE || c==KEY_DC) {
      dme(cursor,0); cursor+= entries-1; cursor %= entries; dme(cursor,1);
    } else if (c=='\n' || c=='\r' || c==KEY_ENTER) {
      clear(); refresh();
      switch (menuentries[cursor].fn()) { /* fixme: trap errors in urq_... */
      case urqr_quitmenu:
        return urqr_quitmenu;
      case urqr_normal:
        cursor++; cursor %= entries;
      case urqr_fail:
        break;
      default:
        internerr("unknown menufn");
      }
      refreshmenu(); dme(cursor,1);
    } else if (c==C('l')) {
      clearok(stdscr,TRUE); clear(); refreshmenu(); dme(cursor,1);
    } else if (isdigit(c)) {
      char buf[2]; buf[0]=c; buf[1]=0; c=atoi(buf);
      if (c < entries) {
        dme(cursor,0); cursor=c; dme(cursor,1);
      } else {
        beep();
      }
    } else if (isalpha(c)) {
      c= tolower(c);
      for (i=0; i<entries && menuentries[i].option[0] != c; i++);
      if (i < entries) {
        dme(cursor,0); cursor=i; dme(cursor,1);
      } else {
        beep();
      }
    } else {
      beep();
    }
  }
}

void main ()
{
urq_menu();
cursesoff();
set_error_display(0,0);

}
