/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 2000 */
/* See the file NOTICE for conditions of use and distribution. */

#include "../exim.h"


/*************************************************
*          Decode byte-string in xtext           *
*************************************************/

/* This function decodes a string in xtextformat as defined in RFC 1891
and required by the SMTP AUTH extension (RFC 2554). We put it in a piece of
store of equal length - it cannot be longer than this.

Arguments:
  code        points to the coded string, zero-terminated
  ptr         where to put the pointer to the result, which is in
              dynamic store

Returns:      the number of bytes in the result, which is not zero-terminated
              (it might be binary), or -1 if the input was malformed
*/

int
auth_xtextdecode(char *code, char **ptr)
{
register int x;
char *result = store_get((int)strlen(code) + 1);
*ptr = result;

while ((x = (uschar)(*code++)) != 0)
  {
  if (x < 33 || x > 127 || x == '=') return -1;
  if (x == '+')
    {
    register int y;
    if (!isxdigit((x = (uschar)(*code++)))) return -1;
    y = ((isdigit(x))? x - '0' : (tolower(x) - 'a' + 10)) << 4;
    if (!isxdigit((x = (uschar)(*code++)))) return -1;
    *result++ = y | ((isdigit(x))? x - '0' : (tolower(x) - 'a' + 10));
    }
  else *result++ = x;
  }

return result - *ptr;
}

/* End of xtextdecode.c */
