#include "exim.h"
/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1997 */
/* See the file NOTICE for conditions of use and distribution. */

/* Linux-specific code. This is concatenated onto the generic
src/os.c file. Linux has an apparently unique way of getting the
load average, so we provide a unique function here, and define
OS_LOAD_AVERAGE to stop src/os.c trying to provide the function. */

#define OS_LOAD_AVERAGE


/* This code is apparently the best way of getting the load average
in Linux. */

#include <linux/kernel.h>
#include <linux/sys.h>

int
os_getloadavg(void)
{
struct sysinfo s;
double avg;
if (sysinfo(&s) < 0) return -1;
avg = (double) (s.loads[0]) / (1<<SI_LOAD_SHIFT);
return (int)(avg * 1000.0);
}


/* This code was previously used, but I'm told it isn't as good
as the method above, so comment it out - but keep it, just in case
some system needs it. Linux has many incarnations. You never know. */

#ifdef never
int
os_getloadavg(void)
{
char buffer[40];
double avg;
int count;
int fd = open ("/proc/loadavg", O_RDONLY);
if (fd == -1) return -1;
count = read (fd, buffer, sizeof(buffer));
(void)close (fd);
if (count <= 0) return -1;
count = sscanf (buffer, "%lf", &avg);
if (count < 1) return -1;
return (int)(avg * 1000.0);
}
#endif

/* End of os.c-Linux */
#include "../src/os.c"
