#include <stdlib.h>
#include <string.h>
/* #include <sys/types.h> -- included from "ctar.h" */
#include <sys/stat.h>
#include <pwd.h>    /* getpwuid() */
#include <grp.h>    /* getgrgid() */
#include <fnmatch.h>

#include "ctar.h"

/* following code comes straight from GNU tar-1.12 */
/*------------------------------------------------------------------------.
| Converts long VALUE into a DIGS-digit field at WHERE, including a       |
| trailing space and room for a NUL.  For example, 3 for DIGS 3 means one |
| digit, a space, and room for a NUL.                                     |
|                                                                         |
| We assume the trailing NUL is already there and don't fill it in.  This |
| fact is used by start_header and finish_header, so don't change it!     |
`------------------------------------------------------------------------*/
/* This should be equivalent to: sprintf (WHERE, "%*lo ", DIGS - 2, VALUE);
   except that sprintf fills in the trailing NUL and we don't.  */

void to_oct (long value, int digs, char *where)
{
  --digs;			/* Trailing null slot is left alone */
  where[--digs] = ' ';		/* put in the space, though */

  /* Produce the digits -- at least one.  */

  do
    {
      where[--digs] = '0' + (char) (value & 7);	/* one octal digit */
      value >>= 3;
    }
  while (digs > 0 && value != 0);

  /* Leading spaces, if necessary.  */
  while (digs > 0)
    where[--digs] = ' ';
}
/* this code comes from GNU tar 1.12, modified by emaziuk@curtin.edu.au */
/* Various processing of names */
/* User and group names.  */

void uid_to_uname (uid_t uid, char uname[UNAME_FIELD_SIZE])
{
  struct passwd *passwd;
  passwd = getpwuid (uid);
  if (passwd) {
    strncpy (uname, passwd->pw_name, UNAME_FIELD_SIZE);
    uname[UNAME_FIELD_SIZE] = '\0';
  }
  else uname[0] = '\0';
  return;
}

void gid_to_gname (gid_t gid, char gname[GNAME_FIELD_SIZE])
{
  struct group *group;
  group = getgrgid (gid);
  if (group) {
    strncpy (gname, group->gr_name, GNAME_FIELD_SIZE);
    gname[GNAME_FIELD_SIZE] = '\0';
  }
  else gname[0] = '\0';
  return;
}

/* doubleslash() replaces a "//" with "/" in a string 
 * removes / and "./" from the beginning of the file
 * return -1 if string is longer than 100 chars
 */
/* WARNING: NO CONTROL FOR OVERFLOWS, do not use in security-critical programs */
int doubleslashdot(char *strin, char *strout)
{
  int insl=1, start=1;
  for(;*strin;strin++) {
    if( insl ) {
      if(*strin == '/')
        continue;
      if(*strin == '.' && ((strin[1]=='/') || (strin[1] == '\0'))) {
        continue;
      }
      if(!start)
        *strout++ ='/';
      start=insl=0;
    }
    if( *strin == '/') {
      insl=1;
      continue;
    }
    *strout++ =*strin;
  }
  *strout='\0';
  return(0);
}
