/*
 *  ctar implements (very) minimal subset of the functionality of
 *  `tar -c'.  Usage: `ctar infile'.
 *
 * VERY BIG WARNING: read the README before attempting to use ctar
 * 	-- or else.
 * Parts of this code come from GNU tar-1.12 and Debian star (part of
 * busybox utility on Debian bootdisks) and are copyright by their
 * respective authors.  These are GPL'ed, UTSL for details.
 * The rest of it is a quick and dirty hack and I accept no 
 * responsibility for anything it may do (or not do) 
 * to you, your system, your cat or whatever.
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>

#include "ctar.h"

/* get rid of this if you build a debug version and don't have libdmalloc */
/* #ifdef DEBUG
 * #include <dmalloc.h>
 * #endif
 */
#ifdef VERBOSE
unsigned int counter;
#endif

/* these are global because we need to access them from recursive create() */
char **exclude; 
char **hrdlink;
ino_t *inode;
int numXfiles;
int numHlinks;

void
addfile(char *name, int i)
{ 
    int ec;
#ifdef DEBUG
fprintf(stderr,"\nmain: adding \"%s\" (i = %d)\n",name,i);
#endif
    if((ec=create(name)) !=0 )
#ifdef VERBOSE
        switch(ec) {
          case E_NAMETOOLONG : fprintf(stderr,"Name too long!\n");
                               exit(1);
          case E_CANNOTSTAT  : fprintf(stderr,"Can't stat %s!\n",name);
                               exit(1);
          case E_READLINK    : fprintf(stderr,"Can't read link!\n");
                               exit(1);
          case E_SHORTWRITE  : fprintf(stderr,"Error writing!\n");
                               exit(1);
          case E_FOPEN       : fprintf(stderr,"Can't open %s!\n",name);
                               exit(1);
          case E_MALLOC      : fprintf(stderr,"malloc() error!\n");
                               exit(1);
          case E_OPENDIR     : fprintf(stderr,"Can't open directory %s!\n",name);
                               exit(1);
          case E_WRONG_FTYPE : fprintf(stderr,"Wrong file type %s!\n",name);
                               exit(1);
          case E_STRANGE_ERR : fprintf(stderr,"Strange error on file %s!\n",name);
                               exit(1);
                               
          default : fprintf(stderr,"Weird error -- I give up!\n");
            exit(1);
        }
#else
        exit(1);
#endif
}

int main(int argc, char **argv)
{
    union TarInfo tarInfo;
    char tmp[NAME_FIELD_SIZE];
    int i,j,len;
    
#ifdef DEBUG
for(i=0;i<argc;i++) fprintf(stderr,"%s ",argv[i]);
fprintf(stderr,"\n%d\n",i);
#endif
    if(argc == 1) {
      fprintf(stderr,"\nctar: (very) cut-down tar.  Basic usage: ctar filename(s)\n");
      fprintf(stderr,"Switches ctar knows about: [-x | --exclude | -] filename\n");
      fprintf(stderr,"\t\t-X filename(s)\n");
#ifdef VERBOSE
      fprintf(stderr,"_All_ filenames following -X are excluded from archive. -X must be the last\n");
      fprintf(stderr,"switch on command line.  Single filename following -x is excluded from archive\n");
      fprintf(stderr,"--exclude is a synonym for -x;  multiple -x switches are allowed.\n");
      fprintf(stderr,"Resulting archive (99%% GNU tar - compatible) goes to stdout\n");
#endif
      exit(1);
    }
    inode = NULL; 
    hrdlink = NULL;
/* count the number of files to exclude */
    for(i=1,j=0;i<argc;i++) {
      if((strcmp(argv[i],"-x")==0) || (strcmp(argv[i],"--exclude")==0)) {
        i++;
	numXfiles++;
      }
      if(strcmp(argv[i],"-X")==0) {
        i++;
	break;
      }
    }
    for(;i<argc;i++) numXfiles++;
    if(numXfiles > 0) {
      if((exclude=(char **)malloc((size_t)(numXfiles*sizeof(char *)))) == NULL) {
        fprintf(stderr,"malloc() error in main(), exclude");
        exit(1);
      }
    }
/* now fill in the list of files to exclude */
    for(i=1,j=0;i<argc;i++) {
      if((strcmp(argv[i],"-x")==0) || (strcmp(argv[i],"--exclude")==0)) {
        i++;
#ifdef DEBUG
fprintf(stderr,"%d: excluding file %s\n",i,argv[i]);
#endif
        doubleslashdot(argv[i],tmp);
        len=strlen(tmp);
        exclude[j]=(char *)malloc((size_t) ((len+1)*sizeof(char)));
        strncpy(exclude[j],tmp,len);
        (exclude[j])[len]='\0';
        j++;
      }
      else if(strcmp(argv[i],"-X")==0) {
        i++;
	break;
      }
    }
    for(;i<argc;i++) {
#ifdef DEBUG
fprintf(stderr,"%d: excluding (-X) file %s\n",i,argv[i]);
#endif
      doubleslashdot(argv[i],tmp);
#ifdef DEBUG
fprintf(stderr,"%d: excluding (-X) file %s\n",i,tmp);
#endif
      len=strlen(tmp);
      exclude[j]=(char *)malloc((size_t) ((len+1)*sizeof(char)));
      strncpy(exclude[j],tmp,len);
      (exclude[j])[len]='\0';
      j++;
    }
/*    numXfiles=j; */
#ifdef DEBUG
fprintf(stderr,"numXfiles = %d, j = %d\n",numXfiles,j);
#endif
  
/* create achive */
    for(i=1;i<argc;i++) {
/* skip if it's a switch */
      if( strcmp(argv[i],"-X") == 0)
        break;
      if ((strcmp(argv[i],"-x") == 0) || (strcmp(argv[i],"--exclude") == 0))
      {
#ifdef DEBUG
fprintf(stderr,"create(): skipping -x\n");
#endif
        i++;
        continue;
      }
      if (strcmp(argv[i],"-"))
        addfile(argv[i], i);   /* the most common case  - add file/directory */
      else
        while(fgets(tmp,sizeof(tmp),stdin)) {
          if (tmp[j=strlen(tmp)-1] == '\n')
		tmp[j] = '\0';
          addfile(tmp, 0);
        }
    }

    memset(&tarInfo, 0, (size_t) BLOCKSIZE);
    fwrite(tarInfo.buf,(size_t) 1, (size_t) BLOCKSIZE, stdout);
    fwrite(tarInfo.buf,(size_t) 1, (size_t) BLOCKSIZE, stdout); 
    for(i=0;i<numHlinks;i++) {
#ifdef DEBUG
fprintf(stderr,"freeing hrdlink[%d] at %p\n",i,hrdlink[i]);
#endif
      free(hrdlink[i]);
    }
#ifdef DEBUG
fprintf(stderr,"freeing hrdlink at %p\n",hrdlink);
#endif
    free(hrdlink);
    if(inode != NULL) free(inode);
    for(i=0;i<numXfiles;i++) {
#ifdef DEBUG
fprintf(stderr,"freeing exclude[%d] at %p\n",i,exclude[i]);
#endif
      free(exclude[i]);
    }
#ifdef DEBUG
fprintf(stderr,"freeing exclude at %p\n",exclude);
#endif
    free(exclude);
    exit(0);
}
