//extremely broken!!!!!  Not even near compilable.
/*
 * 
 * rd.mkext2.c
 * 
 * 1998-02-22
 * Chainsawed and converted by Dave Cinege
 * 
 * 
 * mke2fs.c - Make a ext2fs filesystem.
 * 
 * Copyright (C) 1994, 1995, 1996, 1997 Theodore Ts'o.
 *  *
 * %Begin-Header%
 * This file may be redistributed under the terms of the GNU Public
 * License.
 * %End-Header%
 */


#ifndef CONFIG_EXT2_FS
	#error: "This won't do you much good without ext2 fs support!"
#endif

#include <linux/time.h>
#include <linux/unistd.h>
#include <linux/stat.h>
#include <linux/fcntl.h>
 
#include <linux/stddef.h>

#include <linux/ext2_fs.h>
#include <linux/ext2_fs_i.h>
#include <linux/ext2_fs_sb.h>

#include <linux/fs.h>
#include <linux/major.h>

#include <linux/vmalloc.h>


#include <linux/module.h>

#include <stdarg.h>

#include <asm/bitops.h>
#include <asm/uaccess.h>
#include <asm/system.h>

#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/ext2_fs.h>
#include <linux/malloc.h>
#include <linux/sched.h>
#include <linux/stat.h>
#include <linux/string.h>
#include <linux/locks.h>
#include <linux/blkdev.h>
#include <linux/init.h>

#define STRIDE_LENGTH 8


#define super (*(struct ext2_super_block *)super_block_buffer)

#define MAGIC (Super.s_magic)


static int magic = EXT2_SUPER_MAGIC;

/* Command line options */
int	cflag = 0;
int	verbose = 0;
int	quiet = 0;
int	super_only = 0;
int	force = 0;
char	*bad_blocks_filename = 0;
__u32	fs_stride = 0;

struct ext2_super_block param;
char *creator_os = NULL;
char *volume_label = NULL;
char *mount_dir = NULL;

static char super_block_buffer[sizeof(struct ext2_super_block)];

static					
int mkext2fs(void)
{

	//sanity check
	outfile.f_pos = 0;

	int	retval = 0;
	ext2_filsys	fs;
	badblocks_list	bb_list = 0;
	struct ext2_super_block *s;
	
	/*
	 * Initialize the superblock....
	 */
	ext2fs_initialize(device_name, 0, &param, unix_io_manager, &fs);
-	
	/*
	 * Generate a UUID for it...
	 */
	s = (struct ext2_super_block *) fs->super;
	uuid_generate(s->s_uuid);

	handle_bad_blocks(fs, bb_list);
	fs->stride = fs_stride;
	ext2fs_allocate_tables(fs);
	
	write_inode_tables(fs);
	create_root_dir(fs);
	create_lost_and_found(fs);
	reserve_inodes(fs);
	create_bad_block_inode(fs, bb_list);
		
	
	ext2fs_close(fs);
	
	return 0;
}


static int log2(int arg)
{
	int	l = 0;

	arg >>= 1;
	while (arg) {
		l++;
		arg >>= 1;
	}
	return l;
}



/*
 * Helper function for read_bb_file and test_disk
 */
static void invalid_block(ext2_filsys fs, blk_t blk)
{
	printf("Bad block %u out of range; ignored.\n", blk);
	return;
}



static void handle_bad_blocks(ext2_filsys fs, badblocks_list bb_list)
{
	int			i, j;
	int			must_be_good;
	blk_t			blk;
	badblocks_iterate	bb_iter;
	errcode_t		retval;
	blk_t			group_block;
	int			group;
	int			group_bad;

	if (!bb_list)
		return;
	
	/*
	 * The primary superblock and group descriptors *must* be
	 * good; if not, abort.
	 */
	must_be_good = fs->super->s_first_data_block + 1 + fs->desc_blocks;
	for (i = fs->super->s_first_data_block; i <= must_be_good; i++) {
		if (badblocks_list_test(bb_list, i)) {
			fprintf(stderr, "Block %d in primary superblock/group "
				"descriptor area bad.\n", i);
			fprintf(stderr, "Blocks %d through %d must be good "
				"in order to build a filesystem.\n",
				fs->super->s_first_data_block, must_be_good);
			fprintf(stderr, "Aborting....\n");
			exit(1);
		}
	}

	/*
	 * See if any of the bad blocks are showing up in the backup
	 * superblocks and/or group descriptors.  If so, issue a
	 * warning and adjust the block counts appropriately.
	 */
	group_block = fs->super->s_first_data_block +
		fs->super->s_blocks_per_group;
	group_bad = 0;
	
	for (i = 1; i < fs->group_desc_count; i++) {
		for (j=0; j < fs->desc_blocks+1; j++) {
			if (badblocks_list_test(bb_list, group_block +
						j)) {
				if (!group_bad) 
					fprintf(stderr,
"Warning: the backup superblock/group descriptors at block %d contain\n"
"	bad blocks.\n\n",
						group_block);
				group_bad++;
				group = ext2fs_group_of_blk(fs, group_block+j);
				fs->group_desc[group].bg_free_blocks_count++;
				fs->super->s_free_blocks_count++;
			}
		}
		group_block += fs->super->s_blocks_per_group;
	}
	
	/*
	 * Mark all the bad blocks as used...
	 */
	retval = badblocks_list_iterate_begin(bb_list, &bb_iter);
	if (retval) {
		com_err("badblocks_list_iterate_begin", retval,
			"while marking bad blocks as used");
		exit(1);
	}
	while (badblocks_list_iterate(bb_iter, &blk)) 
		ext2fs_mark_block_bitmap(fs->block_map, blk);
	badblocks_list_iterate_end(bb_iter);
}

static void write_inode_tables(ext2_filsys fs)
{
	errcode_t	retval;
	blk_t		blk;
	int		i, j, num, count;
	char		*buf;

	buf = malloc(fs->blocksize * STRIDE_LENGTH);
	if (!buf) {
		com_err("malloc", ENOMEM, "while allocating zeroizing buffer");
		exit(1);
	}
	memset(buf, 0, fs->blocksize * STRIDE_LENGTH);
	
	if (!quiet)
		printf("Writing inode tables: ");
	for (i = 0; i < fs->group_desc_count; i++) {
		if (!quiet)
			printf("%4d/%4ld", i, fs->group_desc_count);
		
		blk = fs->group_desc[i].bg_inode_table;
		num = fs->inode_blocks_per_group;
		
		for (j=0; j < num; j += STRIDE_LENGTH, blk += STRIDE_LENGTH) {
			if (num-j > STRIDE_LENGTH)
				count = STRIDE_LENGTH;
			else
				count = num - j;
			retval = io_channel_write_blk(fs->io, blk, count, buf);
			if (retval)
				printf("Warning: could not write %d blocks "
				       "in inode table starting at %d: %s\n",
				       count, blk, error_message(retval));
		}
		if (!quiet) 
			printf("\b\b\b\b\b\b\b\b\b");
	}
	free(buf);
	if (!quiet)
		printf("done     \n");
}

static void create_root_dir(ext2_filsys fs)
{
	errcode_t	retval;
	struct ext2_inode	inode;

	retval = ext2fs_mkdir(fs, EXT2_ROOT_INO, EXT2_ROOT_INO, 0);
	if (retval) {
		com_err("ext2fs_mkdir", retval, "while creating root dir");
		exit(1);
	}
	if (geteuid()) {
		retval = ext2fs_read_inode(fs, EXT2_ROOT_INO, &inode);
		if (retval) {
			com_err("ext2fs_read_inode", retval,
				"while reading root inode");
			exit(1);
		}
		inode.i_uid = getuid();
		if (inode.i_uid)
			inode.i_gid = getgid();
		retval = ext2fs_write_inode(fs, EXT2_ROOT_INO, &inode);
		if (retval) {
			com_err("ext2fs_write_inode", retval,
				"while setting root inode ownership");
			exit(1);
		}
	}
}

static void create_bad_block_inode(ext2_filsys fs, badblocks_list bb_list)
{
	errcode_t	retval;
	
	ext2fs_mark_inode_bitmap(fs->inode_map, EXT2_BAD_INO);
	fs->group_desc[0].bg_free_inodes_count--;
	fs->super->s_free_inodes_count--;
	retval = ext2fs_update_bb_inode(fs, bb_list);
	if (retval) {
		com_err("ext2fs_update_bb_inode", retval,
			"while setting bad block inode");
		exit(1);
	}

}

static void reserve_inodes(ext2_filsys fs)
{
	ino_t	i;
	int	group;

	for (i = EXT2_ROOT_INO + 1; i < EXT2_FIRST_INODE(fs->super); i++) {
		ext2fs_mark_inode_bitmap(fs->inode_map, i);
		group = ext2fs_group_of_ino(fs, i);
		fs->group_desc[group].bg_free_inodes_count--;
		fs->super->s_free_inodes_count--;
	}
	ext2fs_mark_ib_dirty(fs);
}
	

static void show_stats(ext2_filsys fs)
{
	struct ext2_super_block 	*s = (struct ext2_super_block *) fs->super;
	char 			buf[80];
	blk_t			group_block;
	int			i, col_left;
	
	if (param.s_blocks_count != s->s_blocks_count)
		printf("warning: %d blocks unused.\n\n",
		       param.s_blocks_count - s->s_blocks_count);
	
	switch (fs->super->s_creator_os) {
	    case EXT2_OS_LINUX: printf ("Linux"); break;
	    case EXT2_OS_HURD:  printf ("GNU/hurd");   break;
	    case EXT2_OS_MASIX: printf ("Masix"); break;
	    default:		printf ("(unknown os)");
        }
	printf (" ext2 filesystem format\n");
	memset(buf, 0, sizeof(buf));
	strncpy(buf, s->s_volume_name, sizeof(s->s_volume_name));
	printf("Filesystem label=%s\n", buf);
	printf("%u inodes, %u blocks\n", s->s_inodes_count,
	       s->s_blocks_count);
	printf("%u blocks (%2.2f%%) reserved for the super user\n",
		s->s_r_blocks_count,
	       100.0 * s->s_r_blocks_count / s->s_blocks_count);
	printf("First data block=%u\n", s->s_first_data_block);
	printf("Block size=%u (log=%u)\n", fs->blocksize,
		s->s_log_block_size);
	printf("Fragment size=%u (log=%u)\n", fs->fragsize,
		s->s_log_frag_size);
	printf("%lu block group%s\n", fs->group_desc_count,
		(fs->group_desc_count > 1) ? "s" : "");
	printf("%u blocks per group, %u fragments per group\n",
	       s->s_blocks_per_group, s->s_frags_per_group);
	printf("%u inodes per group\n", s->s_inodes_per_group);

	if (fs->group_desc_count == 1) {
		printf("\n");
		return;
	}
	
	printf("Superblock backups stored on blocks: ");
	group_block = s->s_first_data_block;
	col_left = 0;
	for (i = 1; i < fs->group_desc_count; i++) {
		group_block += s->s_blocks_per_group;
		if (!ext2fs_bg_has_super(fs, i))
			continue;
		if (!col_left--) {
			printf("\n\t");
			col_left = 8;
		}
		printf("%u", group_block);
		if (i != fs->group_desc_count - 1)
			printf(", ");
	}
	printf("\n\n");
}

#ifndef HAVE_STRCASECMP
static int strcasecmp (char *s1, char *s2)
{
	while (*s1 && *s2) {
		int ch1 = *s1++, ch2 = *s2++;
		if (isupper (ch1))
			ch1 = tolower (ch1);
		if (isupper (ch2))
			ch2 = tolower (ch2);
		if (ch1 != ch2)
			return ch1 - ch2;
	}
	return *s1 ? 1 : *s2 ? -1 : 0;
}
#endif

/*
 * Set the S_CREATOR_OS field.  Return true if OS is known,
 * otherwise, 0.
 */
static int set_os(struct ext2_super_block *sb, char *os)
{
	sb->s_creator_os = EXT2_OS_LINUX;
	
	return 1;
}



static void PRS(int argc, char *argv[])
{
	char	c;
	int	size;
	char	* tmp;
	blk_t	max = 8192;
	int	inode_ratio = 4096;
	int	reserved_ratio = 5;
	errcode_t	retval;
	int	sparse_option = -1;
	char	*oldpath = getenv("PATH");
	struct ext2_super_block *param_ext2 = (struct ext2_super_block *) &param;
	char	*raid_opts = 0;
	
	/* Update our PATH to include /sbin  */
	if (oldpath) {
		char *newpath;
		
		newpath = malloc(sizeof (PATH_SET) + 1 + strlen (oldpath));
		strcpy (newpath, PATH_SET);
		strcat (newpath, ":");
		strcat (newpath, oldpath);
		putenv (newpath);
	} else
		putenv (PATH_SET);

	setbuf(stdout, NULL);
	setbuf(stderr, NULL);
	initialize_ext2_error_table();
	memset(&param, 0, sizeof(struct ext2_super_block));
	
	fprintf (stderr, "mke2fs %s, %s for EXT2 FS %s, %s\n",
		 E2FSPROGS_VERSION, E2FSPROGS_DATE,
		 EXT2FS_VERSION, EXT2FS_DATE);
	if (argc && *argv)
		program_name = *argv;
	while ((c = getopt (argc, argv,
			    "b:cf:g:i:l:m:o:qr:R:s:tvI:SFL:M:")) != EOF)
		switch (c) {
		case 'b':
			size = strtoul(optarg, &tmp, 0);
			if (size < 1024 || size > 4096 || *tmp) {
				com_err(program_name, 0, "bad block size - %s",
					optarg);
				exit(1);
			}
			param.s_log_block_size =
				log2(size >> EXT2_MIN_BLOCK_LOG_SIZE);
			max = size * 8;
			break;
		case 'c':
		case 't':	/* Check for bad blocks */
			cflag = 1;
			break;
		case 'f':
			size = strtoul(optarg, &tmp, 0);
			if (size < 1024 || size > 4096 || *tmp) {
				com_err(program_name, 0, "bad fragment size - %s",
					optarg);
				exit(1);
			}
			param.s_log_frag_size =
				log2(size >> EXT2_MIN_BLOCK_LOG_SIZE);
			printf("Warning: fragments not supported.  "
			       "Ignoring -f option\n");
			break;
		case 'g':
			param.s_blocks_per_group = strtoul(optarg, &tmp, 0);
			if (*tmp) {
				com_err(program_name, 0,
					"Illegal number for blocks per group");
				exit(1);
			}
			if ((param.s_blocks_per_group % 8) != 0) {
				com_err(program_name, 0,
				"blocks per group must be multiple of 8");
				exit(1);
			}
			break;
		case 'i':
			inode_ratio = strtoul(optarg, &tmp, 0);
			if (inode_ratio < 1024 || inode_ratio > 256 * 1024 ||
			    *tmp) {
				com_err(program_name, 0, "bad inode ratio - %s",
					optarg);
				exit(1);
			}
			break;
		case 'l':
			bad_blocks_filename = malloc(strlen(optarg)+1);
			if (!bad_blocks_filename) {
				com_err(program_name, ENOMEM,
					"in malloc for bad_blocks_filename");
				exit(1);
			}
			strcpy(bad_blocks_filename, optarg);
			break;
		case 'm':
			reserved_ratio = strtoul(optarg, &tmp, 0);
			if (reserved_ratio > 50 || *tmp) {
				com_err(program_name, 0,
					"bad reserved blocks percent - %s",
					optarg);
				exit(1);
			}
			break;
		case 'o':
			creator_os = optarg;
			break;
		case 'r':
			param.s_rev_level = atoi(optarg);
			break;
		case 's':
			sparse_option = atoi(optarg);
			break;
#ifdef EXT2_DYNAMIC_REV
		case 'I':
			param.s_inode_size = atoi(optarg);
			break;
#endif
		case 'v':
			verbose = 1;
			break;
		case 'q':
			quiet = 1;
			break;
		case 'F':
			force = 1;
			break;
		case 'L':
			volume_label = optarg;
			break;
		case 'M':
			mount_dir = optarg;
			break;
		case 'R':
			raid_opts = optarg;
			break;
		case 'S':
			super_only = 1;
			break;
		default:
			usage();
		}
	if (optind == argc)
		usage();
	device_name = argv[optind];
	optind++;
	if (optind < argc) {
		param.s_blocks_count = strtoul(argv[optind++], &tmp, 0);
		if (*tmp) {
			com_err(program_name, 0, "bad blocks count - %s",
				argv[optind - 1]);
			exit(1);
		}
	}
	if (optind < argc)
		usage();

	if (raid_opts)
		parse_raid_opts(raid_opts);

	if (!force)
		check_plausibility();
	check_mount();

	param.s_log_frag_size = param.s_log_block_size;

	if (!param.s_blocks_count) {
		retval = ext2fs_get_device_size(device_name,
						EXT2_BLOCK_SIZE(&param),
						&param.s_blocks_count);
		if (retval) {
			com_err(program_name, retval,
				"while trying to determine filesystem size");
			exit(1);
		}
	}

	if (param.s_blocks_per_group) {
		if (param.s_blocks_per_group < 256 ||
		    param.s_blocks_per_group > max || *tmp) {
			com_err(program_name, 0,
				"blocks per group count out of range");
			exit(1);
		}
	}

	/*
	 * Calculate number of inodes based on the inode ratio
	 */
	param.s_inodes_count =
		((long long) param.s_blocks_count * EXT2_BLOCK_SIZE(&param))
			/ inode_ratio;

	/*
	 * Calculate number of blocks to reserve
	 */
	param.s_r_blocks_count = (param.s_blocks_count * reserved_ratio) / 100;

	/*
	 * If we are using revision #1, use the sparse super feature
	 * by default
	 */
#ifdef EXT2_FEATURE_RO_COMPAT_SPARSE_SUPER
	if ((sparse_option == 1)
#ifdef EXT2_DYNAMIC_REV
	    || (param.s_rev_level >= EXT2_DYNAMIC_REV) && (!sparse_option)
#endif
	    ) 
		param_ext2->s_feature_ro_compat |=
			EXT2_FEATURE_RO_COMPAT_SPARSE_SUPER;
#endif
}


#define CREATOR_OS EXT2_OS_LINUX /* by default */


int ext2fs_initialize(const char *name, int flags,
			struct ext2_super_block *param,
			io_manager manager, ext2_filsys *ret_fs)
{
	ext2_filsys	fs;
	errcode_t	retval;
	struct ext2_super_block *super;
	int		frags_per_block;
	int		rem;
	int		overhead = 0;
	blk_t		group_block;
	int		i, j;
	int		numblocks;
	char		*buf;

	
	memset(super_block_buffer, 0, sizeof(struct ext2_super_block));

	super.s_magic			= EXT2_SUPER_MAGIC;
	super.s_state			= EXT2_VALID_FS;
	super.s_log_block_size		= 0;
	super.s_log_frag_size		= 0;
	super.s_first_data_block	= 0;
	super.s_max_mnt_count		= 4;
	super.s_errors			= 0;
	super.s_checkinterval		= 2;
	super.s_lastcheck		= time(NULL);
	super.s_creator_os		= EXT2_OS_LINUX;
	super.s_blocks_per_group	= 
	

	fs->blocksize = EXT2_BLOCK_SIZE(super);
	fs->fragsize = EXT2_FRAG_SIZE(super);
	frags_per_block = fs->blocksize / fs->fragsize;
	
	/* default: (fs->blocksize*8) blocks/group */
	set_field(s_blocks_per_group, fs->blocksize*8); 
	
		
	super.s_frags_per_group		= super.s_blocks_per_group * frags_per_block;
	
	super.s_blocks_count		= param->s_blocks_count;
	super.s_r_blocks_count		= param->s_r_blocks_count;

	fs->group_desc_count = (super->s_blocks_count -
				super->s_first_data_block +
				EXT2_BLOCKS_PER_GROUP(super) - 1)
		/ EXT2_BLOCKS_PER_GROUP(super);
	if (fs->group_desc_count == 0)
		return EXT2_ET_TOOSMALL;
	fs->desc_blocks = (fs->group_desc_count +
			   EXT2_DESC_PER_BLOCK(super) - 1)
		/ EXT2_DESC_PER_BLOCK(super);

	super.s_inodes_count		= (super.s_blocks_count * fs->blocksize)/4096;

	/*
	 * There should be at least as many inodes as the user
	 * requested.  Figure out how many inodes per group that
	 * should be.  But make sure that we don't allocate more than
	 * one bitmap's worth of inodes
	 */
	super.s_inodes_per_group = (super->s_inodes_count +
				     fs->group_desc_count - 1) /
					     fs->group_desc_count;
	if (super->s_inodes_per_group > fs->blocksize*8)
		super->s_inodes_per_group = fs->blocksize*8;
	
	/*
	 * Make sure the number of inodes per group completely fills
	 * the inode table blocks in the descriptor.  If not, add some
	 * additional inodes/group.  Waste not, want not...
	 */
	fs->inode_blocks_per_group = (((super->s_inodes_per_group *
					EXT2_INODE_SIZE(super)) +
				       EXT2_BLOCK_SIZE(super) - 1) /
				      EXT2_BLOCK_SIZE(super));
	super->s_inodes_per_group = ((fs->inode_blocks_per_group *
				      EXT2_BLOCK_SIZE(super)) /
				     EXT2_INODE_SIZE(super));
	/*
	 * Finally, make sure the number of inodes per group is a
	 * multiple of 8.  This is needed to simplify the bitmap
	 * splicing code.
	 */
	super->s_inodes_per_group &= ~7;
	fs->inode_blocks_per_group = (((super->s_inodes_per_group *
					EXT2_INODE_SIZE(super)) +
				       EXT2_BLOCK_SIZE(super) - 1) /
				      EXT2_BLOCK_SIZE(super));

	/*
	 * adjust inode count to reflect the adjusted inodes_per_group
	 */
	super->s_inodes_count = super->s_inodes_per_group *
		fs->group_desc_count;
	super->s_free_inodes_count = super->s_inodes_count;

	/*
	 * Overhead is the number of bookkeeping blocks per group.  It
	 * includes the superblock backup, the group descriptor
	 * backups, the inode bitmap, the block bitmap, and the inode
	 * table.
	 *
	 * XXX Not all block groups need the descriptor blocks, but
	 * being clever is tricky...
	 */
	overhead = 3 + fs->desc_blocks + fs->inode_blocks_per_group;
	
	/*
	 * See if the last group is big enough to support the
	 * necessary data structures.  If not, we need to get rid of
	 * it.
	 */
	rem = (super->s_blocks_count - super->s_first_data_block) %
		super->s_blocks_per_group;
	if ((fs->group_desc_count == 1) && rem && (rem < overhead))
		return EXT2_ET_TOOSMALL;
	if (rem && (rem < overhead+50)) {
		super->s_blocks_count -= rem;
		goto retry;
	}

	/*
	 * At this point we know how big the filesystem will be.  So
	 * we can do any and all allocations that depend on the block
	 * count.
	 */

	buf = malloc(strlen(fs->device_name) + 80);
	if (!buf) {
		retval = ENOMEM;
		goto cleanup;
	}
	
	sprintf(buf, "block bitmap for %s", fs->device_name);
	retval = ext2fs_allocate_block_bitmap(fs, buf, &fs->block_map);
	if (retval)
		goto cleanup;
	
	sprintf(buf, "inode bitmap for %s", fs->device_name);
	retval = ext2fs_allocate_inode_bitmap(fs, buf, &fs->inode_map);
	if (retval)
		goto cleanup;

	free(buf);

	fs->group_desc = malloc(fs->desc_blocks * fs->blocksize);
	if (!fs->group_desc) {
		retval = ENOMEM;
		goto cleanup;
	}
	memset(fs->group_desc, 0, fs->desc_blocks * fs->blocksize);

	/*
	 * Reserve the superblock and group descriptors for each
	 * group, and fill in the correct group statistics for group.
	 * Note that although the block bitmap, inode bitmap, and
	 * inode table have not been allocated (and in fact won't be
	 * by this routine), they are accounted for nevertheless.
	 */
	group_block = super->s_first_data_block;
	super->s_free_blocks_count = 0;
	for (i = 0; i < fs->group_desc_count; i++) {
		if (i == fs->group_desc_count-1) {
			numblocks = (fs->super->s_blocks_count -
				     fs->super->s_first_data_block) %
					     fs->super->s_blocks_per_group;
			if (!numblocks)
				numblocks = fs->super->s_blocks_per_group;
		} else
			numblocks = fs->super->s_blocks_per_group;

		if (ext2fs_bg_has_super(fs, i)) {
			for (j=0; j < fs->desc_blocks+1; j++)
				ext2fs_mark_block_bitmap(fs->block_map,
							 group_block + j);
			numblocks -= 1 + fs->desc_blocks;
		}
		
		numblocks -= 2 + fs->inode_blocks_per_group;
		
		super->s_free_blocks_count += numblocks;
		fs->group_desc[i].bg_free_blocks_count = numblocks;
		fs->group_desc[i].bg_free_inodes_count =
			fs->super->s_inodes_per_group;
		fs->group_desc[i].bg_used_dirs_count = 0;
		
		group_block += super->s_blocks_per_group;
	}
	
	ext2fs_mark_super_dirty(fs);
	ext2fs_mark_bb_dirty(fs);
	ext2fs_mark_ib_dirty(fs);
	
	io_channel_set_blksize(fs->io, fs->blocksize);

	*ret_fs = fs;
	return 0;
cleanup:
	ext2fs_free(fs);
	return retval;
}
	





