#
# bootmisc.sh	Miscellaneous things to be done during bootup.
#
# Version:	@(#)bootmisc.sh  1.20  09-Jan-1999  miquels@cistron.nl
#

RCDLINKS="S,S55"


. /etc/default/rcS
#
# Put a nologin file in /etc to prevent people from logging in before
# system startup is complete.
#
if [ "$DELAYLOGIN" = yes ]
then
  echo "System bootup in progress - please wait" >/etc/nologin
  cp /etc/nologin "/etc/nologin.boot"
fi

#
# Wipe /tmp (and don't erase `lost+found', `quota.user' or `quota.group')!
# Note that files _in_ lost+found _are_ deleted.
#
[ "$VERBOSE" != no ] && echo -n "Cleaning: /tmp "
for f in /tmp/*; do
	case $f in *lost+found|*quota*) continue ;; esac
	rm -r $f >/dev/null 2>&1
done
rm -r /tmp/.X*-lock >/dev/null 2>&1


#
# Clean up any stale locks.
#
[ "$VERBOSE" != no ] && echo -n "/var/lock "
for f in /var/lock/*; do
	case $f in *lost+found|*quota*) continue ;; esac
	rm -r $f >/dev/null 2>&1
done

#
# Clean up /var/run and create /var/run/utmp so that we can login.
#
[ "$VERBOSE" != no ] && echo -n "/var/run"
for f in /var/run/*; do
	case $f in *lost+found|*quota*|*utmp|*random-seed) continue ;; esac
	rm -r $f >/dev/null 2>&1
done
: > /var/run/utmp
[ "$VERBOSE" != no ] && echo "."

#
# Set pseudo-terminal access permissions.
#
chmod 666 /dev/tty[p-za-e][0-9a-f]
chown root:tty /dev/tty[p-za-e][0-9a-f]

#
# Update /etc/motd.
#
if [ "$EDITMOTD" != no ]
then
	uname -a > /etc/motd.tmp
	sed 1d /etc/motd >> /etc/motd.tmp
	mv /etc/motd.tmp /etc/motd
	
	lrpv="Linux Router `cat /etc/lrp_version`"
	
	cat /etc/lrp_logo.ansi >/etc/issue
	echo "$lrpv \n \l" >>/etc/issue
	
	cat /etc/lrp_logo.ansi >/etc/issue.net
	echo "$lrpv %h" >>/etc/issue.net
fi

