#ifndef _LINUX_WAIT_H
#define _LINUX_WAIT_H

#define WNOHANG		0x00000001
#define WUNTRACED	0x00000002

#define __WCLONE	0x80000000

struct wait_queue {
	struct task_struct * task;
	struct wait_queue * next;
};

typedef struct select_table_struct {
	int nr;
	struct select_table_entry {
		struct wait_queue wait;
		struct wait_queue ** wait_address;
	} * entry;
} select_table;

#define __MAX_SELECT_TABLE_ENTRIES (4096 / sizeof (struct select_table_entry))

#endif
