/*
-- ----------------------------------------------------------------------------
--
--  Object name : kernel.c
--  Revision    : 1.0
--
--  Copyright (c) Inmos Ltd, 1987.
--  All Rights Reserved.
--
--  DESCRIPTION
--    TDS Server  Kernel Channel Driver
--
--  NOTES
--
--  HISTORY
--     ibm-pc   11-Jul-88  CREATION.
--     ibm-pc   23-Feb-88  RJO - Changed all WordTo/From Link (ChannelNos)
--              to ByteTo/From
--     ibm-pc   24-Feb-88  RJO - Improved the K_SUSPEND_TDS command to use the
--              COMSPEC variable.The K_ABORT stuff is implemented.
-- ----------------------------------------------------------------------------
*/
#include <stdio.h>
#include <linux/types.h>
#include <linux/termios.h>
#include "inmos.h"
#include "srvconst.h"
#define KERNEL_MEM_SIZE 4096

/*
-- ----------------------------------------------------------------------------
-- Kernel Static Variables.
-- ----------------------------------------------------------------------------
*/

long int KernelData [KERNEL_DATA_ITEMS];
long int KernelMem [KERNEL_MEM_SIZE];
/*
-- ----------------------------------------------------------------------------
-- External Variables And Procs.
-- ----------------------------------------------------------------------------
*/

extern int errno;
extern BYTE Tcom[];                    /* In server.c          */
extern int TcomInPtr, TcomOutPtr;      /* In server.c          */
extern BOOL AbortFlag;                 /* In itermp.c          */
extern struct termios OrgMode, CurMode;

long PeekWord();                       /* In linkio.c          */
long LongWordFromLink();               /* In linkio.c          */

/*
-- ----------------------------------------------------------------------------
-- void PeekBaseMemory
--
-- Input Parameters:
--  None.
-- Output Parameters:
--  None.
-- ----------------------------------------------------------------------------
*/
void PeekBaseMemory ()
{
  int i;
  for (i = 0; i < KERNEL_MEM_SIZE; i++)
    KernelMem[i] = PeekWord(i);
}
/*
-- ----------------------------------------------------------------------------
-- void DoKernelChan - Interpret a message on the kernel channel.
--
-- Input Parameters:
--  None.
-- Output Parameters:
--  None.
-- ----------------------------------------------------------------------------
*/
void DoKernelChan ()
{
  int Command;
  Command = WordFromLink();

  switch (Command)
    {
      case K_TERMINATE_SERVER:
        TerminateServer (T_OK);
        break;
      case K_STORE_ITEM:
        {
          int Posn = WordFromLink ();
          KernelData[Posn] = LongWordFromLink();
          break;
        };
      case K_RETRIEVE_ITEM:
        {
          int Posn = WordFromLink ();
          ByteToLink (FROM_KERNEL_CHAN);
          LongWordToLink (KernelData[Posn]);
          break;
        };
      case K_RETRIEVE_MEM:
        {
          int Posn = WordFromLink ();
          ByteToLink (FROM_KERNEL_CHAN);
          LongWordToLink (KernelMem[Posn]);
          break;
        };
      case K_GET_CHAR:
        {
          BYTE c;

          if (TcomOutPtr < TcomInPtr)
            c = Tcom[TcomOutPtr++];
          else
            c = 0;
          ByteToLink (FROM_KERNEL_CHAN);
          WordToLink (c);
          break;
        };
      case K_SUSPEND_TDS:
        {
          int Result;
          int Status;
	  printf( "Suspending TDS\n" );

	  ioctl(0, TCSETS, &OrgMode );

          Status = system ( getenv( "SHELL" ) );

          if (Status)
            Result = K_SUSPEND_FAILED;
          else
            Result = K_OK;

          ByteToLink (FROM_KERNEL_CHAN);
          LongWordToLink((long)Result);
          break;
        }
      case K_GET_ABORT_STATE:
        {
          int Result;

          if (AbortFlag)
            Result = K_ABORT_SET;
          else
            Result = K_ABORT_UNSET;
          ByteToLink (FROM_KERNEL_CHAN);
          WordToLink (Result);
          AbortFlag = FALSE;                    /* reset the flag for the next go */
          break;
        }
      case K_GET_RESULT:
      case K_GET_IPTR:
      case K_GET_VAL:
      case K_GET_LAST_ERROR:
      case K_CLEAR_RESULT:
      case K_CLEAR_LAST_ERROR:
      default:              ;
    };
}
