/*
-- ----------------------------------------------------------------------------
--
--  Object name : filcoms.h
--  Revision    : 1.0
--
--  Copyright (c) Inmos Ltd, 1987.
--  All Rights Reserved.
--
--  DESCRIPTION
--    TDS Server  Filer Command Tags
--
--  NOTES
--
--  HISTORY
--     ibm-pc  3-Apr-86  CREATION.
--     ibm-pc 16-Feb-88  RJO - Added new tkf,fkf tag values for TDS3.
--     ibm-pc 23-Feb-88  RJO - TKF,FKF Values 58-61 added as new tags.
-- ----------------------------------------------------------------------------
*/
/*
-- ----------------------------------------------------------------------------
-- To kernel filer command tags.
-- ----------------------------------------------------------------------------
*/

#define TKF_LOCK_READ          1
#define TKF_LOCK_WRITE         2
#define TKF_RELEASE            3
#define TKF_OPEN_READ          4
#define TKF_OPEN_WRITE         5
#define TKF_CLOSE              6
#define TKF_READ               7
#define TKF_WRITE              8
#define TKF_SUSPEND            9
#define TKF_RESUME            10
#define TKF_NAMED_FILE_STORE  11
#define TKF_ASCII_TO_ID       12
#define TKF_ID_TO_ASCII       13
#define TKF_DERIVE_ID         14
#define TKF_CREATE_FILE       15
#define TKF_GET_VERSION       16
#define TKF_MOVE_FILE_ID      17
#define TKF_CAN_MOVE          18
#define TKF_CAN_DELETE        19
#define TKF_CAN_COPY          20
#define TKF_MOVE_FILE         21
#define TKF_DELETE_FILE       22
#define TKF_COPY_FILE         23
#define TKF_EXISTS_FILE       24
#define TKF_NUMBER_OF_CHRC    25
#define TKF_CHRC_CAN_CHANGE   26
#define TKF_CHRC_NAME         27
#define TKF_OPEN_READ_CHRC    28
#define TKF_OPEN_WRITE_CHRC   29
#define TKF_READ_CHRC         30
#define TKF_WRITE_CHRC        31
#define TKF_CLOSE_CHRC        32
#define TKF_GET_ERROR         33
#define TKF_TERMINATE         34
#define TKF_FORMAT            35
#define TKF_ZERO              36
#define TKF_SEEK              37
#define TKF_FREE_SPACE        38
#define TKF_OPEN_READ_TEXT    39
#define TKF_OPEN_WRITE_TEXT   40
#define TKF_RESET_CHANNEL     41
#define TKF_FILE_LENGTH       42
#define TKF_TRUNCATE          43 /* Not used */
#define TKF_RENAME            44
#define TKF_FLUSH             45
#define TKF_OPEN_BLOCK_READ   50
#define TKF_OPEN_BLOCK_WRITE  51
#define TKF_OPEN_BLOCK_UPDATE 52

#define TKF_OPEN_VAR_REC_READ     53
#define TKF_OPEN_VAR_REC_WRITE    54
#define TKF_OPEN_VAR_REC_UPDATE   55
#define TKF_OPEN_FIXED_REC_READ   56
#define TKF_OPEN_FIXED_REC_WRITE  57
#define FKF_OPEN_FIXED_REC_UPDATE 58
#define TKF_TOOLKIT_FILE_ID       59
#define TKF_DELETE_FILE_ID        60
#define TKF_PICK_FILE_ID          61

#define TKF_MAX_COMMAND           61
/*
-- ----------------------------------------------------------------------------
-- From kernel filer command tags.
-- ----------------------------------------------------------------------------
*/

#define FKF_LOCK_READ              1
#define FKF_LOCK_WRITE             2
#define FKF_RELEASE                3
#define FKF_OPEN_READ              4
#define FKF_OPEN_WRITE             5
#define FKF_CLOSE                  6
#define FKF_READ                   7
#define FKF_WRITE                  8
#define FKF_SUSPEND                9
#define FKF_RESUME                10
#define FKF_NAMED_FILE_STORE      11
#define FKF_ASCII_TO_ID           12
#define FKF_ID_TO_ASCII           13
#define FKF_DERIVE_ID             14
#define FKF_CREATE_FILE           15
#define FKF_GET_VERSION           16
#define FKF_MOVE_FILE_ID          17
#define FKF_CAN_MOVE              18
#define FKF_CAN_DELETE            19
#define FKF_CAN_COPY              20
#define FKF_MOVE_FILE             21
#define FKF_DELETE_FILE           22
#define FKF_COPY_FILE             23
#define FKF_EXISTS_FILE           24
#define FKF_NUMBER_OF_CHRC        25
#define FKF_CHRC_CAN_CHANGE       26
#define FKF_CHRC_NAME             27
#define FKF_OPEN_READ_CHRC        28
#define FKF_OPEN_WRITE_CHRC       29
#define FKF_READ_CHRC             30
#define FKF_WRITE_CHRC            31
#define FKF_CLOSE_CHRC            32
#define FKF_GET_ERROR             33
#define FKF_TERMINATE             34
#define FKF_FORMAT                35
#define FKF_ZERO                  36
#define FKF_SEEK                  37
#define FKF_FREE_SPACE            38
#define FKF_OPEN_READ_TEXT        39
#define FKF_OPEN_WRITE_TEXT       40
#define FKF_RESET_CHANNEL         41
#define FKF_FILE_LENGTH           42
#define FKF_TRUNCATE              43   /* Not used */
#define FKF_RENAME                44
#define FKF_FLUSH                 45
#define FKF_OPEN_BLOCK_READ       50
#define FKF_OPEN_BLOCK_WRITE      51
#define FKF_OPEN_BLOCK_UPDATE     52

#define FKF_OPEN_VAR_REC_READ     53
#define FKF_OPEN_VAR_REC_WRITE    54
#define FKF_OPEN_VAR_REC_UPDATE   55
#define FKF_OPEN_FIXED_REC_READ   56
#define FKF_OPEN_FIXED_REC_WRITE  57
#define FKF_OPEN_FIXED_REC_UPDATE 58
#define FKF_TOOLKIT_FILE_ID       59
#define FKF_DELETE_FILE_ID        60
#define FKF_PICK_FILE_ID          61
#define FKF_MAX_COMMAND           61

/*
--
--     End of File.
--
*/
