/*
-- ----------------------------------------------------------------------------
--
--     Object Name : afserver.h
--     Revision    : 1
--
--     Copyright INMOS Limited, 1987, 1988.
--     All Rights Reserved.
--
--     DESCRIPTION
--         Afserver portable global constant definitions.
--
--     NOTES
--         None.
--
--     HISTORY
--         25-Feb-1988    Antony King    Last change.
--         12-Apr-1988    Antony King    Added this comment.
--
-- ----------------------------------------------------------------------------
*/

/* Useful constants */

#define TRUE 1
#define FALSE 0

#define BIT_0 1

/* Terminate codes */

#define T_TERMINATED       0
#define T_BAD_BOOT         9
#define T_BAD_COMMAND      15
#define T_BAD_COMMAND_LINE 16
#define T_BAD_RECORD       17
#define T_BAD_INT32        18
#define T_BAD_HOST_INIT    19
#define T_BAD_LINUX	   20

/* Filer constants */

#define N_STREAMS    20
#define PARAM_STREAM N_STREAMS + 1

#define INVALID_STREAM -1

#define DEBUG_FILE "afserver.log"

#define S_INPUT  1
#define S_OUTPUT 2

#define PERMANENT 0
#define TEMPORARY 1
#define SPECIAL   2

#define HOST_ERROR_BASE -400

#define END(i) ((((++i)%8)==0) ? '\n' : ' ')

/* Protocol tags */

#define INT32_VALUE      4
#define NILRECORD_VALUE  8
#define RECORD32_VALUE  12

/* Commands */

#define ALIENTERMINATE_CMD 0
#define OPENFILE_CMD 1
#define OPENTEMP_CMD 2
#define OPENINPUTSTREAM_CMD 3
#define OPENOUTPUTSTREAM_CMD 4
#define STREAMACCESS_CMD 5
#define STREAMSTATUS_CMD 6
#define STREAMFILE_CMD 7
#define STREAMLENGTH_CMD 8
#define CLOSESTREAM_CMD 11
#define READBLOCK_CMD 12
#define WRITEBLOCK_CMD 13
#define SEEK_CMD 14
#define STREAMCONNECT_CMD 23
#define TERMINATE_CMD 24
#define SETRESULT_CMD 25
#define RUNCOMMAND_CMD 26
#define RENAMEFILE_CMD 27
#define READTIME_CMD 28
#define READKEY_CMD 29
#define RECEIVEBLOCK_CMD 30
#define SENDBLOCK_CMD 31
#define CALLINTERRUPT_CMD 32
#define READREGS_CMD 33
#define RUNTIMEDATA_CMD 34
#define READENVIRONMENT_CMD 35
#define PORTREAD_CMD 36
#define PORTWRITE_CMD 37
#define READKEYWAIT_CMD 38
#define READCOREDUMP_CMD 39
#define SERVERVERSION_CMD 40

/* Access methods */

#define BINARYBYTESTREAM_ACCESS 0
#define TEXTBYTESTREAM_ACCESS 1

#define MAX_ACCESS_METHOD 1

/* Open modes */

#define READ_MODE 0
#define WRITE_MODE 1
#define UPDATE_MODE 2

#define MAX_OPEN_MODE 2

/* Exist modes */

#define OLD_FILE 0
#define NEW_FILE 1

#define MAX_EXIST_MODE 1

/* Connections */

#define SCREEN_USE 0
#define KEYBOARD_USE 1
#define FILE_USE 2
#define TEMP_USE 3
#define PARAMETER_USE 4

/* Close options */

#define CLOSE_OPTION 0
#define CLOSEDEL_OPTION 1

#define MAX_CLOSE_OPTION 1

/* Return codes */

#define OPERATION_OK 0
#define ENDOFFILE 1

#define INVALIDFILENAMELENGTH_ERR 2
#define INVALIDACCESSMETHOD_ERR 3
#define INVALIDOPENMODE_ERR 4
#define INVALIDEXISTMODE_ERR 5
#define INVALIDRECORDLENGTH_ERR 6
#define INVALIDSTDSTREAM_ERR 7
#define INVALIDSTREAMID_ERR 8
#define INVALIDCLOSEOPTION_ERR 9
#define NOSEEKPOSSIBLE_ERR 10
#define INVALIDRECORDNUMBER_ERR 11

#define OPERATIONFAILED_ERR 99
#define NOFREECHANNEL_ERR 100
#define NOSUCHFILE_ERR 101
#define FILEALREADYOPEN_ERR 102
#define READOPENFAIL_ERR 103
#define NOTIMPLEMENTED_ERR 104
#define INVALIDSEEKOFFSET_ERR 105
#define INVALIDCOREOFFSET_ERR 106
#define INVALIDDATAOPTION_ERR 107

/* Booted code states */

#define STATE_MASK    0x000000ffl

#define NOBOOT_STATE  0x00000000l
#define RESET_STATE   0x00000001l
#define NORESET_STATE 0x00000002l
#define ANALYSE_STATE 0x00000003l

/* Boot error codes */

#define BOOT_FILE_OK           0
#define BOOT_FILE_OPEN_ERR     1
#define BOOT_FILE_READ_ERR     2
#define BOOT_FILE_SEND_ERR     3
#define BOOT_FILE_CLOSE_ERR    4
#define BOOT_FILE_PROTOCOL_ERR 5
#define BOOT_FILE_TARGET_ERR   6
#define BOOT_FILE_VERSION_ERR  7
#define BOOT_FILE_SCALER_ERR   8
#define BOOT_FILE_VECTOR_ERR   9
#define BOOT_FILE_CODE_ERR    10
#define DEBUG_FILE_OPEN_ERR   11
#define DEBUG_FILE_CLOSE_ERR  12

/* Replies from ROM loader */

#define ACK '0'
#define NAK '3'

/* Wake up sequence for ROM loader */

#define TRIGGER '?'
#define HEX_MODE 'H'
#define BINARY_MODE 'B'
#define LOAD_MODE 'L'
#define ANALYSE_MODE 'A'

/* Operator and operand positions within a command byte */

#define TAG_FIELD       0xC0
#define TAG_FIELD_BITS  2
#define DATA_FIELD      0x3F
#define DATA_FIELD_BITS 6

/* Operator part of command for ROM loader */

#define MESSAGE  0
#define NUMBER   1
#define FUNCTION 2
#define PREFIX   3

/* Operand part of operator FUNCTION */

#define LOAD      0
#define PASS      1
#define OPEN      2
#define CLOSE     3
#define ADDRESS   4
#define TERMINATE 5
#define INFO      6
#define FAIL      7

/* Maximum size of code block to be sent */

#define MESS_SIZE 60

/* Maximum number of 6 bit prefixes possible for a 32 bit integer */

#define PREFIX_SIZE 6

/* ROM loader commands */

#define PREFIX_OPR(val) ((PREFIX << DATA_FIELD_BITS) | val)
#define NUMBER_OPR(val) ((NUMBER << DATA_FIELD_BITS) | val)
#define MESS_OPR(size) ((MESSAGE << DATA_FIELD_BITS) | size)

#define LOAD_OPR ((FUNCTION << DATA_FIELD_BITS) | LOAD)
#define OPEN_OPR ((FUNCTION << DATA_FIELD_BITS) | OPEN)
#define PASS_OPR ((FUNCTION << DATA_FIELD_BITS) | PASS)
#define CLOSE_OPR ((FUNCTION << DATA_FIELD_BITS) | CLOSE)
#define ADDRESS_OPR ((FUNCTION << DATA_FIELD_BITS) | ADDRESS)
#define TERMINATE_OPR ((FUNCTION << DATA_FIELD_BITS) | TERMINATE)

/* Buffer and base sizes - note, 4 bytes per integer */

#define INT_LEN             4
#define VECTOR_VERSION      10

#define NO_SEG_REGS         4
#define NO_PROCESS_REGS     10

#define RECORD_LENGTH       512
#define MAX_STRING_SIZE     256
#define CORE_MEMORY_SIZE    4096 * INT_LEN
#define FILE_NAME_LENGTH    128
#define BOOT_BUFFER_LENGTH  2048
#define COMMAND_LINE_LENGTH RECORD_LENGTH

/* Processor targets */

#define T2_TARGET 2
#define T4_TARGET 4
#define T8_TARGET 8

/* Word lengths for different targets */

#define T2_INT_LEN 2
#define T4_INT_LEN 4
#define T8_INT_LEN 4

/* Work space base address offset for the different targets*/

#define T2_BASE_MEM_ADDR 0x24
#define T4_BASE_MEM_ADDR 0x48
#define T8_BASE_MEM_ADDR 0x70

/* Address offsets that ROM loader can load at for the different targets */

#define T2_BASE_CODE_ADDR 0x1D0
#define T4_BASE_CODE_ADDR 0x230
#define T8_BASE_CODE_ADDR 0x230

/* Transputer peek and poke constants */

#define MOSTNEG_INT 0x80000000l

#define T_POKE 0
#define T_PEEK 1

/* Stream data structure definition */

struct STREAM_DESC
{
    int inuse;
    FILE *fileptr;
    int open_m;
    int exist_m;
    int access_m;
    int lifetime_m;
    int result;
    char name[FILE_NAME_LENGTH + 1];
};
