#ifndef _SMBPRIV_H_
#define _SMBPRIV_H_

#include "smblib.h"
#include "smbconst.h"

/* the basic packet size, assuming no words or bytes */
#define smb_size 39
#define smb_bcc(buf) (WVAL(buf, smb_vwv + BVAL(buf,smb_wct)*sizeof(WORD)))

/* this is how errors are generated */
#define ERROR(class,x) error_packet(inbuf,outbuf,class,x,__LINE__)

/* Internal prototypes */
static struct smb_conn *
new_conn(int bufsize);
static char *
setup_smb(struct smb_conn *conn, int command, int wct, int bcc);
static Bool
smb_is_valid_buf(const char *buf);
static Bool
smb_valid_answer(const char *buf, int cmd, int wct, int bcc);
static Bool
smb_request(struct smb_conn *conn);
static char *
smb_buf(const char *b);
static Bool
send_smb(struct smb_conn *conn);
static Bool
receive_smb(struct smb_conn *conn, int timeout);
static int
name_mangle(const char *In,char *Out);
static Status
read_data(int fd, char *buffer, size_t count);
static Status
receive_1002(int fd, char *buf, int bufsize, int timeout);
static void
smb_setlen(char *buf, int len);

static const char *
dos_base_name(const char *filename);


static void
fill_finfo(const char *p, struct smb_finfo *finfo);
static time_t
make_unix_time(unsigned char *time);
/*
static DWORD
unix2smb_time(time_t time);
*/

static unsigned int
smb_len(const char *buf);

#ifndef NeedSwap

#define BVAL(p,off)      (*((BYTE  *)(((void *)p)+off)))
#define WVAL(p,off)      (*((WORD  *)(((void *)p)+off)))
#define DVAL(p,off)      (*((DWORD *)(((void *)p)+off)))

#if DEBUG > 0

#define BSET(p,off,new) \
 ({Assert( (0xff & (new)) == (new) ); \
   (*((BYTE  *)(((void *)p)+off))=(new));})

#define WSET(p,off,new) \
 ({Assert( (0xffff & (new)) == (new) ); \
   (*((WORD  *)(((void *)p)+off))=(new));})

#define DSET(p,off,new)  (*((DWORD *)(((void *)p)+off))=(new))

#else /* DEBUG > 0 */

#define BSET(p,off,new)  (*((BYTE  *)(((void *)p)+off))=(new))
#define WSET(p,off,new)  (*((WORD  *)(((void *)p)+off))=(new))
#define DSET(p,off,new)  (*((DWORD *)(((void *)p)+off))=(new))

#endif /* DEBUG > 0 */

#else /* NeedSwap */
BYTE  BVAL(char *p, int off);
WORD  WVAL(char *p, int off);
DWORD DVAL(char *p, int off);
void  BSET(char *p, int off, BYTE new);
void  WSET(char *p, int off, WORD new);
void  DSET(char *p, int off, DWORD new);
#endif /* NeedSwap */

#endif /* _SMBPRIV_H_ */
