/* C output formatting */
#include "com.h"
#include "format.h"
#include <stdarg.h>

static int lvl;
static int lastnl = 0;
static int col;

FILE *form_out = stdout;

static void out_ch(char ch)
{
	if (ch == '\n')
	{
		fputc(ch, form_out);
		col = 0;
		lastnl = 1;
		return;
	}
	
	if (lastnl && ch != '#')
	{
		int cnt;

		col += lvl * 4;
		for(cnt = 0; cnt < lvl; cnt++)
			fputs("    ", form_out);
	}
	lastnl = 0;

	col++;
	fputc(ch, form_out);

#if 0
	if (col >= 65 && (ch == ';' || ch == ','))
		out_ch('\n');
#endif
}

static void out_str(const char *str)
{
	for(; *str; str++)
		out_ch(*str);
}

static void out_num(int n)
{
	char buf[20];

	sprintf(buf, "%d", n);
	out_str(buf);
}

void format(const char *str, ...)
{
	va_list va;

	va_start(va, str);

	for(; *str; str++)
	{
		switch(*str)
		{
		case '(':
		case '{':	out_ch(*str); lvl++; break;

		case ')':
		case '}':	lvl--; out_ch(*str); break;

		case '%':
			switch(*++str)
			{
			case 's':	out_str(va_arg(va, char *)); break;
			case 'd':	out_num(va_arg(va, int)); break;
			default:
				out_ch('%');
				out_ch(*str);
				break;
			}
			break;

		default:
			out_ch(*str);
		}
	}
}
