/*
 *	$Id: msndio.h,v 2.0 1994/11/13 03:59:12 mummert Exp mummert $
 *
 *	sys/msnd.h
 *	==========
 *
 *	ioctl-commands and arguments
 *	for MultiSound device driver
 *
 *	Copyright (c) 1994 by Markus Mummert
 *
 *	Redistribution and use of this software, modifcation and inclusion
 *	into other forms of software are permitted provided that the following
 *	conditions are met:
 *
 *	1. Redistributions of this software must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. If this software is redistributed in a modified condition
 *	   it must reveal clearly that it has been modified.
 *	
 *	THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 *	AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 *	TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 *	PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR
 *	CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 *	EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 *	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *	PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 *	OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *	(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *	USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 *	DAMAGE.
 */

#ifndef __sys_msndio_h__
#define __sys_msndio_h__

#define MIOC		('m' << 8) 		/* ioctl() cmds set on	*/
						/* numerical base MIOC	*/
/*
 *	cmds, use following syntax 
 *	- to set parameter:  int ioctl(int fd, int cmd, int arg)
 *	- to read parameter: int ioctl(int fd, int cmd, int *argp)
 */
						/*   set parameter cmds	*/
#define M_REINIT	(MIOC|0)		/*     reinitialize	*/
#define M_SETRATE 	(MIOC|1)		/*     sampling rate	*/
#define M_SETMODE       (MIOC|2)  		/*     mono or stereo	*/
#define	M_SETSMPFMT     (MIOC|3)  		/*     sample format	*/
#define	M_SETINPTVAL    (MIOC|4)  		/*     input pot value	*/
#define M_SETAUXPTVAL   (MIOC|5) 		/*     aux pot value	*/
#define M_SETRECBYTES 	(MIOC|6) 		/*     bytes to record	*/
#define M_SETPLAYBYTES 	(MIOC|7) 		/*     bytes to play	*/
#define M_SETMONITOR 	(MIOC|8) 		/*     monitor status	*/
						/*   read parameter cmd	*/
#define M_GETRATE       (MIOC|11) 		/*     (as above) 	*/
#define M_GETMODE       (MIOC|12) 
#define	M_GETSMPFMT     (MIOC|13)
#define	M_GETINPTVAL    (MIOC|14)
#define M_GETAUXPTVAL   (MIOC|15)
#define M_GETRECBYTES 	(MIOC|16)
#define M_GETPLAYBYTES 	(MIOC|17)
#define M_GETMONITOR 	(MIOC|18) 

/*
 *	args to be passed or retrieved
 */
						/* M_xxxRATE arg vals:	*/
#define M_CLKDIV1       (MIOC|0) 		/*   max. samp. freq.	*/
#define M_CLKDIV2       (MIOC|1)  		/*     devide by 2	*/
#define M_CLKDIV4       (MIOC|2)		/*     devide by 4	*/
						/* M_xxxMODE arg vals:	*/
#define M_STEREO        (MIOC|4)	       	/*     (...)		*/
#define M_MONO          (MIOC|5)       
						/* M_xxxSMPFMT arg vals:*/
#define M_NOSWAP        (MIOC|6)          	/*   80x86 style	*/
#define M_SWAP          (MIOC|7)		/*   MC680x0 style	*/

						/* M_xxx(IN/AUX)PTVAL	*/
						/*   is any unsigned	*/
						/*   number < 0x10000,	*/
						/*   highbyte is left,	*/
						/*   lowbyte right pot	*/
	
						/* M_xxx(REC/PLAY)BLKS  */
#define M_NOLIMIT	0               	/*   or any number	*/
   
						/* M_xxxMONITOR arg val	*/
#define M_AUTO		(MIOC|8)		/*   input to output	*/
#define M_SILENT	(MIOC|9)		/*   or silent, when	*/
						/*   not playing	*/

#endif /* __sys_msndio_h__ */

/*
 *	EOT
 */
