/*
 *
 *	$Id: kiflinux.c,v 2.1.0.1 1995/04/11 14:46:40 mummert Exp mummert $
 *
 *	kiflinux.c
 *	==========
 *
 *	EXPERIMENTAL Driver-Kernel-Interface to Linux for MultiSound
 *	SysV386 character driver. REPLACES offical sound driver
 *	`VoxWare' by Hannu Savolainen <hannu%voxware.pp.fi>
 *
 *	Author: Markus Mummert <mum@mmk.e-technik.tu-muenchen.de>
 *	Some text/code picked from VoxWare 
 *	Points of interest: ->FIXME:
 *
 *	Don't define NEW_LINUX_KERNEL on 1.0.x Linux (checked with x=9)
 *	or if cc complains about too many args in request_irq call.
 *	(see Makefile)
 *
 *
 *	Relation to VoxWare
 *	-------------------
 *	As we have (ab)used the Driver-Installation-Interface
 *	from VoxWare already (see Makefile) we also take it's
 *	Driver-Kernel-Interface which is hooked into Linux's
 *	kernel code. VoxWare implements also Driver-Subdriver-
 *	Interface that allows many subdrivers for different
 *	soundcards and different features (synth, midi, etc.)
 *	to coexist in a single piece of code. We just
 *	bypass this facility by jumping directly from the Linux
 *	driver entry points to the corresponding procedures
 *	of the original Generic SysV386 MultiSound driver.
 *	It's compilation has been affected by extensive use
 *	of the preprocessor via `osdep.h' though.
 *	Oh and yes, we also take VoxWare's major number (the
 *	index to our driver table entry), but not via #include
 *	<linux/major.h> but via cc-flags via make to be more flexible ..
 *
 *	To be come independet of the Driver-Kernel-Interface
 *	of VoxWare we'd have to get our own major number AND
 *	to define our own hooks msnd_init(), msnd_setup() 
 *	(maybe msnd_mem_init()) (s.b.).
 *
 */

#include <linux/autoconf.h>
#ifdef CONFIG_SOUND
# if (CONFIG_SOUND)
#   define CONFIGURE_SOUNDCARD
# endif
#endif
#ifdef CONFIGURE_SOUNDCARD

#include "osdep.h"
/* 
 * We dont use #include <linux/major.h> beause we have MSND_MAJOR
 * defined via make.
 */

#define RET_ERROR(err)	-(err)			/* looks like caller wants */
						/* negative err-codes */
user_t u;					/* fake u-area from SysV386 */

/*
 * INTERRUPT-INSTALL/DEINSTALL
 * ---------------------------
 * called from snd_open/snd_release
 * has to install/deinstall msndinit()
 *
 * FIXME:
 *	1) The handler, i.e. msndintr() doesn't evaluate args passed, so
 *	   prototyping check might report warnings ...
 *	2) Now must/should we have an SA_INTERRUPT type interrupt handler?
 *	   (-->osdep.h)
 *      3) interrupt level on SysV386 is NOT identical to the IRQ-vector
 *	   but it seems to be so on Linux?
 *	4) Do we have dynamic assignment of IRQ-vectors on the fly?
 *	5) How can we determine when to use NEW_LINUX_KERNEL?
 *
 *	(SysV386: irq-level is assigned on driver installions independently
 *      from irq-vector. So one can mask selectivly interrupts to devices
 * 	of same and lower priority, without blocking the complete
 *	interrupt system. E.g. MultiSound would be assigned a low
 *	priority because of well buffering Harry Kane architecture.
 *	See splX()-call-def in Space.c and msnd.c. But we can't reassign
 *	IRQ-vectors while the system is runnings as obiviously in Linux.)
 */

int
snd_set_irq_handler (int interrupt_level, void (*hndlr) (), char *name)
{
  int retcode;

#ifdef NEW_LINUX_KERNEL	/* THIS IS A HOT FIX ... */

  retcode = request_irq (interrupt_level, hndlr, SA_INTERRUPT, name);

#else /* meaning not NEW_LINUX_KERNEL */

  struct sigaction sa;
  sa.sa_handler = hndlr;

# ifdef SND_SA_INTERRUPT /* defined in osdep.h */
  sa.sa_flags = SA_INTERRUPT;
# else
  sa.sa_flags = 0;
# endif

  sa.sa_mask = 0;
  sa.sa_restorer = NULL;

  retcode = irqaction (interrupt_level, &sa);

#endif /* meaning not NEW_LINUX_KERNEL */

  if (retcode < 0)
    {
      printk ("MultiSound: IRQ%d already in use (hmm...)\n", interrupt_level);
    }
  return retcode;
}

void
snd_release_irq (int vect)
{
  free_irq (vect);
}

/*
 * DRIVER-ENTRY-POINTS
 * -------------------
 * Called from system via function pointers
 * in registered driver table entry (see below)
 * These are the entries that a user process lands up in
 * when it opens, closes (I hope that's what is called `release' here ???),
 * reads, writes or ioctls our device file.
 *
 */

static int
sound_read (struct inode *inode, struct file *file, char *buf, int count)
{
  /*
   * we don't check for minor numbers here, because msnd.c
   * doesn't recognize different minor numbers
   */
  u.u_error = 0;			/* load fake user struct	*/
  u.u_offset = 0;
  u.u_count = count;
  u.u_base = buf;
  msndread();				/* call Sys386-Driver Entry	*/
  /*
   * on error return negtive error code
   * or else read characters non-negativ
   */
  if (u.u_error)
	return RET_ERROR (u.u_error);
  return(u.u_offset);
}

static int
sound_write (struct inode *inode, struct file *file, char *buf, int count)
{
  /*
   * same procedure as in sound_read
   */
  u.u_error = 0;			/* load fake user struct	*/
  u.u_offset = 0;
  u.u_count = count;
  u.u_base = buf;
  msndwrite();				/* call Sys386-Driver Entry	*/
  if (u.u_error)
	return RET_ERROR (u.u_error);
  return(u.u_offset);
}

static int
sound_open (struct inode *inode, struct file *file)
{
  int err,
      flags;				/* Interrupt-Mask		*/
  dev_t dummy;				/* remember we don't evaluate	*/
					/* minor number in msnd.c yet	*/
  static m_flag;			/* prepare open mode flags	*/

  m_flag = 0;				/* prepare open mode flags	*/
  if ((file->f_flags & O_ACCMODE) == O_RDWR)
    m_flag |= (FREAD|FWRITE);
  if ((file->f_flags & O_ACCMODE) == O_RDONLY)
    m_flag |= (FREAD);
  if ((file->f_flags & O_ACCMODE) == O_WRONLY)
    m_flag |= (FWRITE);

  m_DISABLE_INTR (flags);		/* arm Linux interrupt handler	*/
  err = snd_set_irq_handler (m_MSNDint, msndintr, "MultiSound");
  m_RESTORE_INTR (flags);
  if (err < 0)
	return(err);

  u.u_error = 0;			/* load fake user struct	*/
  msndopen(dummy, m_flag);

  if (u.u_error) {
  	snd_release_irq (m_MSNDint);
	return RET_ERROR(u.u_error);
  }
  return 0;
}

static void
sound_release (struct inode *inode, struct file *file)
{
    msndclose();	
    snd_release_irq (m_MSNDint);	/* disarm IRQ-vector		*/
}

static int
sound_ioctl (struct inode *inode, struct file *file,
	     unsigned int cmd, unsigned long arg)
{
    dev_t dummy;			 /* minor number not evaluated	*/

    u.u_error = 0;			/* load fake user struct	*/
    msndioctl(dummy, cmd, (char *)arg);
    if (u.u_error) {
	return RET_ERROR(u.u_error);
    }
    return 0;
}

/*
 * BOOT-TIME-CONFIGURATION-HOOK
 * ----------------------------
 * The system calls this from init/main.c, so that within VoxWare
 * one can change driver configuration from within the init process
 * at boot time (eg. sound=000XYZ)
 * In VoxWare this is defined in dev_table.c.
 * We leave this for the moment but it would be
 * VERY handy to be able to disable/enable our driver.
 */
void sound_setup(char *str, int *ints)
{
	/*
	 * Dummy for the time being - later one could modify
	 * this to influence globals in Space.c from here
	 */
}

/*
 * DRIVER-ENTRY-TABLE AND REGISTRATION-HOOK(s)
 * -------------------------------------------
 * This looks like the central part of a Linux char driver, 
 * a table defining the kind of operation we can perform on our driver.
 * We have this registered within the system resources via 
 * the soundcard_init call, which we find in drivers/char/mem.c:
 *
 *  chr_dev_init() ...
 *   #ifdef CONFIG_SOUND
 * 	mem_start = soundcard_init(mem_start);
 *   #endif
 *
 * or the sound_mem_init call in mm/memory.c:
 *
 *  mem_init()...
 *   #ifdef CONFIG_SOUND
 *   	sound_mem_init();
 *   #endif
 *
 * The latter looks special to a Linux character device driver,
 * other simple (yes, that's we intend to be) drivers like lp
 * dont use this. Now the caller to these procedures is
 * in init/main.c:
 *
 *  start_kernel()...
 *     cli() ...
 *     chr_dev_init() ...
 *     sti() ...
 *     mem_init()...
 *
 * Looks like in mem_init() we have the interrupt system
 * already running. hm....
 *
 */

static struct file_operations sound_fops =
{
  NULL,				/* sound_lseek */
  sound_read,
  sound_write,
  NULL,				/* sound_readdir */
  NULL,				/* sound_select */
  sound_ioctl,
  NULL,
  sound_open,
  sound_release	
};

long
soundcard_init (long mem_start)
{
					/*
					 * register device with linux.
					 */
    if (register_chrdev (MSND_MAJOR, "sound", &sound_fops)) {
	printk("unable to get major %d for MultiSound\n", MSND_MAJOR);
	return mem_start;
    }
    					/*
					 * here we jump into initializing
					 * MultiSound to see if it is there
					 * If msndinit fails, or was never
					 * called, its other entries return
					 * ENODEV
					 */
    msndinit();
    if (m_driver_state == 0)		/* successfully initialized? */
    	return mem_start;		/* no, nobody got hurt */
					/* yes, but */
    return mem_start;			/* no difference in handling */
}

#else /* meaning ndef CONFIGURE_SOUNDCARD */
void					/* If we are not configured/needed */
soundcard_init (void)			/* then we still have to remember */
{					/* that we're a hooks */
  /* Dummy version */
}
void sound_setup(char *str, int *ints)
{
  /* Dummy version */
}
#endif /* CONFIGURE_SOUNDCARD */

void
sound_mem_init (void)			/* Looks like we don't need this */
{					/* for multisound */
  /* Dummy version */
}

/*
 * EOT
 */

