/* $Id: iprofd.c,v 1.2 1996/01/04 02:43:44 fritz Exp fritz $
 *
 * Daemon for saving ttyIx-profiles to a file.
 *
 * Copyright 1994,95 by Fritz Elfert (fritz@wuemaus.franken.de)
 * Copyright 1995 Thinking Objects Software GmbH Wuerzburg
 *
 * This file is part of Isdn4Linux.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 * $Log: iprofd.c,v $
 * Revision 1.2  1996/01/04 02:43:44  fritz
 * Changed copying policy to GPL.
 *
 * Revision 1.1  1995/12/18  18:22:24  fritz
 * Initial revision
 *
 */

#include <sys/types.h>
#include <sys/fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <linux/isdn.h>

typedef unsigned char uchar;

int  isdnctrl_fd;
char *modemsettings;

#define BUFSZ ((ISDN_MODEM_ANZREG+ISDN_MSNLEN)*ISDN_MAX_CHANNELS)

void
dumpModem(int dummy) {
  int fd;
  int len;
  char buffer[BUFSZ];

  if ((len = ioctl(isdnctrl_fd,ISDN_IOCTL_PROFILEGET,&buffer))<0) {
    perror("ioctl ISDN_IOCTL_PROFILEGET");
    exit(-1);
  }
  fd = open(modemsettings,O_WRONLY|O_CREAT|O_TRUNC,0644);
  if (fd<0) {
    perror(modemsettings);
    exit(-1);
  }
  write(fd,buffer,len);
  close(fd);
  signal(SIGIO,dumpModem);
}

void
readModem(void) {
  int len;
  int fd;
  char buffer[BUFSZ];

  fd = open(modemsettings,O_RDONLY);
  if (fd<0)
    return;
  len = read(fd,buffer,BUFSZ);
  if (len<0) {
    perror(modemsettings);
    exit(-1);
  }
  close(fd);
  if (ioctl(isdnctrl_fd,ISDN_IOCTL_PROFILESET,&buffer)<0) {
    perror("ioctl ISDN_IOCTL_PROFILESET");
    exit(-1);
  }
}

void
usage(void) {
  fprintf(stderr,"usage: iprofd <IsdnModemProfile>\n");
  exit(-1);
}

void
main(int argc, char **argv) {

  if (argc != 2)
    usage();
  modemsettings = argv[1];
  isdnctrl_fd = open("/dev/isdnctrl",O_RDONLY);
  readModem();
  switch (fork()) {
    case -1:
      perror("fork");
      exit(-1);
      break;
    case 0:      
      dumpModem(0);
      if (ioctl(isdnctrl_fd,ISDN_IOCTL_PROFILESIG,0)) {
	perror("ioctl ISDN_IOCTL_PROFILESIG");
	exit(-1);
      }
      while (1) sleep(1000);
      break;
    default:
      break;
  }
}







