/*
 * Project:	chkonline (add on tool for isdn4linux)
 * Release:	0.0.1
 * Author:	Friedemann Baitinger (baiti@herrenberg,netsurf.de)
 * Date:	95/12/30
 *
 * Copyright 1996 by Friedemann Baitinger (baiti@herrenberg,netsurf.de) 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Description:
 *
 *	The purpose of this program is to provide a mechanism to check
 *	whether a network type connection to a specific destination
 *	exists at the time the progam is called. 'ping' or anything
 *	like that can't be used because using it would immediately
 *	trigger a connect request. Consequently we have to read the
 *	status data from the /dev/isdnmon device and parse the data
 *	accordingly. 
 *
 *	Fortunately Michael Knigge already wrote a program (IMON) which
 *	does the reading and parsing of the data supplied by /dev/isdnmon.
 *	I took the liberty to reuse his code.
 *
 *	Usage:  chkonline phone_number
 *
 *	the tool returns 0 if a network type connection to the given
 *	destination phone number exists. otherwise a non-zero return
 *	code is returned. 'phone_number' doesn't have to be a fully
 *	qualified number, a valid substring would do just fine, however
 *	wildcard handling is not supported at this time and probably
 *	will never be....
 */

#define TESTx
#define BUF_SIZ			512

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>

#ifndef ISDN_MAX_CHANNELS
    #define ISDN_MAX_CHANNELS	4
    #define ISDN_USAGE_NET	3
#endif
    
static char idmap_line[BUF_SIZ];
static char chmap_line[BUF_SIZ];
static char drmap_line[BUF_SIZ];
static char usage_line[BUF_SIZ];
static char flags_line[BUF_SIZ];
static char phone_line[BUF_SIZ];

static FILE *isdninfo;

int main(int argc, char **argv) 
{
    char *ptr_idmap;
    char *ptr_chmap;
    char *ptr_drmap;
    char *ptr_usage;
    char *ptr_flags;
    char *ptr_phone;
    char *my_phone;
   
    char channel[32];
    char phone[32];

    char temp[32];   

    int  local;
    int  chanum;
    int  line;
    int  hit = 0;
    int  rc  = 1;

    if (argc < 2) {
        printf("Usage: %s phone_number\n", argv[0]);
        exit(-1);
    }
        
    my_phone = argv[1];
    
    if (!(isdninfo = fopen("/dev/isdninfo", "r"))) {
        fprintf(stderr, "Can't open /dev/isdninfo\n");
        exit(-2);
    }
   
    fgets(idmap_line, BUF_SIZ, isdninfo);
    fgets(chmap_line, BUF_SIZ, isdninfo);
    fgets(drmap_line, BUF_SIZ, isdninfo);
    fgets(usage_line, BUF_SIZ, isdninfo);
    fgets(flags_line, BUF_SIZ, isdninfo);
    fgets(phone_line, BUF_SIZ, isdninfo);
    
#ifdef TEST1
    sprintf(idmap_line, "idmap: TA250034 - - - - - - - - - - - - - - -");
    sprintf(chmap_line, "chmap: 0 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1");
    sprintf(drmap_line, "drmap: 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1");   
    sprintf(usage_line, "usage: 1 2 0 3 4 0 5 0 129 0 130 131 132 0 0 133");
    sprintf(flags_line, "flags: 0 ? ? ? ? ? ? ? ? ? ? ? ? ? ? ?");
    sprintf(phone_line, "phone: 05114711 0815 ??? 5555 666666666 ??? 4711 ??? 875257 ??? 77848 7890 2345467 ??? ??? 8888888888");

#endif
#ifdef TEST2
    sprintf(idmap_line, "idmap:  teles0 teles0 - - - - - - - - - - - - - -"); 
    sprintf(chmap_line, "chmap:  0 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1"); 
    sprintf(drmap_line, "drmap:  0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1"); 
    sprintf(usage_line, "usage:  131 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"); 
    sprintf(flags_line, "flags:  1 ? ? ? ? ? ? ? ? ? ? ? ? ? ? ?"); 
    sprintf(phone_line, "phone:  87194 ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? ???"); 

#endif

    ptr_idmap = idmap_line + 7;
    ptr_chmap = chmap_line + 7;
    ptr_drmap = drmap_line + 7;
    ptr_usage = usage_line + 7;
    ptr_flags = flags_line + 7;
    ptr_phone = phone_line + 7;
   
    for (line = 1; line < ISDN_MAX_CHANNELS + 1; line++) {
        sscanf(ptr_idmap, "%s", channel);
        ptr_idmap += strlen(channel) + 1;
        sscanf(ptr_usage, "%d", &local);   
        sscanf(ptr_usage, "%s", temp);
        ptr_usage += strlen(temp) + 1;
        sscanf(ptr_phone, "%s", phone);
        sscanf(ptr_chmap, "%d", &chanum);
        sscanf(ptr_chmap, "%s", temp);
        ptr_chmap = ptr_chmap + strlen(temp) + 1;

        if (chanum == -1)
            continue;

        if ((local & 7) == 0) {
            ptr_phone += 4;
            continue;
        }
        ptr_phone += strlen(phone) + 1;

        if ((local & 7) != ISDN_USAGE_NET)
            continue;

	/*
	 * here we believe we have found a channel with a network type
	 * connection.
	 */
	 
        hit = 1;
        break;                
    }
     
    /*
     * now check the phone number and set the exit code accordingly.
     * we return zero if a network connection to the requested telephone
     * number exists, otherwise we return 1 (or some negative value in
     * case of usage or file open errors)
     */

    if (hit != 0) {
        if (strstr(phone, my_phone) != NULL)
            rc = 0;
        else
            rc = 1;
    }
#if defined(TEST1) | defined(TEST2)            
    printf("rc = %d\n", rc);
#endif            
    return(rc);
}

