/*
%%% copyright-cmetz
This software is Copyright 1996 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#ifndef _NETINET6_IPV6_H
#define _NETINET6_IPV6_H 1

#include <netinet6/in6.h>
#include <linux/ipv6.h>
#include <asm/byteorder.h>

struct ipv6hdr {
#if defined(__LITTLE_ENDIAN_BITFIELD)
  u_int8_t ipv6_version:4;
  u_int8_t ipv6_priority:4; /* going away? */
  u_int32_t ipv6_flowid:24;
#elif defined (__BIG_ENDIAN_BITFIELD)
  u_int32_t ipv6_flowid:24;
  u_int8_t ipv6_priority:4; /* going away? */
  u_int8_t ipv6_version:4;
#else
#error  "Please fix <asm/byteorder.h>"
#endif
  u_int16_t ipv6_len;
  u_int8_t ipv6_nextheader;
  u_int8_t ipv6_hoplimit;
  struct in6_addr ipv6_src;
  struct in6_addr ipv6_dst;
};
#endif /* _NETINET6_IPV6_H */
