/*
%%% copyright-cmetz
This software is Copyright 1996 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#ifndef _NETINET6_IN6_H
#define _NETINET6_IN6_H 1

#include <linux/in6.h>
#include <linux/ipv6.h>

/* Basic API */
extern const struct in6_addr in6addr_any;
#define IN6ADDR_ANY_INIT { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }
extern const struct in6_addr in6addr_loopback;
#define IN6ADDR_LOOPBACK_INIT { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1 }

#ifdef notyet
unsigned int if_nametoindex(const char *ifname);
char *if_indextoname(unsigned int ifindex, char *ifname);

struct if_nameindex {
  unsigned int  if_index;
  char         *if_name;   /* null terminated name: "le0", ... */
};

struct if_nameindex *if_nameindex(void);
#endif /* notyet */

#define INET_ADDRSTRLEN 16
#define INET6_ADDRSTRLEN 46

int inet6_isipv4mapped(const struct in6_addr *addr);

int inet_pton __P((int, const char *, void *));
const char *inet_ntop __P((int, const void *, char *, size_t));
int getnameinfo __P((const struct sockaddr *sa, size_t addrlen, char *host, size_t hostlen, char *serv, size_t servlen));

#ifndef IPPROTO_NONE
#define IPPROTO_HOP       0
#define IPPROTO_IPV4      4
#define IPPROTO_ROUTING  43
#define IPPROTO_FRAGMENT 44
#define IPPROTO_NONE     59
#define IPPROTO_DST      60
#endif /* IPPROTO_NONE */

#define IN6_IS_ADDR_UNSPECIFIED(a) \
        ((((u_int32_t *)(a))[0] == 0) && ((u_int32_t *)(a))[1] == 0) && \
         (((u_int32_t *)(a))[2] == 0) && ((u_int32_t *)(a))[3] == 0))

#define IN6_IS_ADDR_LOOPBACK(a) \
        ((((u_int32_t *)(a))[0] == 0) && ((u_int32_t *)(a))[1] == 0) && \
         (((u_int32_t *)(a))[2] == 0) && ((u_int32_t *)(a))[3] == htonl(1)))

#define IN6_IS_ADDR_MULTICAST(a) (((u_int8_t *)(a))[0] == 0xff)

#define IN6_IS_ADDR_LINKLOCAL(a) \
        ((((u_int32_t *)(a))[0] & htonl(0xffc00000)) == htonl(0xfe800000))

#define IN6_IS_ADDR_SITELOCAL(a) \
        ((((u_int32_t *)(a))[0] & htonl(0xffc00000)) == htonl(0xfec00000))

#define IN6_IS_ADDR_V4MAPPED(a) \
        ((((u_int32_t *)(a))[0] == 0) && (((u_int32_t *)(a))[1] == 0) && \
         (((u_int32_t *)(a))[2] == htonl(0xffff)))

#define IN6_IS_ADDR_V4COMPAT(a) \
        ((((u_int32_t *)(a))[0] == 0) && (((u_int32_t *)(a))[1] == 0) && \
         (((u_int32_t *)(a))[2] == 0) && (ntohl(((u_int32_t *)(a))[3]) > 1))

#ifdef notyet
#define IN6_IS_ADDR_MC_NODELOCAL(a) \
        (GET_IN6_MCASTSCOPE(*a) == IN6_INTRA_NODE)

#define IN6_IS_ADDR_MC_LINKLOCAL(a) \
        (GET_IN6_MCASTSCOPE(*a) == IN6_INTRA_LINK)

#define IN6_IS_ADDR_MC_SITELOCAL(a) \
        (GET_IN6_MCASTSCOPE(*a) == IN6_INTRA_SITE)

#define IN6_IS_ADDR_MC_ORGLOCAL(a) \
        (GET_IN6_MCASTSCOPE(*a) == IN6_INTRA_ORG)

#define IN6_IS_ADDR_MC_COMMLOCAL(a) \
        (GET_IN6_MCASTSCOPE(*a) == IN6_INTRA_COMM)

#define IN6_IS_ADDR_MC_GLOBAL(a) \
        (GET_IN6_MCASTSCOPE(*a) == IN6_GLOBAL)
#endif /* notyet */
#endif /* _NETINET6_IN6_H */
