/* ------------------------------------------------------------------------- */
/* i2c_priv.h -- local definitions for the various modules		     */
/* ------------------------------------------------------------------------- */
/* $Id: i2c_priv.h,v 2.4 1997/06/03 05:59:16 i2c Exp i2c $
 * $Log: i2c_priv.h,v $
 * Revision 2.4  1997/06/03 05:59:16  i2c
 * removed macro bug in pcf-section
 *
 * Revision 2.3  1996/11/20 20:22:33  i2c
 * added declarations for pcf
 *
 * Revision 2.2  1996/11/18 22:24:06  i2c
 * Added support for pcf-adapter data types, major rearrangement
 * of the whole document
 *
 * Revision 2.1  1996/11/17 14:03:12  i2c
 * changed for new module layout.
 * Moved public defines into ../include/i2c.h
 *
 * Revision 1.3  1996/07/23 21:37:09  i2c
 * moved several infos from i2c.h here
 *
 * Revision 1.2  1996/03/28 20:36:16  i2c
 * *** empty log message ***
 *
 */
#ifndef I2C_PRIV_H
#define I2C_PRIV_H

#include <linux/fs.h>
#include "i2c.h"
/*
 * File operations structure with additional init/exit functions for the
 * access algorithm layer modules:
 */
struct i2c_opns {	
	int (*read) (struct inode *, struct file *, char *, int);
	int (*write) (struct inode *, struct file *, const char *, int);
	int (*ioctl) (struct inode *, struct file *, unsigned int, unsigned long);
	int (*open) (struct inode *, struct file *);
	void(*close) (struct inode *, struct file *);
	int (*init) (int);
	void (*exit) (int);
};

extern struct i2c_opns alg_bit_opns;	/* file operations of bit-adap	*/
extern struct i2c_opns alg_pcf_opns;	/* f-ops for PCF 8584 adapters	*/
extern struct i2c_opns illegops;	/* dummy for illegal types	*/


/* 
 * private information for each open file:
 */ 
struct i2c_data {
	int magic;		/* i2c's magic number			*/
	char address;		/* address slave chip			*/
        char ownadr;            /* interface i2c-address		*/
	unsigned int  flags;	/* local flags field			*/
	char port1;		/* data storage for first port 		*/
	char port2;		/* data storage for second port 	*/
};

				/* the local flags:			*/
#define F_LNG0	0x00		/* 10 bit address group 0		*/
#define F_LNG1	0x01		/* 10 bit address group 1		*/
#define F_LNG2	0x02		/* 10 bit address group 2		*/
#define F_LNG3	0x03		/* 10 bit address group 3		*/
#define F_LONG	0x04		/* enable 10 bit addressing		*/
#define F_INIT	0x80		/* structure has been initialized	*/



#define	BASE	i2c_table[(minor)].base	/* hardware base port		*/


/* --- Defines for bit-adapters ---------------------------------------	*/
#if (BITADAPS)

extern int alg_bit_init(void);	/* Init procedure for algorithm module	*/

# if ( (BITADAPS) > 1 )
/*
 * This struct contains the hw-dependent functions of bit-style adapters to 
 * manipulate the line states, and to init any hw-specific features. This is
 * only used if you have more than one hw-type of adapter running. 
 */
struct i2c_bit_opns {
	void (*setsda) (int minor, int state);
	void (*setscl) (int minor, int state);
	int  (*getsda) (int minor);
	int  (*getscl) (int minor);
	int  (*init)    (int minor);
	void (*exit)    (int minor);
};

extern struct i2c_bit_opns *bit_adaps[];

#  define setsda(minor,state)	bit_adaps[i2c_table[minor].flags&I2C_HW_MASK]->setsda(minor,state)
#  define setscl(minor,state)	bit_adaps[i2c_table[minor].flags&I2C_HW_MASK]->setscl(minor,state)
#  define getsda(minor)		bit_adaps[i2c_table[minor].flags&I2C_HW_MASK]->getsda(minor)
#  define getscl(minor)		bit_adaps[i2c_table[minor].flags&I2C_HW_MASK]->getscl(minor)

#  define bit_init(minor)	bit_adaps[i2c_table[minor].flags&I2C_HW_MASK]->init(minor)
#  define bit_exit(minor)	bit_adaps[i2c_table[minor].flags&I2C_HW_MASK]->exit(minor)

# else

extern inline void setsda(int minor, int state);
extern inline void setscl(int minor, int state);
extern inline int  getsda(int minor);
extern inline int  getscl(int minor);
extern inline int  bit_init(int minor);
extern inline void bit_exit(int minor);

# endif

/* ---- minimum delays for transmission	& a bit more for my long lines	*/
#define WHI  20			/* ... for bit-adapters only		*/
#define WLO  20



#endif /* BITADAPS */


/* --- Defines for PCF adapters ---------------------------------------	*/
#if (PCFADAPS)

extern int alg_pcf_init(void);	/* Init procedure for algorithm module	*/

# if ( PCFADAPS > 1 )
/*
 * ditto for PCF 8584 based interfaces:
 */
struct i2c_pcf_opns {
	/*to be defined... */
	int  (*pcf_read)	(int minor, int adr);
 	void (*pcf_write)	(int minor, int adr,char data);
 	int  (*pcf_init)	(int minor);
	void (*pcf_exit)	(int minor);
};
# else

extern	int  pcf_read	(int minor, int adr);
extern	void pcf_write	(int minor, int adr,char data);
extern	int  pcf_init	(int minor);
extern	void pcf_exit	(int minor);
#endif
			/* some convenience defines: */
# define pcfInt(cmd)	(i2c_table[minor].irq>0)? (cmd)|PCF_ENI : (cmd)
# define cmd(data)	pcf_write(minor,1,pcfInt(data))
# define dta(data)	pcf_write(minor,0,(data))
# define stat()		pcf_read(minor,1)
# define recv()		pcf_read(minor,0)

#endif

/* --- Convenience defines for the parallel port:			*/
#define DATA	BASE			/* Centronics data port		*/
#define STAT	(BASE+1)		/* Centronics status port	*/
#define CTRL	(BASE+2)		/* Centronics control port	*/

#endif	/* - I2C_PRIV_H	-----------------------------------------------	*/
