/* ------------------------------------------------------------------------- */
/* detect -- look who's there. Gets address acks from all devices on the bus.*/
/*		It should not change any values in the peripherals.	     */
/* ------------------------------------------------------------------------- */
static char *rcsid="$Id: eeprom.c,v 1.1 1996/07/23 20:32:12 i2c Exp $";
/*
 * $Log: eeprom.c,v $
 * Revision 1.1  1996/07/23 20:32:12  i2c
 * Initial revision
 *
 * Revision 1.2  1996/07/06 17:20:38  i2c
 * rewrote loop
 *
 * Revision 1.1  1996/03/15 08:55:53  root
 * Initial revision
 *
 */

#include <unistd.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <linux/delay.h>
#include "i2c.h"

#define Write(a,b,c)	err(1,write(a,b,c))
#define Read(a,b,c)	err(0,read(a,b,c))

void err(int wr, int d){
	if (d==-1){
		printf("%s error: %s !\n",(wr)?"Write":"Read",strerror(errno));
	}
}

int main(int argc, char *argv[]){
	int i,j,f;
	char buf[512];
	int c;
	int wr=0,adr=160;

	/* parse options */
	opterr=1;
	while ( (c=getopt(argc,argv,"wa:A:")) != -1) {
		switch (c){
			case 'w':
				wr=1;
				break;
			case 'A':
			case  'a':
				if (optarg)
					adr=strtol(optarg,NULL,0);
				break;
			default:
		}
	}




	f=open("/dev/i2c0",O_RDWR);
	if (f<0){
		printf("open error!\n");
		exit(1);
	}
	ioctl(f,I2C_UDELAY,130);
	ioctl(f,I2C_MDELAY,110);
        ioctl(f,I2C_RETRIES,3);
       	ioctl(f,I2C_SLAVE,adr);

	if (wr) {
		for (i=0;i<32;i++){
			buf[0]=8*i;
			for (j=0;j<8;j++){
				buf[j+1]=j+i*8;
			};
			write(f,buf,9);
			while (-1==read(f,buf,1));
		}
	}

	for (i=0;i<16;i++){
		buf[0]=16*i;
		if (-1 == write(f,buf,1)) 
			putchar('!');
		else
			putchar(' ');
		if (-1 == read(f,buf,16))
			printf("%s\n", strerror(errno));
		for (j=0;j<16;j++) {
			printf("%3d ",(unsigned char)buf[j]);
			buf[j]=0;
		}
		putchar('\n');
	}

	return close(f);
}
