/* ------------------------------------------------------------------------- */
/* lpctrl.c  control line states on lp					     */
/* ------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>

int main(int argc, char *argv[]){
	int f = open("/dev/i2c0",O_RDWR);
	
	if (argc==2) {
		switch (argv[1][0]){
			case 'a':
				ioctl(f,0x0804);
				break;
			case 'r':
				ioctl(f,0x0802);
				break;
			case 'w':
				ioctl(f,0x0801);
				break;
			case 'c':
				ioctl(f,0x0803);
				break;
			case 'R':
				ioctl(f,0x0800);
				break;
			default:
				printf("invalid choice.\n");
				printf("use (a)0  (c)s (w)r (r)d (R)eset\n");
		}	
	} else {
		ioctl(f,0x0810);
	}
	return 0;
}