/* ------------------------------------------------------------------------- */
/* i2c_priv.h -- local definitions for the various modules		     */
/* ------------------------------------------------------------------------- */
/* $Id: i2c_priv.h,v 1.2 1996/03/28 20:36:16 i2c Exp i2c $
 * $Log: i2c_priv.h,v $
 * Revision 1.2  1996/03/28 20:36:16  i2c
 * *** empty log message ***
 *
 */
#ifndef I2C_PRIV_H
#define I2C_PRIV_H

struct i2c_opns {	
	int (*read) (struct inode *, struct file *, char *, int);
	int (*write) (struct inode *, struct file *, const char *, int);
	int (*ioctl) (struct inode *, struct file *, unsigned int, unsigned long);
	int (*open) (struct inode *, struct file *);
	void(*close) (struct inode *, struct file *);
	int (*init) (int);
	void (*exit) (int);
};

/* ---- Adapter types: Add a define statement & the struct 		*/
/*	numbers must be <P_TMASK.					*/
#define ADAP_PHIL	0	/* Philips style HW, new addressing	*/
#define ADAP_LPPCF	1	/* PCF8584 on bidir. parallel port	*/
#define ADAP_LPBIT	7	/* Philips style HW, old addressing	*/

extern struct i2c_opns philops;		/* Philips parallel port adapter*/
extern struct i2c_opns lppcfops;	/* PCF8584 on parallel port	*/
extern struct i2c_opns lpbitops;	/* Philips parallel port adapter*/
extern struct i2c_opns illegops;	/* dummy for illegal types	*/
 
extern struct i2c_opns *i2c_adap[];


/* ----- private information for each open file: 			*/
 
struct i2c_data {
	int magic;		/* i2c's magic number			*/
	char address;		/* address slave chip			*/
	unsigned int  flags;	/* local flags field			*/
};

				/* the local flags:			*/
#define F_LNG0	0x00		/* 10 bit address group 0		*/
#define F_LNG1	0x01		/* 10 bit address group 1		*/
#define F_LNG2	0x02		/* 10 bit address group 2		*/
#define F_LNG3	0x03		/* 10 bit address group 3		*/
#define F_LONG	0x04		/* enable 10 bit addressing		*/
#define F_INIT	0x80		/* structure has been initialized	*/

#endif