#---------------------------------
# vt - display videotext pages
#---------------------------------

proc menubar {m} {
	frame $m
	menubutton $m.file -text "Test"
	pack $m
}

#---------------------------------
# init routines
#---------------------------------


proc initDisplay {{b .display}} {
	global display vtex 
	
	catch { destroy $b}
	toplevel  $b
	set display $b
	wm geom $b 720x450
	wm title $b "Videotext Display"
	set vtex(display) 1


	set x 0
	set y 0
	for {set i 0} { $i <= 24} { incr i} {		
		frame $b.$i -geom 720x18 -bord 0 -rel flat 
		for {set j 0} { $j < 40} { incr j} {
			label $b.$i.$j  -anchor c -rel flat -bd 0\
				-font lucidasanstypewriter-18 \
				-back black -fore white -text " " \
				-bitmap @$vtex(prefix)/38
			place $b.$i.$j -in $b.$i -w 18 -h 18  -anchor nw -x $x 
			set x [ expr $x + 18 ]

			# debugging ...
			
			bind $b.$i.$j <Any-ButtonPress-1> "
				$b.deb entryconf 0 -label \"%W\"
				$b.deb entryconf 1 -label \"\[%W conf -text\] \"
				$b.deb entryconf 2 -label \"\$mem(%W)\"
				$b.deb post %X %Y
			"
			bind $b.$i.$j <Any-ButtonRelease-1> "$b.deb unpost"
		}
		place $b.$i -in $b -y $y -anchor nw
		set x 0
		set y [ expr $y + 18 ]
	} 
	# now some fancy debugging features:
	menu $b.deb
    $b.deb add command -label "..." -command {}
	$b.deb add command -label "+++" -command {} 
	$b.deb add command -label "---" -command {}
}

proc initMenu {{m .menu}} {
	catch {destroy $m}
	frame $m -bd 2 -rel raised 
	pack $m -side top -fill x -expand y
	menubutton $m.file  -bd 0 -text "File" -menu $m.file.m
	menubutton $m.opt -bd 0 -text "Options" -menu $m.opt.m
	menubutton $m.page -bd 0 -text "Page" -menu $m.page.m
	menubutton $m.about -bd 0 -text "About" -menu $m.about.m
	pack $m.file $m.opt $m.page -padx 1m -side left -ipady 1m
	pack $m.about -side right -padx 1m -ipady 1m

	menu $m.file.m
	$m.file.m add command -label "Display Page" -underline 0 \
		-command {initDisplay}
	$m.file.m add command -label "Clear Page" -underline 0
	$m.file.m add separator
	$m.file.m add command -label "vt" -underline 0 -command {source vt.tcl}
	$m.file.m add command -label "parse" -underline 0 -command {source parse.tcl}
	$m.file.m add separator
	$m.file.m add command -label "Quit" -underline 0 -command {destroy .}

	menu $m.opt.m
	$m.opt.m add command -label "Status" -underline 0 -command {
			global vtex
			set vtex(status) [expr  !$vtex(status) ]
			initBody
		}
    $m.opt.m add command -label "Update" -underline 0 -command {updStatus; update idletasks}
	$m.opt.m add command -label "Command" -underline 0 -command {
			global vtex
			set vtex(cmd) [expr  !$vtex(cmd) ]
			if { $vtex(cmd) } { 
				entry .cmd -bd 2 -relief sunken
				label .ret -textvar retval
				pack .ret .cmd  -side bottom -fill x 
				bind .cmd <Any-Key-Return> { set retval [ eval [.cmd get ] ]}
			} else {
				catch {destroy .cmd .ret }
			}
		}
	$m.opt.m add checkbutton -label "Info" -underline 0 -var info

	menu $m.page.m
	$m.page.m add checkbutton -label "Hold" -underline 0 -command {set vtex(p_hold) [expr !$vtex(p_hold)]}

	menu $m.about.m
	$m.about.m add command -label "Info" -underline 0 -command {AboutDlg}
	$m.about.m add cascade -label "Chip" -underline 0 \
		-menu $m.about.m.chip
	set ch $m.about.m.chip
	menu $ch
	$ch add checkbutton -label "Searching" -underline 0 -var chipSearching

	$ch add separator
	$ch add radiobutton -label "Chapter 1" -val 1 -var chipChap -command {set vtex(page) 0}
	$ch add radiobutton -label "Chapter 2" -val 2 -var chipChap -command {set vtex(page) 1}
	$ch add radiobutton -label "Chapter 3" -val 3 -var chipChap -command {set vtex(page) 2}
	$ch add radiobutton -label "Chapter 4" -val 4 -var chipChap -command {set vtex(page) 3}


	tk_menuBar $m $m.file $m.opt $m.page $m.about
}

proc initQuery {{b .body.q}} {
	catch {destroy $b}
	frame $b -bd 2 -rel groove
	frame $b.1
	frame $b.2 
	frame $b.3
	pack $b $b.1 $b.2 $b.3 -side top -padx 2m -pady 2m
	label $b.1.p -text "MemPage:" 
	entry $b.1.e -w 8  -bd 2 -rel sunken -textvar page
	pack $b.1.p $b.1.e -side left -pady 2m -padx 2m
	label $b.2.p -text "Current"
	label $b.2.e -w 8  -textvar  currentPage
	pack $b.2.p $b.2.e -side left -pady 2m -padx 2m
	button $b.3.l -text "request" -command {requestPage $page}
	button $b.3.r -text "display" -command {displayPage $page}
	pack $b.3.r $b.3.l -side left -pady 2m -padx 2m
	
	bind $b.1.e <Any-KeyPress-Return> {
		set statusmsg Searching
 		requestPage $page
 		rollHeader
		set currentPage $page
                set statusmsg Ready
		}
}

proc initStatus {{b .body.s}} {
	global vtex statusmsg text video
	catch {destroy $b}
	frame $b
	frame $b.0
	frame $b.1
	frame $b.2
	frame $b.3
	frame $b.4
	frame $b.5
	pack $b $b.0 $b.1 $b.2 $b.3 $b.4 $b.5 -side top -fill x
	checkbutton  $b.0.vid  -text "video" -var video -rel flat
	checkbutton  $b.0.txt  -text "text"  -var text -rel flat
	bind $b.0.vid <Any-Enter> {}
	bind $b.0.txt <Any-Enter> {}
    bind $b.0.vid <Any-Enter> {}
    bind $b.0.txt <Any-Enter> {}

	pack $b.0.vid  $b.0.txt -si left
	label $b.1.mag	-text "M" -width 2
	label $b.1.ten	-text "T" -width 2
	label $b.1.one	-text "O" -width 2
	label $b.1.ht 	-text "h" -width 2
	label $b.1.hu	-text "h" -width 2
	label $b.1.mt	-text "m" -width 2
	label $b.1.mu	-text "m" -width 2
	pack  $b.1.mag $b.1.ten $b.1.one $b.1.ht $b.1.hu $b.1.mt $b.1.mu -si left
	label $b.2.mag  -text "1" -width 2
	label $b.2.ten  -text "0" -width 2
	label $b.2.one  -text "0" -width 2
	label $b.2.ht   -text "x" -width 2
	label $b.2.hu   -text "x" -width 2
	label $b.2.mt   -text "x" -width 2
	label $b.2.mu   -text "x" -width 2
	pack  $b.2.mag $b.2.ten $b.2.one $b.2.ht $b.2.hu $b.2.mt $b.2.mu -si left
    label $b.3.mag  -text " " -width 2
    label $b.3.ten  -text " " -width 2
    label $b.3.one  -text " " -width 2
    label $b.3.ht   -text " " -width 2
    label $b.3.hu   -text " " -width 2
    label $b.3.mt   -text " " -width 2
    label $b.3.mu   -text " " -width 2
    pack  $b.3.mag $b.3.ten $b.3.one $b.3.ht $b.3.hu $b.3.mt $b.3.mu -si left
	frame $b.4.1
	frame $b.4.2
	pack  $b.4.1 $b.4.2 -si left
	label $b.4.1.1  -text "lang:"
	label $b.4.2.1 -text " "
	label $b.4.1.2 -text "Transmit"
	label $b.4.2.2 -text " "
    label $b.4.1.3 -text "Transmit"
	label $b.4.2.3 -text " "
	pack $b.4.1.1 $b.4.2.1 $b.4.1.2 $b.4.2.2 $b.4.1.3 $b.4.2.3 -side top
    label $b.5.f  -text "found:" 
    label $b.5.fo  -text " "
    label $b.5.p  -text "pblf:"
    label $b.5.po  -text " "
	pack $b.5.f $b.5.fo $b.5.p $b.5.po  -side left
}

proc initBody {{b .body}} {
	global vtex status info
	catch {destroy $b}
	frame $b
	pack $b -side top -fill x  -ipady 2m 
	frame $b.l
	initQuery $b.l.q
	pack $b.l -side left
	if { $vtex(status) } {
		frame $b.r
		pack $b.r -side right
		initStatus $b.r.s
		set vtex(statusHome) $b.r.s
		updStatus
	}
}

proc initVars {} {
# init the variables that have to be set
	global vtex statusmsg lang chipChap
	set chipChap 1
	set vtex(prefix)	../include/bitmap/18x18
	set statusmsg	Ready
	set vtex(display) 	[expr ![catch {place slaves .display}]]
	set vtex(status)	1 	
		# [expr ![catch {pack slaves .body.r}]]
	set vtex(cmd)		[expr [catch {pack slaves .cmd}]]

	# page options 
	set vtex(p_hold) 1
	set vtex(page)   0
	#s'pose we have a western european decoder: 
	set lang(0) "English"
	set lang(1) "German"
	set lang(2) "Swedish"
	set lang(3) "Italian"
	set lang(4) "French"
	set lang(5) "Spanish"
	set lang(6) "English"
	set lang(7) "English"
}

proc main {} {
	wm title . "VteX"
	wm iconbitmap . @icon 
	initVars
	initMenu
	initBody
ivt wr 0 0
ivt wr 1 0
}

#---------------------------------
# dialogs
#---------------------------------
proc editPage {{e .edit}} {
	global vtex	
	catch {destroy $e}
	toplevel $e
	text $e.text -width 40 -h 24 -font lucidasanstypewriter-14 -ba black -fore white
	pack $e.text
	for {set i 1} { $i<25 } { incr i} {
		.edit.text insert 1.0 "                                        "
	}
	bind .edit.text <Any-Key> { 
		.edit.text del @%x,%y
		.edit.text insert @%x,%y %A
		}
}

proc AboutDlg {{a .about}} {
	catch {destroy $a}

	toplevel $a
	wm geom $a +100+100
	
	label $a.1 -text "VideoText"	
	label $a.2 -text "for X11"
	label $a.3 -text "by Simon G. Vogl"
	label $a.4 -text "(u) 1995"

	button $a.x -text "That's it" -command "destroy $a"
	pack $a.1 $a.2 $a.3 $a.4 -side top -anchor center
	pack $a.x -side bottom -pady 2m
}

proc ChipInfoDlg {{c .chip}} {
	catch {destroy $c}

	toplevel $c
	wm geom $c +100+100
	label $a.title 
}

#---------------------------------
# user interaction routines
# ( not too many, at the moment)
#---------------------------------

proc getChipValues {} {
#
# auslesen der Status-bits des Videotextdekoders
#

	global chipSearching chipChap
	
	set chipSearching 1

	set chipChap [ expr $chipChap + 1]
	if { $chipChap > 4 } {
		set chipChap 1 
	}

}

proc displayPage {{num 100}} {

	global vtex statusmsg
	if { 0 == $vtex(display)} {
		initDisplay
		set vtex(display) 1
	}
	parseP [ ivt wr 8 $vtex(page) 0 0 ; ivt re 1000]
}

#-------------
#  utilities 
#-------------

proc updStatus {} {
	global vtex text video lang
	if {$vtex(status)} {
		set b $vtex(statusHome)

		ivt wr 0 1
		set a [ivt re 1]
		ivt wr 0 0
		set text [expr $a&2!=0]
		set video [expr $a&1!=0]
		set pag [ivt wr 8 $vtex(page) 25 0;ivt re 10]
		$b.2.mag conf -text "[expr [lindex $pag 8]&7]"
        $b.2.ten conf -text "[expr [lindex $pag 1]&15]" 
		$b.2.one conf -text "[expr [lindex $pag 0]&15]" 
		$b.2.ht conf -text "[expr [lindex $pag 5]&3]" 
		$b.2.hu conf -text "[expr [lindex $pag 4]&15]" 
		$b.2.mt conf -text "[expr [lindex $pag 3]&7]" 
		$b.2.mu conf -text "[expr [lindex $pag 2]&15]"

        $b.3.mag conf -text "hm"
        $b.3.ten conf -text "[expr [lindex $pag 1]&16!=0]"
        $b.3.one conf -text "[expr [lindex $pag 0]&16!=0]"
        $b.3.ht conf -text "[expr [lindex $pag 5]&16!=0]"
        $b.3.hu conf -text "[expr [lindex $pag 4]&16!=0]"
        $b.3.mt conf -text "[expr [lindex $pag 3]&16!=0]"
        $b.3.mu conf -text "[expr [lindex $pag 2]&16!=0]"

		set lng [expr ([lindex $pag 7]&8)/8 + ([lindex $pag 7]&4)/2+([lindex $pag 7]&2)*2]
		$b.4.2.1 conf -text "$lang($lng)"
		set lang(current) $lang($lng)
		if {[expr [lindex $pag 7]&1!=0]} {
			$b.4.2.2 conf -text "Serial"
		} else {
			$b.4.2.2 conf -text "Parallel"
		}
        if {[expr [lindex $pag 6]&8!=0]} {
            $b.4.1.3 conf -text "Inh. Disp"
        } else {
            $b.4.1.3 conf -text "Display"
        }
        if {[expr [lindex $pag 6]&4!=0]} {
            $b.4.2.3 conf -text "Seq. int"
        } else {
            $b.4.2.3 conf -text "Seq. nrm"
        }
		
		$b.5.fo conf -text "[expr [lindex $pag 8]&16==0]"
		$b.5.po conf -text "[expr [lindex $pag 9]&32!=0]"
	}
}

