/* dualmon.h: configuration information for dual-monitor patches.
 *
 * todd j. derr 2 Aug 1994
 *
 * all dualmon-related configuration defines are now in this file.
 */

#ifndef __DUALMON_H
#define __DUALMON_H

/* comment the next three lines out if either:
 * (1) if you are using config.in to configure dualmon
 * (2) you want to disable dualmon (might also want to put an #undef)
 */

#ifndef CONFIG_DUALMON
#define CONFIG_DUALMON 1
#endif

#ifdef CONFIG_DUALMON
/* the default (bootup) VC number (starting at zero) for the mono screen.
 * subtract one from the tty/VC number (i.e. 7 is /dev/tty8)
 */

#define MONO_CONSOLE 7

/* (41a) should we blank the cursor on the active screen?  Kinda handy,
 * but comment this out if you don't like it that way.
 */

#define HIDE_NONACTIVE_CURSOR

/* (47a2) The situation: VC1 on Color Monitor, VC2 on Mono.  You press the
 *  key for Console_Color_2.  ADAPTER_SWAP determines what happens.
 *  AS_SWAP_VCS		you end up with VC2 Color, VC1 Mono.
 *  AS_FOCUSONLY: 	VC2 is focused on the MONO screen (just like Console_2)
 *  AS_NONE (or #undef) nothing happens
 */

/* don't touch these! */
#define AS_SWAP_VCS 1
#define AS_FOCUSONLY 2
#define AS_NONE 0

/* change this as described above. */
#define ADAPTER_SWAP AS_SWAP_VCS

/* undefine this if you have an MDA adapter. */
#define HGC

/* !! don't edit below this line !! */

/* adapter type for set_adapter */
enum adapter { AD_NONE, AD_COLOR, AD_MONO, AD_SWAP, AD_CURRENT };

/* function prototypes */
int set_adapter(int, enum adapter);
void change_screen(int);
int is_visible_con(int);
int get_fg_console_con(int);
void resize_console(int);
#define DUALMON_VERSION "1.1.47 alpha2 (25 Aug 94)"

#else
#define is_visible_con(x)	( x == fg_console )
#endif CONFIG_DUALMON

#endif __DUALMON_H

