.Id $Id: at.man,v 1.2 1994/03/12 18:59:45 kernel Exp kernel $
.TH AT 1 "Jan 1993" local "Linux Programmer's Manual"
.SH NAME
at, batch, atq, atrm \- queue, examine or delete jobs for later execution
.SH SYNOPSIS
.B at
.RB [ -V ]
.RB [ -q 
.IR queue ]
.RB [ -f
.IR file ]
.RB [ -mldbv ]
.B TIME
.br
.B atq
.RB [ -V ]
.RB [ -q
.IR queue ]
.RB [ -v ]
.br
.B atrm
.RB [ -V ]
.I job
.RI [ job... ]
.br
.B batch
.RB [ -V ]
.RB [ -q
.IR queue ]
.RB [ -f
.IR file ]
.RB [ -mv ]
.RB [ TIME ]
.SH DESCRIPTION
.B at
and
.B batch
read commands from standard input or a specified file which are to
be executed at a later time, using
.BR /bin/sh .
.TP 8
.BR at
executes commands at a specified time.
.TP 8
.BR atq
lists the user's pending jobs, unless the user is the superuser; in that
case, everybody's jobs are listed.
.TP 8
.BR atrm
deletes jobs.
.TP 8
.BR batch
executes commands when system load levels permit; in other words, when the load average
as read from
.I _PROC_DIR/loadavg
drops below _LOADAVG_MX, or the value specified in the invocation of
.BR atrun .
.PP
.B At
allows some moderately complex
.B TIME
specifications.  It accepts times of the form
.B HHMM
or
.B HH:MM
to run a job at a specific time of day.
(If that time is already past, the next day is assumed.)
You may also specify
.B midnight,
.B noon,
or
.B teatime
(4pm)
and you can have a time-of-day suffixed with
.B AM
or
.B PM
for running in the morning or the evening.
You can also say what day the job will be run,
by giving a date in the form
.B month-name
.B day
with an optional
.B year,
or giving a date of the form
.B MMDDYY
or
.B MM/DD/YY
or
.B DD.MM.YY.
You can also give times like
.B now
.B \+
.I count
.I time-units,
where the time-units can be
.B minutes,
.B hours,
.B days,
or
.B weeks
and you can tell
.B at
to run the job today by suffixing the time with
.B today
and to run the job tomorrow by suffixing the time with
.B tomorrow.
.PP
For example, to run a job at 4pm three days from now, you would do
.B at 4pm + 3 days,
to run a job at 10:00am on July 31, you would do
.B at 10am Jul 31
and to run a job at 1am tomorrow, you would do
.B at 1am tomorrow.
.PP
For both
.BR at " and " batch ,
commands are read from standard input or the file specified
with the
.B -f
option and executed.
The working directory, the environment (except for the variables
.BR TERM ,
.BR DISPLAY
and
.BR _ )
and the umask are retained from the time of invocation.
An
.BR "at " \-
or
.BR "batch "\-
command invoked from a 
.B su(1)
shell will retain the current userid.
The user will be mailed standard error and standard output from his
commands, if any. Mail will be sent using the command
.BR _MAIL_CMD .
If
.B at
is executed from a 
.B su(1)
shell, the owner of the login shell will receive the mail.
.PP
.SH OPTIONS
.TP 8
.B -V
prints the version number to standard error.
.TP 8
.BI \-q " queue"
uses the specified queue.
A queue designation consists of a single letter; valid queue designations
range from
.B a
to 
.BR z .
and
.B A
to
.BR Z .
The
.B a
queue is the default for
.B at
and the
.B A
queue for
.BR batch .
Queues with higher letters run with increased niceness.
If a job is submitted to a queue designated with an uppercase letter, it
is treated as if it had been submitted to batch at that time.
If
.BR atq
is given a specific queue, it will only show jobs pending in that queue.
.TP 8
.B \-m
Send mail to the user when the job has completed even if there was no
output.
.TP 8
.BI \-f " file"
Reads the job from
.BI file
rather than standard input.
.TP 8
.B \-l
Is an alias for
.B atq.
.TP
.B \-d
Is an alias for
.B atrm.
.TP
.B \-b
Is an alias for
.B batch.
.TP
.B \-v
For
.BR atq ,
shows completed but not yet deleted jobs in the queue; otherwise
shows the time the job will be executed.
.SH FILES
.I _ATJOB_DIR
.br
.I _ATSPOOL_DIR
.br
.I _PROC_DIR/loadavg
.br
.I /etc/utmp
.SH SEE ALSO
cron(1), nice(1), sh(1), umask(2), atrun(8)
.SH BUGS
Traditional access control to
.B at
and
.B batch
via the files
.I /usr/lib/at.allow
and
.I /usr/lib/at.deny
is not implemented.
.PP
The correct operation of
.B batch
for Linux depends on the presence of a
.IR proc -
type directory mounted on
.IR _PROC_DIR .
.PP
If the file
.I /etc/utmp
is not available or corrupted, or if the user is not logged on at the
time 
.B at
is invoked, the mail is sent to the userid found
in the environment variable
.BR LOGNAME .
If that is undefined or empty, the current userid is assumed.
.PP
.B At
and
.B batch
as presently implemented
are not suitable when users are competing for resources.
