#!/usr/bin/perl

$u = 1200;
$ux = $u*1.5;
$uy = $u/4;
$gap = 0.4;
$mu = 0.2;
$ruy = $uy; # labels should not be affected by yscale

$pi = atan2(1,1)*4;


sub lookup_label
{
    local ($n) = @_;
    local ($i,$j);

    for ($i = 0; $i <= $#cols; $i++) {
	return $i if $cols[$i] eq $n;
    }
    undef $j;
    for ($i = 0; $i <= $#cols; $i++) {
	if (substr($cols[$i],0,length($n)) eq $n) {
	    return undef if defined($j);
	    $j = $i;
	}
    }
    return $j;
}


$y = 0;
while (<>) {
    chop;
    next if /^[#;]/;
    next if /^\s*$/;
    @i = split(/\s+/,$_);
    if ($i[0] eq "labels") {
	shift(@i);
	@cols = @i;
    }
    elsif ($i[0] eq "write") {
	shift(@i);
	push(@lbl,join(" ",@i));
	push(@src,"");
	push(@dst,"");
	push(@y,$y+1);
	push(@dy,0);
	$y += 2;
    }
    elsif ($i[0] eq "left") {
	shift(@i);
	push(@lbl,join(" ",@i));
	push(@src,"-");
	push(@dst,"");
	$y += 0.5;
	push(@y,$y);
	push(@dy,0);
    }
    elsif ($i[0] eq "xscale") {
	$ux *= $i[1];
    }
    elsif ($i[0] eq "yscale") {
	$uy *= $i[1];
    }
    elsif ($i[0] eq "ystep") {
	$y += $i[1];
	undef %last;
    }
    elsif ($i[0] eq "before") {
	undef %last;
	$y = $prev[$#prev-($i[1] ? $i[1] : 1)+1];
    }
    else {
	push(@prev,$y);
	if ($i[0] eq "-") { shift(@i); }
	else {
	    undef %last;
	    $y += $gap;
	}
	$last = "";
	undef %this;
	$i[1] .= "->";
	while ($i[1] =~ /([-=])>/) {
	    $i[1] = $';
	    if ($last ne "") {
		if (defined $last{$last}) { $t = $last{$last}+$gap; }
		else {
		    $t = $y;
		    $y += $last_dy;
		}
		push(@lbl,$i[0]);
		push(@src,$last);
		push(@dst,$`);
		push(@y,$t);
		push(@dy,$last_dy);
		$this{$last} = $t;
		$this{$`} = $t+$last_dy;
	    }
	    $last = $`;
	    $last_dy = $1 eq "-" ? 1 : 0;
	}
	$y += $gap unless $dy[$#dy];
	for (keys %this) { $last{$_} = $this{$_}; }
    }
}
print "#FIG 3.1\n";
print "Portrait\nCenter\nInches\n$u 2\n";
for (0..$#cols) {
    #      text       Helvetica     length
    #      | centered |  12pt       |
    #      | | defcol |  |  angle   |
    #      | | |  depth  |  | PostScript+rigid
    #      | | |  | pen  |  | | height
    print "4 1 -1 1 0 16 12 0 5 1.0 1.0 ";
    printf("%d %d ",$ux*($_+1),-1.5*$ruy); # x y
    print "$cols[$_]\\001\n";
    #      polyline    defcol   style   fwd arr
    #      | polyline  | depth  | Miter | bwd arr
    #      | | solid   | | pen  | | Butt| | points
    #      | | | thickness | nofill | radius|
    #      | | | | defcol| | |  | | | | | | |
    print "2 1 0 1 -1 -1 5 0 -1 0 0 0 0 0 0 2\n";
    printf("  %d %d %d %d\n",$ux*($_+1),-0.5*$ruy,$ux*($_+1),$uy*($y+0.5));
}
for (0..$#lbl) {
    next if $src[$_] ne "";
    #      text       Helvetica     length
    #      | centered |  16pt       |
    #      | | defcol |  |  angle   |
    #      | | |  depth  |  | PS+rigid
    #      | | |  | pen  |  | | height
    print "4 1 -1 1 0 16 16 0 5 1.0 1.0 ";
    printf("%d %d ",$ux*($#cols/2+1),$uy*($y[$_]+0.5)); # x y
    print "$lbl[$_]\\001\n" unless $lbl[$_] eq "";
    print " \\001\n" if $lbl[$_] eq "";
}
for (0..$#lbl) {
    if ($src[$_] eq "-") {
	#      text       Helvetica     length
	#      | centered |  10pt       |
	#      | | defcol |  |  angle   |
	#      | | |  depth  |  | PS+rigid
	#      | | |  | pen  |  | | height
	print "4 1 -1 1 0 16 10 0 5 1.0 1.0 ";
	printf("%d %d ",$ux/2,$uy*($y[$_]+0.5)); # x y
	print "$lbl[$_]\\001\n";
	next;
    }
    next if $src[$_] eq "";
    $y = $y[$_];
    $dy = $dy[$_]*$uy;
    #      polyline    defcol   style   fwd arr
    #      | polyline  | depth  | Miter | bwd arr
    #      | | solid   | | pen  | | Butt| | points
    #      | | | thickness | nofill | radius|
    #      | | | | defcol| | |  | | | | | | |
    print "2 1 0 1 -1 -1 5 0 -1 0 0 0 0 1 0 2\n";
    #        triangle height
    #        | filled |
    #        | | thick|
    #        | | | width
    print "  1 1 1 70 70\n";
    $a = &lookup_label($src[$_]);
    die "bad label $src[$_]" unless defined($a);
    $b = &lookup_label($dst[$_]);
    die "bad label $dst[$_]" unless defined($b);
    printf("  %d %d %d %d\n",$ux*($a+1),$uy*$y,$ux*($b+1),$uy*$y+$dy);
    #      text       Helvetica
    #      | centered |  10pt
    #      | | defcol |  |
    #      | | |  depth  |
    #      | | |  | pen  |
    print "4 1 -1 1 0 16 10 ";
    # angle
    $r = $a > $b ? atan2($dy,($a-$b)*$ux) : atan2(-$dy,($b-$a)*$ux);
    $d = $mu*$ruy;
    printf("%f ",$r);
    #      PostScript+rigid
    #      | height
    #      | |   length
    print "5 1.0 1.0 ";
    printf("%d %d ",$ux*(($a+$b)/2+1),$uy*$y+$dy/2-$d); # x y
    print "$lbl[$_]\\001\n";
}
