/* read.c - receive AAL5 PDU */

/* Written 1995 by Werner Almesberger, EPFL-LRC */


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/atm.h>


int main(int argc,char **argv)
{
    struct sockaddr_atmpvc addr;
    int s;

    if (argc != 4) {
	fprintf(stderr,"usage: %s itf vpi vci\n",argv[0]);
	return 1;
    }
    if ((s = socket(PF_ATMPVC,SOCK_DGRAM,ATM_AAL5)) < 0) {
	perror("socket");
	return 1;
    }
    memset(&addr,0,sizeof(addr));
    addr.sap_family = AF_ATMPVC;
    addr.sap_addr.itf = atoi(argv[1]);
    addr.sap_addr.vpi = atoi(argv[2]);
    addr.sap_addr.vci = atoi(argv[3]);
    addr.sap_rxtp.class = ATM_UBR;
    if (bind(s,(struct sockaddr *) &addr,sizeof(addr)) < 0) {
	perror("bind");
	return 1;
    }
    while (1) {
#define BSIZE 1024
	unsigned char buf[BSIZE+4096];
	unsigned char *start;
	int size,i;

	start = (unsigned char *) (((unsigned long) buf+4095) & ~4095U);
	size = read(s,start,BSIZE);
	printf("%d(%s):",size,strerror(errno));
	for (i = 0; i < size; i++) printf(" %02X",start[i]);
	putchar('\n');
    }
}
