/* table.h - ATMARP table */
 
/* Written 1995 by Werner Almesberger, EPFL-LRC */
 

#ifndef TABLE_H
#define TABLE_H

#include <linux/atm.h>

#include "atmd.h"


typedef enum { vs_none,vs_discover,vs_reval,vs_valid,vs_connecting,vs_svc }
  VCC_STATE;

typedef struct _vcc {
    VCC_STATE state;
    int fd;
    int flags;
    TIMER *timer;
    int retries;
    struct _entry *entry;
    struct _vcc *prev,*next;
} VCC;

typedef enum { as_none,as_res_wait,as_resolv,as_unknown,as_valid } ADDR_STATE;

typedef struct _entry {
    ADDR_STATE state;
    unsigned long ip;
    struct sockaddr_atmsvc *addr; /* NULL if none */
    int flags;
    TIMER *timer;
    int retries;
    struct _vcc *vccs;
    struct _itf *itf;
    struct _entry *prev,*next;
} ENTRY;

typedef struct _itf {
    unsigned long local_ip; /* @@@ */
    struct sockaddr_atmsvc local_addr; /* @@@ */
    int number;
    ENTRY *table;
    ENTRY *arp_srv; /* NULL is none */
    struct _itf *prev,*next;
} ITF;


/*
 * May want to consider using one big unified table instead of lots of small
 * tables (one per interface).
 */


extern const char *entry_state_name[];
extern const char *vcc_state_name[];

extern ITF *itfs;
extern VCC *pending;


ENTRY *lookup_ip(const ITF *itf,unsigned long ip);
ENTRY *lookup_addr(const ITF *itf,const struct sockaddr_atmsvc *addr);

void dump_itf(ITF *itf);
void dump_all(void);

#endif
