CC=cc
CFLAGS_NOWARN=-g -DVERSION=\"`cat ../VERSION`\" $(INCLUDES) -I../lib
CFLAGS_NOOPT=$(CFLAGS_NOWARN) -Wall -Wshadow -Wpointer-arith -Wcast-align \
  -Wwrite-strings -Wstrict-prototypes -Wmissing-prototypes \
  -Wmissing-declarations #-Wconversion (breaks inline)
CFLAGS_OPT=#-O
CFLAGS=$(CFLAGS_NOOPT) $(CFLAGS_OPT)
CFLAGS_LEX=$(CFLAGS_NOWARN) $(CFLAGS_OPT)
CFLAGS_YACC=$(CFLAGS_NOWARN) $(CFLAGS_OPT) -DYY_USE_CONST
LDFLAGS=
LDLIBS=-L../lib -latm
YACC=bison -y -d #-v
INSTPREFIX=/usr/local
INSTBIN=$(INSTPREFIX)/bin
INSTMAN=$(INSTPREFIX)/man/man8

LINK.c = $(CC) $(LDFLAGS)

all:
		[ ! -r .checker ] || $(MAKE) clean
		$(MAKE) do_all

do_all:		$(PGMS)

checker:
		[ -r .checker ] || $(MAKE) clean
		$(MAKE) do_checker

do_checker:
		CC=checkergcc $(MAKE) -e do_all
		touch .checker

install:
		for n in $(PGMS); do \
		  install -c -m 0755 $$n $(INSTBIN) || exit; done
		for n in $(MANS); do \
		  install -c -m 0644 $$n $(INSTMAN) || exit; done

depend:
		$(CPP) -M *.c $(INCLUDES) -I../lib >.tmpdepend
		mv .tmpdepend .depend

clean:
		rm -f *.o core .checker y.tab.h y.tab.c lex.yy.c $(TRASH)

spotless:	clean
		rm -f $(PGMS) *.a

lex.yy.o:	lex.yy.c y.tab.h
		$(CC) -c $(CFLAGS_LEX) lex.yy.c

y.tab.o:	y.tab.c
		$(CC) -c $(CFLAGS_YACC) y.tab.c

$(PGMS) dummy:	../lib/libatm.a

ifeq (.depend,$(wildcard .depend))
include .depend
endif
